/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.swingxx;

import bibliothek.gui.DockFrontend;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.event.DockFrontendAdapter;
import com.timestored.qstudio.UpdateHelper;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;

public class ToggleDockableMenuItem
extends JCheckBoxMenuItem {
    private static final long serialVersionUID = 1L;

    public ToggleDockableMenuItem(final Dockable observed, final DockFrontend frontend, final String name) {
        super(observed.getTitleText(), observed.getTitleIcon());
        this.setName(name);
        frontend.addFrontendListener(new DockFrontendAdapter(){

            @Override
            public void shown(DockFrontend f, Dockable dockable) {
                if (dockable == observed) {
                    ToggleDockableMenuItem.this.setSelected(true);
                    UpdateHelper.registerEvent("dok_show" + name);
                }
            }

            @Override
            public void hidden(DockFrontend f, Dockable dockable) {
                if (dockable == observed) {
                    ToggleDockableMenuItem.this.setSelected(false);
                    UpdateHelper.registerEvent("dok_hide" + name);
                }
            }
        });
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UpdateHelper.registerEvent("dok_" + (ToggleDockableMenuItem.this.isSelected() ? "show" : "hide") + name);
                if (ToggleDockableMenuItem.this.isSelected()) {
                    frontend.show(observed);
                } else {
                    frontend.hide(observed);
                }
            }
        });
        this.setSelected(frontend.isShown(observed));
    }
}

