/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.swingxx;

import ch.rabanti.nanoxlsx4j.Workbook;
import ch.rabanti.nanoxlsx4j.exceptions.IOException;
import ch.rabanti.nanoxlsx4j.styles.BasicStyles;
import java.awt.Desktop;
import java.io.File;
import java.io.FileWriter;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.renderer.StringValue;

public class TableExporter {
    private static final Logger LOG = Logger.getLogger(TableExporter.class.getName());
    private static final String NL = "\r\n";

    private static void saveToExcel(ResultSet rs2, String query, StringValue stringValue, boolean openFile, boolean openEmail) {
        if (rs2 != null && Desktop.isDesktopSupported()) {
            Executors.newSingleThreadExecutor().execute(() -> {
                try {
                    Desktop desktop;
                    File f = File.createTempFile("document", ".xlsx");
                    String[][] info = new String[][]{{"QStudio", "https://www.timestored.com/qstudio/"}, {"Query", "" + query}, {"Date", new Date().toString()}};
                    TableExporter.generateWorkbook(rs2, f, info, stringValue);
                    if (openFile) {
                        Desktop.getDesktop().open(f);
                    }
                    if (openEmail && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.MAIL)) {
                        String fp = URLEncoder.encode(f.getAbsolutePath(), StandardCharsets.UTF_8.toString());
                        String body = fp + "%0A%0A";
                        for (int r = 0; r < info.length; ++r) {
                            String st2 = info[r][0] + "=" + info[r][1];
                            body = body + "%0A" + URLEncoder.encode(st2, StandardCharsets.UTF_8.toString());
                        }
                        URI mailto = new URI("mailto:?subject=qStudio%20XLS&body=" + body);
                        desktop.mail(mailto);
                    }
                }
                catch (Exception e) {
                    String msg = "Error saving file: ";
                    LOG.log(Level.SEVERE, msg, e);
                    JOptionPane.showMessageDialog(null, msg, "Error Saving", 0);
                }
            });
        }
    }

    public static void emailExcelForUser(ResultSet rs2, String query, StringValue stringValue) {
        TableExporter.saveToExcel(rs2, query, stringValue, false, true);
    }

    public static void saveToExcelAndOpen(ResultSet rs2, String query, StringValue stringValue) {
        TableExporter.saveToExcel(rs2, query, stringValue, true, false);
    }

    public static void saveToExcel(ResultSet rs2, String query, StringValue stringValue) {
        TableExporter.saveToExcel(rs2, query, stringValue, false, false);
    }

    private static int generateWorkbook(ResultSet rs2, File f, String[][] info, StringValue stringValue) throws SQLException, IOException {
        Workbook workbook = new Workbook(f.getAbsolutePath(), "Sheet1");
        ResultSetMetaData rsmd = rs2.getMetaData();
        int cn = rsmd.getColumnCount();
        for (int c2 = 1; c2 <= cn; ++c2) {
            workbook.WS.value(rsmd.getColumnName(c2), BasicStyles.Bold());
        }
        workbook.WS.down();
        int row = 0;
        rs2.beforeFirst();
        row = 0;
        while (rs2.next()) {
            for (int c3 = 1; c3 <= cn; ++c3) {
                String s = "";
                Object o = rs2.getObject(c3);
                if (o != null) {
                    s = stringValue.getString(o);
                }
                if (o instanceof Number && !s.trim().isEmpty()) {
                    workbook.WS.value(o);
                    continue;
                }
                workbook.WS.value(s);
            }
            workbook.WS.down();
            ++row;
        }
        if (info != null) {
            workbook.addWorksheet("QStudio");
            String[][] stringArray = info;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String[] rowSt;
                for (String c4 : rowSt = stringArray[i]) {
                    workbook.WS.value(c4);
                }
                workbook.WS.down();
            }
        }
        workbook.save();
        return row;
    }

    public static void generateWorkbook(JTable table, StringValue stringValue, File f, boolean selectedAreaOnly, boolean includeHeaders) throws IOException {
        Workbook workbook = new Workbook(f.getAbsolutePath(), "Sheet1");
        int c2 = 0;
        int r = 0;
        int cEnd = table.getColumnCount();
        int rEnd = table.getRowCount();
        if (selectedAreaOnly) {
            c2 = table.getSelectedColumn();
            cEnd = c2 + table.getSelectedColumnCount();
            r = table.getSelectedRow();
            rEnd = r + table.getSelectedRowCount();
            if (c2 == -1) {
                return;
            }
        }
        if (includeHeaders) {
            for (int ci = c2; ci < cEnd; ++ci) {
                workbook.WS.value(table.getColumnName(ci), BasicStyles.Bold());
            }
            workbook.WS.down();
        }
        int rows = 0;
        for (int ri = r; ri < rEnd; ++ri) {
            ++rows;
            for (int ci = c2; ci < cEnd; ++ci) {
                int modelCi = table.convertColumnIndexToModel(ci);
                int modelRi = table.convertRowIndexToModel(ri);
                Object o = table.getModel().getValueAt(modelRi, modelCi);
                String s = "";
                if (o != null) {
                    String string = s = stringValue == null ? o.toString() : stringValue.getString(o);
                }
                if (o instanceof Number && !s.trim().isEmpty()) {
                    workbook.WS.value(o);
                    continue;
                }
                workbook.WS.value(s);
            }
            if (ri == rEnd - 1) continue;
            workbook.WS.down();
        }
        workbook.addWorksheet("QStudio");
        workbook.WS.value("QStudio");
        workbook.WS.value("https://www.timestored.com/qstudio");
        workbook.WS.down();
        workbook.WS.value("Rows");
        workbook.WS.value("" + rows);
        workbook.WS.down();
        workbook.save();
    }

    public static void saveTable(JXTable table, StringValue stringValue, boolean selectedAreaOnly, boolean includeHeaders, String separator, File f) throws java.io.IOException {
        LOG.info("writing out to: " + f);
        FileWriter out = new FileWriter(f);
        out.write(TableExporter.getTable(table, stringValue, selectedAreaOnly, includeHeaders, ","));
        out.close();
    }

    private static int[] range(int floor, int ceiling) {
        int[] nums = new int[ceiling - floor];
        for (int i = floor; i < ceiling; ++i) {
            nums[i] = i;
        }
        return nums;
    }

    public static String getTable(JXTable table, StringValue stringValue, boolean selectedAreaOnly, boolean includeHeaders, String separator) {
        int c2 = 0;
        int cEnd = table.getColumnCount();
        int[] rows = TableExporter.range(0, table.getRowCount());
        if (selectedAreaOnly) {
            if (table.getSelectionMode() == 1) {
                c2 = table.getSelectedColumn();
                cEnd = c2 + table.getSelectedColumnCount();
            }
            rows = table.getSelectedRows();
            if (c2 == -1) {
                return "";
            }
        }
        StringBuffer sb = new StringBuffer();
        if (includeHeaders) {
            for (int ci = c2; ci < cEnd; ++ci) {
                sb.append(table.getColumnName(ci));
                if (ci == cEnd - 1) continue;
                sb.append(separator);
            }
            sb.append(NL);
        }
        for (int ri : rows) {
            for (int ci = c2; ci < cEnd; ++ci) {
                int modelCi = table.convertColumnIndexToModel(ci);
                int modelRi = table.convertRowIndexToModel(ri);
                Object o = table.getModel().getValueAt(modelRi, modelCi);
                String s = "";
                if (o != null) {
                    String string = s = stringValue == null ? o.toString() : stringValue.getString(o);
                    if (c2 + 1 == cEnd && rows.length == 1 && selectedAreaOnly && !includeHeaders) {
                        return TableExporter.unescape(s);
                    }
                    if (s.contains(",")) {
                        s = "\"" + s + "\"";
                    }
                    if (o instanceof Number && !s.trim().isEmpty()) {
                        s = "" + o;
                    }
                }
                sb.append(s);
                if (ci == cEnd - 1) continue;
                sb.append(separator);
            }
            if (ri == rows[rows.length - 1]) continue;
            sb.append(NL);
        }
        return sb.toString();
    }

    public static String unescape(String qCode) {
        return qCode.replace("\\\\", "\\").replace("\\t", "\t").replace("\\r", "\r").replace("\\n", "\n").replace("\\\"", "\"");
    }
}

