/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.swingxx;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.logging.Logger;
import javax.swing.JComponent;

public class TabbedPaneRightClickBlocker {
    private static final Logger LOG = Logger.getLogger(TabbedPaneRightClickBlocker.class.getName());

    public static void install(JComponent tabbedPane) {
        MouseListener handler = TabbedPaneRightClickBlocker.findUIMouseListener(tabbedPane);
        if (handler != null) {
            tabbedPane.removeMouseListener(handler);
            tabbedPane.addMouseListener(new MouseListenerWrapper(handler));
        }
    }

    private static MouseListener findUIMouseListener(JComponent tabbedPane) {
        MouseListener[] listeners;
        for (MouseListener l : listeners = tabbedPane.getMouseListeners()) {
            if (!l.getClass().getName().contains("$Handler")) continue;
            return l;
        }
        return null;
    }

    private static class MouseListenerWrapper
    implements MouseListener {
        private final MouseListener delegate;

        public MouseListenerWrapper(MouseListener delegate) {
            this.delegate = delegate;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.isPopupTrigger()) {
                return;
            }
            try {
                this.delegate.mouseClicked(e);
            }
            catch (NullPointerException npe) {
                LOG.fine("NullPointerException from RightClickBlocker delegate" + npe.getLocalizedMessage());
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                return;
            }
            try {
                this.delegate.mousePressed(e);
            }
            catch (NullPointerException npe) {
                LOG.fine("NullPointerException from RightClickBlocker delegate" + npe.getLocalizedMessage());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                return;
            }
            try {
                this.delegate.mouseReleased(e);
            }
            catch (NullPointerException npe) {
                LOG.fine("NullPointerException from RightClickBlocker delegate" + npe.getLocalizedMessage());
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (e.isPopupTrigger()) {
                return;
            }
            try {
                this.delegate.mouseEntered(e);
            }
            catch (NullPointerException npe) {
                LOG.fine("NullPointerException from RightClickBlocker delegate" + npe.getLocalizedMessage());
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (e.isPopupTrigger()) {
                return;
            }
            try {
                this.delegate.mouseExited(e);
            }
            catch (NullPointerException npe) {
                LOG.fine("NullPointerException from RightClickBlocker delegate" + npe.getLocalizedMessage());
            }
        }
    }
}

