/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.swingxx;

import com.google.common.base.Preconditions;
import com.timestored.StringUtils;
import com.timestored.messages.Msg;
import com.timestored.misc.IOUtils;
import com.timestored.theme.Theme;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.plaf.FontUIResource;

public class SwingUtils {
    public static final KeyStroke ESC_KEYSTROKE = KeyStroke.getKeyStroke(27, 0);
    private static final Logger LOG = Logger.getLogger(SwingUtils.class.getName());

    public static void addEscapeCloseListener(final JDialog dialog) {
        SwingUtils.putEscapeAction(dialog.getRootPane(), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowEvent wev = new WindowEvent(dialog, 201);
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(wev);
            }
        });
        dialog.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    WindowEvent wev = new WindowEvent(dialog, 201);
                    Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(wev);
                }
                super.keyPressed(e);
            }
        });
    }

    public static Component verticalScrollPane(Component c2) {
        return new JScrollPane(c2, 20, 31);
    }

    public static void forceToFront(JFrame frame) {
        frame.setState(0);
        frame.toFront();
        frame.setAlwaysOnTop(true);
        frame.setAlwaysOnTop(false);
        frame.repaint();
    }

    public static JFrame getPopupFrame(Component parent, String title, Component content, Image icon) {
        JFrame f = new JFrame(StringUtils.abbreviate(title, 80));
        f.setIconImage(icon);
        f.setLayout(new BorderLayout());
        f.add(content);
        SwingUtils.setSensibleDimensions(parent, f);
        return f;
    }

    public static void showAppDialog(Component parent, String title, JPanel contentPanel, Image icon) {
        JDialog d = new JDialog();
        SwingUtils.addEscapeCloseListener(d);
        d.setIconImage(icon);
        d.setTitle(title);
        d.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        d.setLayout(new BorderLayout());
        d.add(contentPanel);
        SwingUtils.setSensibleDimensions(parent, d);
        d.setLocationRelativeTo(parent);
        d.setVisible(true);
    }

    public static void setSensibleDimensions(Component parent, Window w, int defWidth, int defHeight) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        if (parent != null) {
            Insets si = tk.getScreenInsets(parent.getGraphicsConfiguration());
            defWidth = Math.max(700, (tk.getScreenSize().width - si.left - si.right) * 3 / 5);
            defHeight = (tk.getScreenSize().height - si.top - si.bottom) * 4 / 5;
        }
        w.setSize(defWidth, defHeight);
    }

    public static void setSensibleDimensions(Component parent, Window w) {
        SwingUtils.setSensibleDimensions(parent, w, 600, 400);
    }

    private static void putEscapeAction(JComponent com, Action action) {
        ActionMap am = com.getActionMap();
        InputMap im = com.getInputMap(1);
        am.put("escapeAction", action);
        im.put(ESC_KEYSTROKE, "escapeAction");
    }

    public static void showMessageDialog(Component parentComponent, String message, String title, int messageType) {
        String[] st2 = message.split("\r");
        int lineCount = st2.length;
        int maxLineLength = 0;
        for (String r : st2) {
            if (r.length() <= maxLineLength) continue;
            maxLineLength = r.length();
        }
        String style = maxLineLength > 100 ? " style='width: 600px;'" : "";
        Object msg = "<html><body><p" + style + ">" + message + "</body></html>";
        if (lineCount > 15 || message.length() > 800) {
            JTextArea textArea = new JTextArea(15, 70);
            textArea.setText(message);
            textArea.setEditable(false);
            msg = new JScrollPane(textArea);
        }
        JOptionPane.showMessageDialog(parentComponent, msg, title, messageType);
    }

    public static void offerToOpenFile(String message, File file, String optionOpen, String optionClose) {
        Object[] options = new String[]{optionOpen, optionClose};
        int option = JOptionPane.showOptionDialog(null, message, "Open File?", 2, 1, Theme.CIcon.TEXT_HTML.get32(), options, options[0]);
        if (option == 0) {
            try {
                Desktop.getDesktop().open(file);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, "Problem opening output file, try browsing to folder manually and opening there");
            }
        }
    }

    public static File askUserSaveLocation(File fileOrFolder, String ... filetypeExtension) {
        return SwingUtils.askUserSaveLocation(fileOrFolder, null, filetypeExtension);
    }

    public static File askUserSaveLocation(File fileOrFolder, JComponent newAccessory, String ... filetypeExtension) {
        boolean hasFileTypes;
        JFileChooser fc = null;
        fc = fileOrFolder != null && fileOrFolder.isDirectory() ? new JFileChooser(fileOrFolder) : new JFileChooser();
        if (fileOrFolder != null && fileOrFolder.isFile()) {
            fc.setSelectedFile(fileOrFolder);
        }
        boolean bl = hasFileTypes = filetypeExtension != null && filetypeExtension.length > 0;
        if (hasFileTypes) {
            if (filetypeExtension[0].trim().length() > 0) {
                FileNameExtensionFilter firstFilter = new FileNameExtensionFilter(filetypeExtension[0], filetypeExtension[0]);
                fc.setFileFilter(firstFilter);
                fc.addChoosableFileFilter(firstFilter);
            }
            for (int i = 1; i < filetypeExtension.length; ++i) {
                fc.addChoosableFileFilter(new FileNameExtensionFilter(filetypeExtension[i], filetypeExtension[i]));
            }
        }
        fc.setApproveButtonText(Msg.get(Msg.Key.SAVE));
        fc.setDialogTitle(Msg.get(Msg.Key.SAVE_FILE));
        if (newAccessory != null) {
            fc.setAccessory(newAccessory);
        }
        if (fc.showSaveDialog(null) == 0) {
            File f = fc.getSelectedFile();
            if (hasFileTypes && !f.getName().contains(".") && fc.getFileFilter() != null) {
                f = new File(f.getAbsolutePath() + "." + fc.getFileFilter().getDescription());
            }
            return f;
        }
        LOG.info(Msg.get(Msg.Key.SAVE_CANCELLED));
        return null;
    }

    public static File askUserAndSave(File file, String content, String ... filetypeExtension) {
        Preconditions.checkNotNull(content);
        File f = SwingUtils.askUserSaveLocation(file, filetypeExtension);
        if (f != null) {
            try {
                IOUtils.writeStringToFile(content, f);
            }
            catch (IOException e) {
                String msg = Msg.get(Msg.Key.ERROR_SAVING) + ": " + f;
                LOG.info(msg);
                JOptionPane.showMessageDialog(null, msg, Msg.get(Msg.Key.ERROR_SAVING), 0);
            }
        }
        return f;
    }

    public static void adjustAllFonts(float sizeMultiplier) {
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (value == null || !(value instanceof FontUIResource)) continue;
            FontUIResource existingFont = (FontUIResource)value;
            float newFontSize = (float)existingFont.getSize() * sizeMultiplier;
            Font newFont = existingFont.deriveFont(newFontSize);
            UIManager.put(key, newFont);
        }
    }
}

