/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.swingxx;

import com.timestored.qstudio.QStudioFrame;
import com.timestored.sqldash.chart.TableFactory;
import com.timestored.swingxx.AAction;
import com.timestored.swingxx.TableExporter;
import com.timestored.theme.Theme;
import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.renderer.StringValue;

public class SaveTableMouseAdapter
extends MouseAdapter {
    private static final Logger LOG = Logger.getLogger(SaveTableMouseAdapter.class.getName());
    private static final int TRANSPOSE_ROW_LIMIT = 500;
    private final JXTable table;
    private final StringValue stringValue;
    private final ImageIcon csvIcon;

    public SaveTableMouseAdapter(JXTable table, ImageIcon csvIcon) {
        this(table, csvIcon, null);
    }

    public SaveTableMouseAdapter(final JXTable table, ImageIcon csvIcon, final StringValue stringValue) {
        this.table = table;
        this.stringValue = stringValue;
        this.csvIcon = csvIcon;
        String property = stringValue != null ? stringValue.toString() : null;
        table.setTransferHandler(new TransferHandler(property){

            @Override
            public void exportToClipboard(JComponent comp, Clipboard clip, int action) throws IllegalStateException {
                if (action == 1) {
                    boolean areaSelected = table.getSelectedRow() != -1;
                    StringSelection selection = new StringSelection(TableExporter.getTable(table, stringValue, areaSelected, false, "\t"));
                    clip.setContents(selection, selection);
                    this.exportDone(comp, selection, action);
                } else {
                    super.exportToClipboard(comp, clip, action);
                }
            }
        });
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            if (this.table.getSelectedColumnCount() <= 1 && this.table.getSelectedRowCount() <= 1) {
                int row = this.table.rowAtPoint(e.getPoint());
                int col = this.table.columnAtPoint(e.getPoint());
                this.table.setColumnSelectionInterval(col, col);
                this.table.setRowSelectionInterval(row, row);
            }
            JPopupMenu menu = new JPopupMenu();
            boolean areaSelected = this.table.getSelectedRow() != -1;
            ImageIcon icon = Theme.CIcon.TABLE_PIVOT.get16();
            menu.add(new AAction("Transpose Row(s)", icon, ae -> {
                int[] rows = this.table.getSelectedRows();
                int rowsUsed = Math.min(rows.length, 500);
                if (rowsUsed == 500) {
                    LOG.warning("Maximum rows transposed possible. More than 500 columns is useless to look at.");
                }
                int[] translatedRows = new int[rowsUsed];
                for (int i = 0; i < translatedRows.length; ++i) {
                    translatedRows[i] = this.table.convertRowIndexToModel(rows[i]);
                }
                TableFactory.TransposedTableModel tranTableModel = new TableFactory.TransposedTableModel(this.table, rows);
                JScrollPane tranTableSc = TableFactory.getTable(tranTableModel, null);
                Window w = SwingUtilities.getWindowAncestor(this.table);
                QStudioFrame.showPopup(w, tranTableSc, "Transposed", icon.getImage());
            }));
            menu.addSeparator();
            menu.add(new CopyToClipboardAction("Copy Table", false, true));
            menu.add(new CopyToClipboardAction("Copy Selection", true, false)).setEnabled(areaSelected);
            menu.add(new CopyToClipboardAction("Copy Selection with Column Titles", true, true)).setEnabled(areaSelected);
            menu.add(new ExportAsCsvAction("Export Table", false, true));
            menu.add(new ExportAsCsvAction("Export Selection", true, false)).setEnabled(areaSelected);
            menu.add(new ExportAsCsvAction("Export Selection with Column Titles", true, true)).setEnabled(areaSelected);
            menu.add(new ExportAsXlsAction("Export XLS", false, true));
            menu.add(new ExportAsXlsAction("XLS Selection with Column Titles", true, true)).setEnabled(areaSelected);
            menu.add(new ExportAsXlsAndEmailAction("XLS Email"));
            menu.show(e.getComponent(), e.getX(), e.getY());
            menu.setVisible(true);
        }
        super.mouseReleased(e);
    }

    private class CopyToClipboardAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private final boolean selectedAreaOnly;
        private final boolean includeHeaders;

        private CopyToClipboardAction(String name, boolean selectedAreaOnly, boolean includeHeaders) {
            super(name);
            this.selectedAreaOnly = selectedAreaOnly;
            this.includeHeaders = includeHeaders;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            String s = TableExporter.getTable(SaveTableMouseAdapter.this.table, SaveTableMouseAdapter.this.stringValue, this.selectedAreaOnly, this.includeHeaders, "\t");
            StringSelection selection = new StringSelection(s);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(selection, selection);
        }
    }

    private class ExportAsXlsAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private final boolean selectedAreaOnly;
        private final boolean includeHeaders;

        public ExportAsXlsAction(String name, boolean selectedAreaOnly, boolean includeHeaders) {
            super(name, Theme.CIcon.XLSX.get());
            this.selectedAreaOnly = selectedAreaOnly;
            this.includeHeaders = includeHeaders;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            try {
                File f = File.createTempFile("document", ".xlsx");
                TableExporter.generateWorkbook(SaveTableMouseAdapter.this.table, SaveTableMouseAdapter.this.stringValue, f, this.selectedAreaOnly, this.includeHeaders);
                Desktop.getDesktop().open(f);
            }
            catch (Exception e) {
                String msg = "Error saving file: ";
                LOG.log(Level.SEVERE, msg, e);
            }
        }
    }

    private class ExportAsXlsAndEmailAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public ExportAsXlsAndEmailAction(String name) {
            super(name, Theme.CIcon.EMAIL_ATTACH.get());
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            try {
                Desktop desktop;
                File f = File.createTempFile("document", ".xlsx");
                TableExporter.generateWorkbook(SaveTableMouseAdapter.this.table, SaveTableMouseAdapter.this.stringValue, f, false, true);
                if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.MAIL)) {
                    String tbl = TableExporter.getTable(SaveTableMouseAdapter.this.table, SaveTableMouseAdapter.this.stringValue, false, true, "\t");
                    String fp = URLEncoder.encode(f.getAbsolutePath(), StandardCharsets.UTF_8.toString());
                    String[] rows = tbl.split("\n");
                    String body = fp + "%0A%0A" + SaveTableMouseAdapter.this.table.getRowCount() + "%20rows.%20Sample%3A";
                    for (int r = 0; r < Math.min(3, rows.length); ++r) {
                        body = body + "%0A" + URLEncoder.encode(rows[r], StandardCharsets.UTF_8.toString());
                    }
                    URI mailto = new URI("mailto:?subject=qStudio%20XLS&body=" + body);
                    desktop.mail(mailto);
                }
            }
            catch (Exception e) {
                String msg = "Error saving file: ";
                LOG.log(Level.SEVERE, msg, e);
            }
        }
    }

    private class ExportAsCsvAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private final boolean selectedAreaOnly;
        private final boolean includeHeaders;

        public ExportAsCsvAction(String name, boolean selectedAreaOnly, boolean includeHeaders) {
            super(name, SaveTableMouseAdapter.this.csvIcon);
            this.selectedAreaOnly = selectedAreaOnly;
            this.includeHeaders = includeHeaders;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            try {
                File f = File.createTempFile("document", ".csv");
                TableExporter.saveTable(SaveTableMouseAdapter.this.table, SaveTableMouseAdapter.this.stringValue, this.selectedAreaOnly, this.includeHeaders, ",", f);
                Desktop.getDesktop().open(f);
            }
            catch (IOException e) {
                String msg = "Error saving file: ";
                LOG.log(Level.SEVERE, msg, e);
                JOptionPane.showMessageDialog(null, msg, "Error Saving", 0);
            }
        }
    }
}

