/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.swingxx;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import org.jdesktop.swingx.JXStatusBar;

public class QueryStatusBar
extends JXStatusBar {
    private static final long serialVersionUID = 1L;
    private long startTick;
    private final JProgressBar pbar;
    private final JLabel statusLabel = new JLabel("Ready");
    private final JLabel rowCountLabel;
    private final JLabel timingLabel;

    public QueryStatusBar() {
        JXStatusBar.Constraint fillConstraint = new JXStatusBar.Constraint(JXStatusBar.Constraint.ResizeBehavior.FILL);
        JXStatusBar.Constraint fixedWidthConstraint = new JXStatusBar.Constraint();
        fixedWidthConstraint.setFixedWidth(100);
        this.pbar = new JProgressBar();
        this.rowCountLabel = new JLabel("Count = 0  ");
        this.timingLabel = new JLabel("Time = 0 ms   ");
        this.add((Component)this.statusLabel, fillConstraint);
        this.add(this.rowCountLabel);
        this.add(this.timingLabel);
        this.add((Component)this.pbar, fixedWidthConstraint);
    }

    public void startQuery(String query) {
        this.startTick = new Date().getTime();
        this.display("sent query: " + query, true, -1L, -1);
    }

    public void endQuery(String statusText, int count) {
        long millisTaken = new Date().getTime() - this.startTick;
        this.startTick = new Date().getTime();
        this.display(statusText, false, millisTaken, count);
    }

    private void display(final String statusText, final boolean waiting, final long millisTaken, final int count) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                int c2 = waiting ? 3 : 0;
                QueryStatusBar.this.setCursor(Cursor.getPredefinedCursor(c2));
                String s = statusText;
                if (s.length() > 60) {
                    s = statusText.substring(0, 55) + "...";
                }
                QueryStatusBar.this.statusLabel.setText(s);
                QueryStatusBar.this.pbar.setIndeterminate(waiting);
                String countTxt = "Count = ?";
                if (count >= 0) {
                    countTxt = "Count = " + count;
                }
                String timerTxt = "Time = ? ms";
                if (millisTaken >= 0L) {
                    timerTxt = "Time = " + millisTaken + " ms";
                }
                QueryStatusBar.this.timingLabel.setText(timerTxt);
                QueryStatusBar.this.rowCountLabel.setText(countTxt);
            }
        });
    }
}

