/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.swingxx;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class JTreeHelper {
    public static void expandAll(JTree tree, boolean expand) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        JTreeHelper.expandAll(tree, new TreePath(root), expand);
    }

    public static void expandAll(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                JTreeHelper.expandAll(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    public static void setFolderExpansions(JTree tree, Set<String> curExpandedFolders) {
        Preconditions.checkNotNull(tree);
        Preconditions.checkNotNull(curExpandedFolders);
        if (curExpandedFolders.size() > 0) {
            for (int row = tree.getRowCount(); row >= 0; --row) {
                TreePath path = tree.getPathForRow(row);
                if (path == null) continue;
                Object o = path.getLastPathComponent();
                if (o != null && o instanceof DefaultMutableTreeNode) {
                    o = ((DefaultMutableTreeNode)o).getUserObject();
                }
                if (o == null || !(o instanceof IdentifiableNode)) continue;
                IdentifiableNode fn = (IdentifiableNode)o;
                String id = fn.getId();
                if (id != null && id.length() > 0 && curExpandedFolders.contains(id)) {
                    tree.expandRow(row);
                    continue;
                }
                tree.collapseRow(row);
            }
        }
    }

    public static Set<String> getExpandedFolders(JTree tree) {
        HashSet<String> curExpandedFolders = Sets.newHashSet();
        if (tree != null) {
            for (int row = tree.getRowCount(); row >= 0; --row) {
                TreePath path = tree.getPathForRow(row);
                if (path == null) continue;
                Object lpc = path.getLastPathComponent();
                if (lpc != null && lpc instanceof DefaultMutableTreeNode) {
                    Object o;
                    DefaultMutableTreeNode mtn = (DefaultMutableTreeNode)path.getLastPathComponent();
                    Object object = o = mtn != null ? mtn.getUserObject() : null;
                    if (o == null || !(o instanceof IdentifiableNode) || !tree.isExpanded(row)) continue;
                    curExpandedFolders.add(((IdentifiableNode)o).getId());
                    continue;
                }
                if (lpc == null || !(lpc instanceof IdentifiableNode)) continue;
                curExpandedFolders.add(((IdentifiableNode)lpc).getId());
            }
        }
        return curExpandedFolders;
    }

    public static interface IdentifiableNode {
        public String getId();
    }
}

