/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.swingxx;

import com.google.common.base.Preconditions;
import com.timestored.messages.Msg;
import com.timestored.misc.DirWatch;
import com.timestored.misc.FifoBuffer;
import com.timestored.misc.IOUtils;
import com.timestored.sqldash.chart.JdbcChartPanel;
import com.timestored.swingxx.AAction;
import com.timestored.swingxx.JTreeHelper;
import com.timestored.theme.Theme;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class FileTreePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(FileTreePanel.class.getName());
    private static final String DEFAULT_IGNORE_FOLDER_REGEX = "^\\..*|^target$";
    public static final FileFilter IGNORE_SVN_FILTER = DirWatch.generateFileFilter(Pattern.compile("^\\..*|^target$"));
    public static boolean TEST_MODE = true;
    private static FileSystemView fsv = FileSystemView.getFileSystemView();
    private JTree tree;
    private File root;
    private Component noRootsComponent;
    private final CopyOnWriteArrayList<Listener> listeners;
    private final TreeMouseListener treeMouseListener;
    private boolean rightClickMenuShown = true;
    private FileFilter fileFilter;
    private final DirWatch dirWatch;
    private final FifoBuffer<File> fileCache = new FifoBuffer(1000);
    private final FileTreeCellRenderer fileTreeCellRenderer;
    private Pattern ignoredFoldersRegex;
    private static String[] ENDS = new String[]{"exe", "dll", "zip", "rar", "7z", "iso", "msi", "dmg", "docx", "xlsx", "pptx", "pdf", "epub", "mobi", "mp3", "wav", "wma", "flac", "aac", "mp4", "avi", "mkv", "mov", "wmv", "gif", "jpg", "jpeg", "png", "bmp", "tiff", "psd"};

    public FileTreePanel() {
        this.listeners = new CopyOnWriteArrayList();
        this.fileFilter = IGNORE_SVN_FILTER;
        this.dirWatch = new DirWatch(30100L, this.fileFilter, true);
        this.setLayout(new BorderLayout());
        this.noRootsComponent = new JLabel(" No root folder selected");
        this.noRootsComponent.setName("noRootsComponent");
        this.treeMouseListener = new TreeMouseListener();
        this.addMouseListener(new RefreshTreeMouseListener());
        this.refreshGui();
        this.dirWatch.addListener(new DirWatch.DirWatchListener(){

            @Override
            public void changeOccurred() {
                FileTreePanel.this.refreshGui();
            }
        });
        this.fileTreeCellRenderer = new FileTreeCellRenderer();
        this.fileTreeCellRenderer.addListener(new FileTreeCellRenderer.Listener(){

            @Override
            public void renderedFile(File file) {
                FileTreePanel.this.fileCache.add(file);
            }
        });
    }

    public Collection<File> getFileCache() {
        return this.fileCache.getAll();
    }

    private JPopupMenu getFileRightClickMenu(File file) {
        File contextFile;
        JPopupMenu popupMenu = new JPopupMenu("");
        popupMenu.setName("fileRightClickMenu");
        File f = contextFile = file == null ? this.root : file;
        if (!f.isDirectory()) {
            f = contextFile.getParentFile();
        }
        final File nearestDir = f;
        String openText = contextFile.isDirectory() ? "Open Folder" : "Open Containing Folder";
        popupMenu.add(new AAction(openText, e -> {
            if (nearestDir.isDirectory()) {
                try {
                    Desktop.getDesktop().open(nearestDir);
                }
                catch (IOException ioe) {
                    String msg = "Could not open folder";
                    LOG.log(Level.WARNING, msg, ioe);
                    JOptionPane.showMessageDialog(null, msg);
                }
            }
        }));
        popupMenu.add(new AAction(Msg.get(Msg.Key.CREATE_NEW_FOLDER), Theme.CIcon.FOLDER_ADD.get16(), e -> {
            String newFolderName = JOptionPane.showInputDialog("Enter name for new Folder:", (Object)"New Folder");
            if (newFolderName != null) {
                File ff = new File(nearestDir, newFolderName);
                ff.mkdirs();
                ff.mkdir();
                this.refreshGui();
            }
        }));
        File pages = new File(this.root, "pages");
        boolean isParent = false;
        try {
            isParent = file.getCanonicalPath().startsWith(pages.getCanonicalPath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        final boolean wasUnderPages = isParent;
        popupMenu.add(new AbstractAction(Msg.get(Msg.Key.CREATE_NEW_FILE), Theme.CIcon.PAGE.get16()){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                String newFileName = JOptionPane.showInputDialog("Enter name for new file:", (Object)"New File");
                String errMsg = "Could not create new File";
                if (newFileName != null) {
                    String n = wasUnderPages && !newFileName.contains(".") ? newFileName + ".md" : newFileName;
                    File f = new File(nearestDir, n);
                    boolean success = true;
                    f.getParentFile().mkdirs();
                    try {
                        success = f.createNewFile();
                    }
                    catch (IOException ioe) {
                        success = false;
                        LOG.log(Level.WARNING, errMsg, ioe);
                    }
                    if (!success) {
                        JOptionPane.showMessageDialog(null, errMsg);
                    }
                    FileTreePanel.this.refreshGui();
                }
            }
        });
        popupMenu.add(new AAction("Refresh Tree", e -> this.refreshGui()));
        return popupMenu;
    }

    private static boolean isKnownBinaryFormat(File f) {
        String e = IOUtils.getFileEnding(f).toLowerCase();
        return Arrays.stream(ENDS).anyMatch(s -> s.equals(e));
    }

    public static void openFileOrBrowseTo(File f, Consumer<File> fileOpener) {
        if (f != null) {
            if (f.isFile() && !FileTreePanel.isKnownBinaryFormat(f)) {
                fileOpener.accept(f);
            } else {
                try {
                    Desktop.getDesktop().open(f);
                }
                catch (IOException ioe) {
                    JOptionPane.showMessageDialog(null, "Could not open folder");
                }
            }
        }
    }

    public void refreshGui() {
        File r = this.root;
        if (!(r == null || r.isDirectory() && r.canRead())) {
            r = null;
        }
        File[] files = r != null ? DirWatch.getFiles(this.fileFilter, this.root) : null;
        JdbcChartPanel.runInUIthread(() -> this.refreshUI(files), TEST_MODE);
    }

    private void refreshUI(File[] files) {
        LOG.info("FileTreePanel refreshGui");
        if (this.tree != null) {
            this.tree.removeMouseListener(this.treeMouseListener);
        }
        if (files == null) {
            this.removeAll();
            this.add(this.noRootsComponent, "Center");
        } else {
            files = DirWatch.getFiles(this.fileFilter, this.root);
            this.fileCache.addAll(DirWatch.generateFileCache(files, this.fileFilter));
            if (files.length > 0) {
                FileTreeNode rootTreeNode = new FileTreeNode(files, this.fileFilter);
                this.tree = new JTree(rootTreeNode);
                this.tree.setName("FileTreePanelTree");
                this.tree.setCellRenderer(this.fileTreeCellRenderer);
                this.tree.setRootVisible(false);
                boolean isLarge = IOUtils.containsMoreThanMaxFiles(this.root, 500);
                if (this.tree.getRowCount() < 20 && !isLarge) {
                    for (int i = 0; i < this.tree.getRowCount(); ++i) {
                        this.tree.expandRow(i);
                    }
                }
                this.tree.addMouseListener(this.treeMouseListener);
                JScrollPane jsp = new JScrollPane(this.tree);
                jsp.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                this.removeAll();
                this.add((Component)jsp, "Center");
            } else {
                this.removeAll();
                this.noRootsComponent = new JLabel(" Selected Folder is Empty");
                this.add(this.noRootsComponent, "Center");
            }
            this.revalidate();
            this.repaint();
        }
    }

    public void setNoRootsComponent(Component noRootsComponent) {
        if (noRootsComponent == null) {
            throw new IllegalArgumentException("noRootsComponent cannot be null");
        }
        this.noRootsComponent = noRootsComponent;
        noRootsComponent.setName("noRootsComponent");
        if (this.root == null) {
            this.refreshGui();
        }
    }

    public void setRoot(File selectedFolder) {
        boolean rootChanging;
        if (selectedFolder != null && !selectedFolder.isDirectory()) {
            throw new IllegalArgumentException("setRoots file must be a directory");
        }
        boolean bl = rootChanging = selectedFolder == null && this.root != null || selectedFolder != null && !selectedFolder.equals(this.root);
        if (rootChanging) {
            LOG.info("root changing");
            this.root = selectedFolder;
            if (selectedFolder == null) {
                this.dirWatch.stop();
            } else {
                try {
                    if (IOUtils.containsMoreThanMaxFiles(selectedFolder, 1000)) {
                        this.dirWatch.stop();
                    } else {
                        this.dirWatch.setRoot(selectedFolder);
                    }
                }
                catch (Exception e) {
                    LOG.warning("Could not watch root folder");
                }
            }
            this.refreshGui();
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public boolean isRightClickMenuShown() {
        return this.rightClickMenuShown;
    }

    public void setRightClickMenuShown(boolean rightClickMenuShown) {
        this.rightClickMenuShown = rightClickMenuShown;
    }

    public void setIgnoredFoldersRegex(Pattern ignoredFoldersRegex) {
        Preconditions.checkNotNull(ignoredFoldersRegex);
        if (this.ignoredFoldersRegex == null || !ignoredFoldersRegex.pattern().equals(this.ignoredFoldersRegex.pattern())) {
            this.ignoredFoldersRegex = ignoredFoldersRegex;
            this.fileFilter = DirWatch.generateFileFilter(ignoredFoldersRegex);
            this.refreshGui();
        }
    }

    private static class FileTreeNode
    implements TreeNode,
    JTreeHelper.IdentifiableNode {
        private final File file;
        private File[] children;
        private final TreeNode parent;
        private boolean isFileSystemRoot;
        private final FileFilter fileFilter;

        public FileTreeNode(File file, boolean isFileSystemRoot, TreeNode parent, FileFilter fileFilter) {
            this.file = file;
            this.isFileSystemRoot = isFileSystemRoot;
            this.fileFilter = fileFilter;
            this.parent = parent;
            this.children = DirWatch.getFiles(fileFilter, file);
            if (this.children == null) {
                this.children = new File[0];
            }
            Arrays.sort(this.children, new FileFolderNameComparator());
        }

        public FileTreeNode(File[] children, FileFilter fileFilter) {
            this.file = null;
            this.parent = null;
            Arrays.sort(children, new FileFolderNameComparator());
            this.children = children;
            this.fileFilter = fileFilter;
        }

        @Override
        public Enumeration<? extends TreeNode> children() {
            final int elementCount = this.children.length;
            return new Enumeration<TreeNode>(){
                int count = 0;

                @Override
                public boolean hasMoreElements() {
                    return this.count < elementCount;
                }

                @Override
                public TreeNode nextElement() {
                    if (this.count < elementCount) {
                        return this.getChildAt(this.count++);
                    }
                    throw new NoSuchElementException("Vector Enumeration");
                }
            };
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public TreeNode getChildAt(int childIndex) {
            return new FileTreeNode(this.children[childIndex], this.parent == null, this, this.fileFilter);
        }

        @Override
        public int getChildCount() {
            return this.children.length;
        }

        @Override
        public int getIndex(TreeNode node) {
            FileTreeNode ftn = (FileTreeNode)node;
            for (int i = 0; i < this.children.length; ++i) {
                if (!ftn.file.equals(this.children[i])) continue;
                return i;
            }
            return -1;
        }

        @Override
        public TreeNode getParent() {
            return this.parent;
        }

        @Override
        public boolean isLeaf() {
            return this.getChildCount() == 0;
        }

        @Override
        public String getId() {
            return this.file.getAbsolutePath();
        }

        private static class FileFolderNameComparator
        implements Comparator<File> {
            private FileFolderNameComparator() {
            }

            @Override
            public int compare(File f1, File f2) {
                if (f1.isDirectory() && f2.isFile()) {
                    return -1;
                }
                if (f2.isDirectory() && f1.isFile()) {
                    return 1;
                }
                return String.CASE_INSENSITIVE_ORDER.compare(f1.getName(), f2.getName());
            }
        }
    }

    private static class FileTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;
        private Map<String, Icon> iconCache = new HashMap<String, Icon>();
        private Map<File, String> rootNameCache = new HashMap<File, String>();
        private List<Listener> listeners = new CopyOnWriteArrayList<Listener>();

        private FileTreeCellRenderer() {
        }

        public void addListener(Listener listener) {
            this.listeners.add(listener);
        }

        public void clearListeners() {
            this.listeners.clear();
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value instanceof FileTreeNode) {
                FileTreeNode ftn = (FileTreeNode)value;
                File file = ftn.file;
                String filename = "";
                if (file != null) {
                    for (Listener l : this.listeners) {
                        l.renderedFile(file);
                    }
                    if (ftn.isFileSystemRoot) {
                        filename = this.rootNameCache.get(file);
                        if (filename == null) {
                            filename = fsv.getSystemDisplayName(file);
                            this.rootNameCache.put(file, filename);
                        }
                    } else {
                        filename = file.getName();
                    }
                }
                JLabel result = (JLabel)super.getTreeCellRendererComponent(tree, filename, sel, expanded, leaf, row, hasFocus);
                if (file != null) {
                    Icon icon = this.iconCache.get(filename);
                    if (icon == null) {
                        icon = fsv.getSystemIcon(file);
                        this.iconCache.put(filename, icon);
                    }
                    result.setIcon(icon);
                }
                return result;
            }
            return super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        }

        private static interface Listener {
            public void renderedFile(File var1);
        }
    }

    @FunctionalInterface
    public static interface Listener {
        public void fileSelected(File var1);
    }

    private class RefreshTreeMouseListener
    extends MouseAdapter {
        private RefreshTreeMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (FileTreePanel.this.root != null && SwingUtilities.isRightMouseButton(e) && FileTreePanel.this.rightClickMenuShown) {
                FileTreePanel.this.getFileRightClickMenu(FileTreePanel.this.root).show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private class TreeMouseListener
    extends MouseAdapter {
        private TreeMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Object o;
            if (SwingUtilities.isRightMouseButton(e)) {
                int row = FileTreePanel.this.tree.getClosestRowForLocation(e.getX(), e.getY());
                FileTreePanel.this.tree.setSelectionRow(row);
            }
            File f = null;
            TreePath tp = FileTreePanel.this.tree.getSelectionPath();
            Object object = o = tp == null ? null : tp.getLastPathComponent();
            if (o != null && o instanceof FileTreeNode) {
                f = ((FileTreeNode)o).file;
            }
            if (f != null && !f.canRead()) {
                FileTreePanel.this.refreshGui();
            } else if (f != null) {
                if (SwingUtilities.isRightMouseButton(e) && FileTreePanel.this.rightClickMenuShown) {
                    FileTreePanel.this.getFileRightClickMenu(f).show(e.getComponent(), e.getX(), e.getY());
                } else if (SwingUtilities.isLeftMouseButton(e)) {
                    LOG.info("FileTreePanel file selected->" + f);
                    for (Listener l : FileTreePanel.this.listeners) {
                        l.fileSelected(f);
                    }
                }
            }
        }
    }
}

