/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.swingxx;

import com.timestored.command.Command;
import com.timestored.command.CommandProvider;
import com.timestored.docs.DocumentActions;
import com.timestored.messages.Msg;
import com.timestored.swingxx.FileTreePanel;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileSystemView;
import lombok.NonNull;

public class FileOpenCommandProvider
implements CommandProvider {
    @NonNull
    private final DocumentActions documentActions;
    @NonNull
    private final FileTreePanel fileTreePanel;
    @NonNull
    private final Consumer<File> fileOpenHandler;
    private static final FileSystemView FSV = FileSystemView.getFileSystemView();

    @Override
    public Collection<Command> getCommands() {
        Collection<File> fcache = this.fileTreePanel.getFileCache();
        if (fcache.size() > 0) {
            ArrayList<Command> cmds = new ArrayList<Command>(fcache.size());
            for (File f : fcache) {
                cmds.add(new FileOpenCommand(f));
            }
            return cmds;
        }
        return Collections.emptyList();
    }

    public FileOpenCommandProvider(@NonNull DocumentActions documentActions, @NonNull FileTreePanel fileTreePanel, @NonNull Consumer<File> fileOpenHandler) {
        if (documentActions == null) {
            throw new NullPointerException("documentActions is marked non-null but is null");
        }
        if (fileTreePanel == null) {
            throw new NullPointerException("fileTreePanel is marked non-null but is null");
        }
        if (fileOpenHandler == null) {
            throw new NullPointerException("fileOpenHandler is marked non-null but is null");
        }
        this.documentActions = documentActions;
        this.fileTreePanel = fileTreePanel;
        this.fileOpenHandler = fileOpenHandler;
    }

    private class FileOpenCommand
    implements Command {
        private final File f;

        private FileOpenCommand(File f) {
            this.f = f;
        }

        @Override
        public Icon getIcon() {
            return FSV.getSystemIcon(this.f);
        }

        @Override
        public String getTitle() {
            return Msg.get(this.f.isDirectory() ? Msg.Key.OPEN_FOLDER : Msg.Key.OPEN_FILE) + ": " + this.f.getName();
        }

        @Override
        public String getDetailHtml() {
            return this.f.getAbsolutePath();
        }

        @Override
        public KeyStroke getKeyStroke() {
            return null;
        }

        public String toString() {
            return this.getTitle();
        }

        @Override
        public String getTitleAdditional() {
            return this.f.getParentFile().getAbsolutePath();
        }

        @Override
        public void perform() {
            FileTreePanel.openFileOrBrowseTo(this.f, FileOpenCommandProvider.this.fileOpenHandler::accept);
        }
    }
}

