/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.sqldash.chart;

import com.timestored.sqldash.chart.ChartFormatException;
import com.timestored.sqldash.chart.ChartResultSet;
import com.timestored.sqldash.chart.UpdateableView;
import java.awt.Component;
import java.sql.ResultSet;
import java.util.List;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.DefaultXYZDataset;

class XYZDatasetUpdateableView
implements UpdateableView {
    private final ChartPanel chartPanel;
    private final DefaultXYZDataset dataset;

    public XYZDatasetUpdateableView(ChartPanel chartPanel, DefaultXYZDataset dataset) {
        this.dataset = dataset;
        this.chartPanel = chartPanel;
    }

    @Override
    public void update(ResultSet rs2, ChartResultSet chartResultSet) throws ChartFormatException {
        if (chartResultSet == null) {
            throw new ChartFormatException("Could not create chart result set.");
        }
        for (int s = 0; s < this.dataset.getSeriesCount(); ++s) {
            this.dataset.removeSeries(this.dataset.getSeriesKey(s));
        }
        XYZDatasetUpdateableView.add(chartResultSet, this.dataset);
        XYPlot xyplot = this.chartPanel.getChart().getXYPlot();
        if (xyplot != null) {
            double minY = 0.0;
            double maxY = 0.0;
            double minX = 0.0;
            double maxX = 0.0;
            for (int series = 0; series < this.dataset.getSeriesCount(); ++series) {
                for (int item = 0; item < this.dataset.getItemCount(series); ++item) {
                    double x = this.dataset.getX(series, item).doubleValue();
                    if (x < minX) {
                        minX = x;
                    } else if (x > maxX) {
                        maxX = x;
                    }
                    double y = this.dataset.getY(series, item).doubleValue();
                    if (y < minY) {
                        minY = y;
                        continue;
                    }
                    if (!(y > maxY)) continue;
                    maxY = y;
                }
            }
            List<ChartResultSet.NumericCol> numCols = chartResultSet.getNumericColumns();
            NumberAxis numberaxisX = (NumberAxis)xyplot.getDomainAxis();
            numberaxisX.setLabel(numCols.get(0).getLabel());
            numberaxisX.setRange(minX > 0.0 ? 0.0 : minX * 1.5, maxX < 0.0 ? 0.0 : maxX * 1.15);
            NumberAxis numberaxisY = (NumberAxis)xyplot.getRangeAxis();
            numberaxisY.setLabel(numCols.get(1).getLabel());
            numberaxisY.setRange(minY > 0.0 ? 0.0 : minY * 1.5, maxY < 0.0 ? 0.0 : maxY * 1.15);
        }
    }

    @Override
    public Component getComponent() {
        return this.chartPanel;
    }

    private static DefaultXYZDataset add(ChartResultSet colResultSet, DefaultXYZDataset dataset) throws ChartFormatException {
        List<ChartResultSet.NumericCol> numCols = colResultSet.getNumericColumns();
        if (numCols.size() < 3) {
            throw new ChartFormatException("Need atleast three numerical columns.");
        }
        double[][] vals = new double[3][];
        for (int i = 0; i < 3; ++i) {
            vals[i] = numCols.get(i).getDoubles();
        }
        dataset.addSeries((Comparable)((Object)""), vals);
        return dataset;
    }
}

