/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.sqldash.chart;

import com.timestored.sqldash.chart.AreaChartViewStrategy;
import com.timestored.sqldash.chart.BarChartViewStrategy;
import com.timestored.sqldash.chart.BubbleChartViewStrategy;
import com.timestored.sqldash.chart.CandleStickViewStrategy;
import com.timestored.sqldash.chart.ChartTheme;
import com.timestored.sqldash.chart.DarkColorScheme;
import com.timestored.sqldash.chart.DataTableViewStrategy;
import com.timestored.sqldash.chart.DefaultTheme;
import com.timestored.sqldash.chart.DotViewStrategy;
import com.timestored.sqldash.chart.HeatMapViewStrategy;
import com.timestored.sqldash.chart.HistogramViewStrategy;
import com.timestored.sqldash.chart.JdbcChartPanel;
import com.timestored.sqldash.chart.LightColorScheme;
import com.timestored.sqldash.chart.LineChartViewStrategy;
import com.timestored.sqldash.chart.NoRedrawViewStrategy;
import com.timestored.sqldash.chart.PastelColorScheme;
import com.timestored.sqldash.chart.PieChartViewStrategy;
import com.timestored.sqldash.chart.ScatterPlotViewStrategy;
import com.timestored.sqldash.chart.StackedBarChartViewStrategy;
import com.timestored.sqldash.chart.StepChartViewStrategy;
import com.timestored.sqldash.chart.TimeseriesViewStrategy;
import com.timestored.sqldash.chart.ViewStrategy;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ViewStrategyFactory {
    private static final List<ViewStrategy> STRATEGIES = Collections.unmodifiableList(Arrays.asList(NoRedrawViewStrategy.INSTANCE, AreaChartViewStrategy.INSTANCE, BarChartViewStrategy.INSTANCE, StackedBarChartViewStrategy.INSTANCE, BubbleChartViewStrategy.INSTANCE, CandleStickViewStrategy.INSTANCE, DataTableViewStrategy.getInstance(), HeatMapViewStrategy.INSTANCE, HistogramViewStrategy.INSTANCE, LineChartViewStrategy.INSTANCE, PieChartViewStrategy.INSTANCE, ScatterPlotViewStrategy.INSTANCE, TimeseriesViewStrategy.INSTANCE, StepChartViewStrategy.INSTANCE, DotViewStrategy.INSTANCE));
    public static final ChartTheme LIGHT_THEME = DefaultTheme.getInstance(new LightColorScheme(), "Light", "Primary colours on a white background");
    public static final ChartTheme DARK_THEME = DefaultTheme.getInstance(new DarkColorScheme(), "Dark", "Primary colours on a black background");
    public static final ChartTheme PASTEL_THEME = DefaultTheme.getInstance(new PastelColorScheme(), "Pastel", "Pastel colours on a black background");
    private static final List<ChartTheme> THEMES = Collections.unmodifiableList(Arrays.asList(LIGHT_THEME, DARK_THEME, PASTEL_THEME));

    public static List<ViewStrategy> getStrategies() {
        return STRATEGIES;
    }

    public static List<ChartTheme> getThemes() {
        return THEMES;
    }

    public static JdbcChartPanel getJdbcChartpanel() {
        return new JdbcChartPanel(TimeseriesViewStrategy.INSTANCE, THEMES.get(0));
    }

    public static JdbcChartPanel getJdbcChartpanel(ViewStrategy vs) {
        return new JdbcChartPanel(vs, THEMES.get(0));
    }
}

