/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.sqldash.chart;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.timestored.connections.JdbcTypes;
import com.timestored.sqldash.chart.ChartFormatException;
import com.timestored.sqldash.chart.ChartResultSet;
import com.timestored.sqldash.chart.ChartTheme;
import com.timestored.sqldash.chart.ExampleTestCases;
import com.timestored.sqldash.chart.ExampleView;
import com.timestored.sqldash.chart.HardRefreshUpdateableView;
import com.timestored.sqldash.chart.KdbFunctions;
import com.timestored.sqldash.chart.SimpleResultSet;
import com.timestored.sqldash.chart.TestCase;
import com.timestored.sqldash.chart.UpdateableView;
import com.timestored.sqldash.chart.ViewStrategy;
import com.timestored.theme.Icon;
import com.timestored.theme.Theme;
import java.awt.Component;
import java.sql.Date;
import java.sql.ResultSet;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;

public enum TimeseriesViewStrategy implements ViewStrategy
{
    INSTANCE;

    private static final String KDB_QUERY = "([] dt:2013.01.01+til 21; cosineWave:cos a; \r\n\t sineWave:sin a:0.6*til 21)";
    private static final String TOOLTIP_FORMAT = "<html><b>{0}:</b><br>{1}<br>{2}</html>";
    private static final DecimalFormat DEC_FORMAT;
    private static final String[] FORMATA;

    @Override
    public UpdateableView getView(final ChartTheme theme) {
        return new HardRefreshUpdateableView(new HardRefreshUpdateableView.ViewGetter(){

            @Override
            public Component getView(ResultSet rs2, ChartResultSet colResultSet) throws ChartFormatException {
                TimeSeriesCollection dataset = TimeseriesViewStrategy.generateTimeSeries(colResultSet);
                JFreeChart chart = ChartFactory.createTimeSeriesChart("", "Time", "Value", dataset, true, true, false);
                ChartPanel cp = new ChartPanel(theme.apply(chart), false, true, true, false, true);
                TimeseriesViewStrategy.setTimeTooltipRenderer(colResultSet, cp.getChart().getXYPlot().getRenderer());
                return cp;
            }
        });
    }

    static void setTimeTooltipRenderer(ChartResultSet colResultSet, XYItemRenderer renderer) {
        SimpleDateFormat dateFormat;
        ChartResultSet.TimeCol timeCol = colResultSet.getTimeCol();
        if (timeCol != null && (dateFormat = TimeseriesViewStrategy.getDateFormat(timeCol.getType())) != null) {
            StandardXYToolTipGenerator ttg = new StandardXYToolTipGenerator(TOOLTIP_FORMAT, (DateFormat)dateFormat, (NumberFormat)DEC_FORMAT);
            renderer.setBaseToolTipGenerator(ttg);
        }
    }

    static TimeSeriesCollection generateTimeSeries(ChartResultSet colResultSet) throws ChartFormatException {
        if (colResultSet == null) {
            throw new ChartFormatException("Could not create chart result set.");
        }
        ChartResultSet.TimeCol timeCol = colResultSet.getTimeCol();
        if (timeCol == null) {
            throw new ChartFormatException("No Time Column Found.");
        }
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        if (timeCol != null) {
            RegularTimePeriod[] timePeriods = null;
            try {
                timePeriods = timeCol.getRegularTimePeriods();
            }
            catch (IllegalArgumentException iae) {
                throw new ChartFormatException(iae.toString());
            }
            for (ChartResultSet.NumericCol nc : colResultSet.getNumericColumns()) {
                TimeSeries tSeries = new TimeSeries((Comparable)((Object)("" + nc.getLabel())));
                int row = 0;
                for (double d : nc.getDoubles()) {
                    if (!Double.isNaN(d)) {
                        tSeries.addOrUpdate(timePeriods[row], d);
                    }
                    ++row;
                }
                if (tSeries.isEmpty()) continue;
                dataset.addSeries(tSeries);
            }
        }
        return dataset;
    }

    public static SimpleDateFormat getDateFormat(int timeType) {
        SimpleDateFormat dateFormat = null;
        if (timeType == 91) {
            dateFormat = new SimpleDateFormat("d-MMM-yyyy hh:mm:ss");
        } else if (timeType == 92) {
            dateFormat = new SimpleDateFormat("hh:mm:ss");
        }
        return dateFormat;
    }

    @Override
    public String getDescription() {
        return "Time Series";
    }

    @Override
    public Icon getIcon() {
        return Theme.CIcon.CHART_CURVE;
    }

    @Override
    public String getQueryEg(JdbcTypes jdbcType) {
        return jdbcType.equals((Object)JdbcTypes.KDB) ? KDB_QUERY : null;
    }

    public String toString() {
        return TimeseriesViewStrategy.class.getSimpleName() + "[" + this.getDescription() + "]";
    }

    @Override
    public List<ExampleView> getExamples() {
        return ImmutableList.of(TimeseriesViewStrategy.getSineWave());
    }

    public static ExampleView getSineWave() {
        String description = "A sine/cosine wave over a period of days.";
        String name = "Day Sines";
        String[] colNames = new String[]{"dt", "cosineWave", "sineWave"};
        double[] a = KdbFunctions.mul(KdbFunctions.til(21), 0.6);
        Date[] dt = ExampleTestCases.getDays(2013, 1, 1, 21);
        Object[] colValues = new Object[]{dt, KdbFunctions.cos(a), KdbFunctions.sin(a)};
        SimpleResultSet resultSet = new SimpleResultSet(colNames, colValues);
        ExampleView sineEV = new ExampleView(name, description, new TestCase(name, resultSet, KDB_QUERY));
        return sineEV;
    }

    @Override
    public String getFormatExplainationHtml() {
        return "<ol><li>" + Joiner.on("</li><li>").join(FORMATA) + "</li></ol>";
    }

    @Override
    public String getFormatExplaination() {
        return Joiner.on("\r\n").join(FORMATA);
    }

    @Override
    public boolean isQuickToRender(ResultSet rs2, int rowCount, int numColumnCount) {
        return rowCount < 211000;
    }

    @Override
    public String getPulseName() {
        return "timeseries";
    }

    static {
        DEC_FORMAT = new DecimalFormat("#,###.##");
        FORMATA = new String[]{"The first date/time column found will be used for the x-axis.", "Each numerical column represents one time series line on the chart."};
    }
}

