/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.sqldash.chart;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import kx.jdbc;
import org.jdesktop.swingx.renderer.StringValue;

public class TimeStringValuer
implements StringValue {
    private static final long serialVersionUID = 1L;
    public static final long MAX_ARRAY_ITEMS_SHOWN = 50000L;
    public static final String SINGLE_ITEM_LIST_PREFIX = ",";
    private static final String SPACER = " ";
    private static final String DEFAULT_EMPTY_ARRAY = "()";
    private static final String DEFAULT_POSTFIX = "";
    private final SimpleDateFormat nanosTimeOnlyFormat = new SimpleDateFormat("HH:mm:ss.SSSSSSSSS");
    private final SimpleDateFormat millisTimeOnlyFormat = new SimpleDateFormat("HH:mm:ss.SSS");
    private final DateTimeFormatter millisTimeOnlyFormatter = DateTimeFormatter.ofPattern("HH:mm:ss.SSS").withZone(ZoneId.of("UTC"));
    private final DateTimeFormatter dtformatter = DateTimeFormatter.ofPattern("yyyy.MM.dd'T'HH:mm:ss.SSSSSS").withZone(ZoneId.of("UTC"));
    private final DateTimeFormatter dateOnlyFormatter;
    private final SimpleDateFormat dateOnlyFormat;
    private final SimpleDateFormat dtWithMillisFormat;
    private final DateTimeFormatter dtWithMillisFormatter;
    private final DecimalFormat nanosEndFormat = new DecimalFormat("000");
    private final StringValue overidingStringFormatter;

    public TimeStringValuer(StringValue overidingStringFormatter, String overidingDateFormat) {
        this.overidingStringFormatter = overidingStringFormatter;
        if (overidingDateFormat != null) {
            this.dateOnlyFormat = new SimpleDateFormat(overidingDateFormat);
            this.dateOnlyFormatter = DateTimeFormatter.ofPattern(overidingDateFormat).withZone(ZoneId.of("UTC"));
            this.dtWithMillisFormatter = DateTimeFormatter.ofPattern(overidingDateFormat + "'T'HH:mm:ss.SSS").withZone(ZoneId.of("UTC"));
            this.dtWithMillisFormat = new SimpleDateFormat(overidingDateFormat + "'T'HH:mm:ss.SSS");
        } else {
            this.dateOnlyFormat = new SimpleDateFormat("yyyy-MM-dd");
            this.dateOnlyFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd").withZone(ZoneId.of("UTC"));
            this.dtWithMillisFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS").withZone(ZoneId.of("UTC"));
            this.dtWithMillisFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        }
    }

    public TimeStringValuer() {
        this(null, null);
    }

    @Override
    public String getString(Object o) {
        if (o == null) {
            return DEFAULT_POSTFIX;
        }
        if (o instanceof Timestamp[] || o instanceof Time[] || o instanceof Date[] || o instanceof java.util.Date[]) {
            return this.flatten((Object[])o, DEFAULT_EMPTY_ARRAY, DEFAULT_POSTFIX);
        }
        if (o instanceof int[]) {
            return this.flatten((int[])o, DEFAULT_EMPTY_ARRAY, DEFAULT_POSTFIX);
        }
        if (o instanceof long[]) {
            return this.flatten((long[])o, DEFAULT_EMPTY_ARRAY, DEFAULT_POSTFIX);
        }
        if (o instanceof double[]) {
            return this.flatten((double[])o, DEFAULT_EMPTY_ARRAY, DEFAULT_POSTFIX);
        }
        if (o instanceof float[]) {
            return this.flatten((float[])o, DEFAULT_EMPTY_ARRAY, DEFAULT_POSTFIX);
        }
        if (o instanceof short[]) {
            return this.flatten((short[])o, DEFAULT_EMPTY_ARRAY, DEFAULT_POSTFIX);
        }
        if (o instanceof boolean[]) {
            return this.flatten((boolean[])o, DEFAULT_EMPTY_ARRAY, DEFAULT_POSTFIX);
        }
        if (o instanceof byte[]) {
            return this.flatten((byte[])o, DEFAULT_EMPTY_ARRAY, DEFAULT_POSTFIX, "0x");
        }
        if (o instanceof Integer[]) {
            return this.flatten((Integer[])o);
        }
        if (o instanceof Long[]) {
            return this.flatten((Long[])o);
        }
        if (o instanceof Double[]) {
            return this.flatten((Double[])o);
        }
        if (o instanceof Float[]) {
            return this.flatten((Float[])o);
        }
        if (o instanceof Short[]) {
            return this.flatten((Short[])o);
        }
        if (o instanceof Boolean[]) {
            return this.flatten((Boolean[])o);
        }
        if (o instanceof Byte[]) {
            return this.flatten((Byte[])o);
        }
        return this.format(o);
    }

    public static String trimTrailingPointZeroes(String numString) {
        int dotPos = numString.lastIndexOf(".");
        if (dotPos == -1) {
            return numString;
        }
        int lastIdx = numString.length();
        while (numString.charAt(lastIdx - 1) == '0') {
            --lastIdx;
        }
        if (numString.charAt(lastIdx - 1) == '.') {
            --lastIdx;
        }
        return numString.substring(0, lastIdx);
    }

    public String flatten(Boolean[] a) {
        boolean[] r = new boolean[a.length];
        for (int i = 0; i < a.length; ++i) {
            r[i] = a[i];
        }
        return this.flatten(r, DEFAULT_EMPTY_ARRAY, DEFAULT_POSTFIX);
    }

    public String flatten(Byte[] a) {
        byte[] r = new byte[a.length];
        for (int i = 0; i < a.length; ++i) {
            r[i] = a[i];
        }
        return this.flatten(r, DEFAULT_EMPTY_ARRAY, DEFAULT_POSTFIX, "0x");
    }

    public String flatten(Short[] a) {
        short[] r = new short[a.length];
        for (int i = 0; i < a.length; ++i) {
            r[i] = a[i];
        }
        return this.flatten(r, DEFAULT_EMPTY_ARRAY, DEFAULT_POSTFIX);
    }

    public String flatten(Integer[] a) {
        int[] r = new int[a.length];
        for (int i = 0; i < a.length; ++i) {
            r[i] = a[i];
        }
        return this.flatten(r, DEFAULT_EMPTY_ARRAY, DEFAULT_POSTFIX);
    }

    public String flatten(Long[] a) {
        long[] r = new long[a.length];
        for (int i = 0; i < a.length; ++i) {
            r[i] = a[i];
        }
        return this.flatten(r, DEFAULT_EMPTY_ARRAY, DEFAULT_POSTFIX);
    }

    public String flatten(Float[] a) {
        float[] r = new float[a.length];
        for (int i = 0; i < a.length; ++i) {
            r[i] = a[i].floatValue();
        }
        return this.flatten(r, DEFAULT_EMPTY_ARRAY, DEFAULT_POSTFIX);
    }

    public String flatten(Double[] a) {
        double[] r = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            r[i] = a[i];
        }
        return this.flatten(r, DEFAULT_EMPTY_ARRAY, DEFAULT_POSTFIX);
    }

    public String flatten(int[] a, String emptySt, String postfix) {
        if (a.length == 0) {
            return emptySt;
        }
        if (a.length == 1) {
            return SINGLE_ITEM_LIST_PREFIX + this.format(a[0]) + postfix;
        }
        StringBuilder s = new StringBuilder(a.length * 3);
        s.append(this.format(a[0]));
        int i = 1;
        while ((long)i < Math.min((long)a.length, 50000L)) {
            s.append(SPACER).append(this.format(a[i]));
            ++i;
        }
        return TimeStringValuer.doEnding(a.length, s.append(postfix));
    }

    public String format(Object o) {
        String s = null;
        if (this.overidingStringFormatter != null) {
            s = this.overidingStringFormatter.getString(o);
        }
        if (s == null) {
            if (o instanceof jdbc.KdbJdbcType) {
                s = o.toString();
            } else if (o instanceof Timestamp) {
                Timestamp ts = (Timestamp)o;
                s = this.dtWithMillisFormat.format(ts) + this.nanosEndFormat.format(ts.getNanos() % 1000000 / 1000);
            } else if (o instanceof Instant) {
                s = this.dtformatter.format((Instant)o);
            } else if (o instanceof LocalDate) {
                s = this.dateOnlyFormatter.format((LocalDate)o);
            } else if (o instanceof LocalTime) {
                s = this.millisTimeOnlyFormatter.format((LocalTime)o);
            } else if (o instanceof LocalDateTime) {
                s = this.dtWithMillisFormatter.format((LocalDateTime)o);
            } else if (o instanceof Time) {
                s = this.millisTimeOnlyFormat.format((Time)o);
            } else if (o instanceof Date) {
                s = this.dateOnlyFormat.format((Date)o);
            } else if (o instanceof java.util.Date) {
                s = this.dtWithMillisFormat.format((java.util.Date)o);
            }
        }
        return s != null ? s : o.toString();
    }

    private static String doEnding(int arrayLength, StringBuilder s) {
        if ((long)arrayLength > 50000L) {
            s.append("...");
        }
        return s.toString();
    }

    public String flatten(short[] a, String emptySt, String postfix) {
        if (a.length == 0) {
            return emptySt;
        }
        if (a.length == 1) {
            return SINGLE_ITEM_LIST_PREFIX + this.format(a[0]) + postfix;
        }
        StringBuilder s = new StringBuilder(a.length * 3);
        s.append(this.format(a[0]));
        int i = 1;
        while ((long)i < Math.min((long)a.length, 50000L)) {
            s.append(SPACER).append(this.format(a[i]));
            ++i;
        }
        return TimeStringValuer.doEnding(a.length, s.append(postfix));
    }

    public String flatten(boolean[] a, String emptySt, String postfix) {
        if (a.length == 0) {
            return "`boolean$()";
        }
        if (a.length == 1) {
            return SINGLE_ITEM_LIST_PREFIX + this.format(a[0]) + postfix;
        }
        StringBuilder s = new StringBuilder(a.length + 1);
        int i = 0;
        while ((long)i < Math.min((long)a.length, 50000L)) {
            s.append(a[i] ? "1" : "0");
            ++i;
        }
        return TimeStringValuer.doEnding(a.length, s.append(postfix));
    }

    public String flatten(byte[] a, String emptySt, String postfix, String prefix) {
        if (a.length == 0) {
            return emptySt;
        }
        if (a.length == 1) {
            return SINGLE_ITEM_LIST_PREFIX + prefix + this.format(a[0]) + postfix;
        }
        StringBuilder s = new StringBuilder(a.length * 2 + 2);
        s.append(prefix);
        int i = 0;
        while ((long)i < Math.min((long)a.length, 50000L)) {
            s.append(String.format("%02X", a[i]).toLowerCase());
            ++i;
        }
        return TimeStringValuer.doEnding(a.length, s.append(postfix));
    }

    public String flatten(long[] a, String emptySt, String postfix) {
        if (a.length == 0) {
            return emptySt;
        }
        if (a.length == 1) {
            return SINGLE_ITEM_LIST_PREFIX + this.format(a[0]) + postfix;
        }
        StringBuilder s = new StringBuilder(a.length * 3);
        s.append(this.format(a[0]));
        int i = 1;
        while ((long)i < Math.min((long)a.length, 50000L)) {
            s.append(SPACER).append(this.format(a[i]));
            ++i;
        }
        return TimeStringValuer.doEnding(a.length, s.append(postfix));
    }

    public String flatten(float[] a, String emptySt, String postfix) {
        if (a.length == 0) {
            return emptySt;
        }
        if (a.length == 1) {
            return SINGLE_ITEM_LIST_PREFIX + this.format(Float.valueOf(a[0])) + postfix;
        }
        StringBuilder s = new StringBuilder(a.length * 3);
        s.append(this.format(Float.valueOf(a[0])));
        int i = 1;
        while ((long)i < Math.min((long)a.length, 50000L)) {
            s.append(SPACER).append(this.format(Float.valueOf(a[i])));
            ++i;
        }
        return TimeStringValuer.doEnding(a.length, s.append(postfix));
    }

    public String flatten(double[] a, String emptySt, String postfix) {
        if (a.length == 0) {
            return emptySt;
        }
        if (a.length == 1) {
            return SINGLE_ITEM_LIST_PREFIX + this.format(a[0]);
        }
        StringBuilder s = new StringBuilder(a.length * 3);
        s.append(this.format(a[0]));
        int i = 1;
        while ((long)i < Math.min((long)a.length, 50000L)) {
            s.append(SPACER).append(this.format(a[i]));
            ++i;
        }
        if (!s.toString().contains(".")) {
            s.append("f");
        }
        return TimeStringValuer.doEnding(a.length, s);
    }

    public String flatten(String[] a, String emptySt, String postfix, String prefix) {
        if (a.length == 0) {
            return emptySt;
        }
        if (a.length == 1) {
            return SINGLE_ITEM_LIST_PREFIX + prefix + this.format(a[0]);
        }
        StringBuilder s = new StringBuilder(a.length * 3);
        s.append("`" + this.format(a[0]));
        int i = 1;
        while ((long)i < Math.min((long)a.length, 50000L)) {
            s.append("`").append(this.format(a[i]));
            ++i;
        }
        return TimeStringValuer.doEnding(a.length, s);
    }

    public String flatten(Object[] a, String emptySt, String postfix) {
        if (a.length == 0) {
            return emptySt;
        }
        if (a.length == 1) {
            return SINGLE_ITEM_LIST_PREFIX + this.format(a[0]) + postfix;
        }
        StringBuilder s = new StringBuilder(a.length * 3);
        s.append(this.format(a[0]));
        int i = 1;
        while ((long)i < Math.min((long)a.length, 50000L)) {
            s.append(SPACER).append(this.format(a[i]));
            ++i;
        }
        return TimeStringValuer.doEnding(a.length, s.append(postfix));
    }
}

