/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.sqldash.chart;

import com.timestored.babeldb.DBHelper;
import com.timestored.qstudio.QStudioFrame;
import com.timestored.qstudio.kdb.DataComparator;
import com.timestored.qstudio.kdb.KdbHelper;
import com.timestored.swingxx.SaveTableMouseAdapter;
import com.timestored.theme.Theme;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Array;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.sql.rowset.serial.SerialArray;
import javax.sql.rowset.serial.SerialException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import kx.jdbc;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.renderer.DefaultTableRenderer;
import org.jdesktop.swingx.renderer.StringValue;
import org.jdesktop.swingx.renderer.StringValues;
import org.jdesktop.swingx.table.TableColumnExt;

public class TableFactory {
    private static final Logger LOG = Logger.getLogger(TableFactory.class.getName());
    private static final KdbStringValuer KDB_STRING_VALER = new KdbStringValuer();
    private static final Highlighter KEY_COL_HIGHLIGHTER = new ColorHighlighter(new Color(222, 188, 255), Color.BLACK);
    private static final int MAX_COL_WIDTH = 700;
    private static final Comparator MANY_COMPARATOR = new DataComparator();

    public static JScrollPane getTable(TableModel tableModel, DBHelper.ColumnInfo[] columnInfos) {
        JXTable table = Theme.getStripedTable(tableModel);
        table.setCellSelectionEnabled(true);
        int keyColCount = 0;
        if (tableModel instanceof EnrichedTableModel) {
            keyColCount = ((EnrichedTableModel)tableModel).getKeyedColumnCount();
        }
        for (int i = 0; i < keyColCount; ++i) {
            table.getColumnExt(i).setHighlighters(KEY_COL_HIGHLIGHTER);
        }
        SaveTableMouseAdapter saveTableMouseAdapter = TableFactory.setPresentation(table);
        for (int ci = 0; ci < table.getColumnCount(); ++ci) {
            TableColumnExt tce = table.getColumnExt(ci);
            if (columnInfos != null && ci < columnInfos.length) {
                tce.setToolTipText(columnInfos[ci].toString());
            }
            tce.setComparator(MANY_COMPARATOR);
            if (tce.getPreferredWidth() <= 700) continue;
            tce.setPreferredWidth(700);
        }
        JScrollPane scrollPane = new JScrollPane(table, 20, 30);
        JXTable rowTable = TableFactory.getRowTable(tableModel, table);
        rowTable.addMouseListener(saveTableMouseAdapter);
        scrollPane.setRowHeaderView(rowTable);
        scrollPane.setColumnHeaderView(table.getTableHeader());
        scrollPane.setCorner("UPPER_LEFT_CORNER", rowTable.getTableHeader());
        return scrollPane;
    }

    private static JXTable getRowTable(final TableModel tableModel, final JXTable table) {
        AbstractTableModel rowTableModel = new AbstractTableModel(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                return rowIndex;
            }

            @Override
            public int getRowCount() {
                return tableModel.getRowCount();
            }

            @Override
            public int getColumnCount() {
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return "";
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return Number.class;
            }
        };
        JXTable rowTable = new JXTable(rowTableModel);
        rowTable.getColumnExt(0).setComparator(MANY_COMPARATOR);
        rowTable.setAutoResizeMode(0);
        rowTable.getRowSorter().addRowSorterListener(new RowSorterListener(){

            @Override
            public void sorterChanged(RowSorterEvent e) {
                Object v = e.getSource();
                List<RowSorter.SortKey> l = ((RowSorter)v).getSortKeys();
                table.getRowSorter().setSortKeys(l);
                System.out.println(Arrays.toString(l.toArray()));
                System.out.println(l.toString());
            }
        });
        rowTable.packAll();
        rowTable.setCursor(Cursor.getPredefinedCursor(12));
        ExcelStyleSelectorMouseListener mouseAdapter = new ExcelStyleSelectorMouseListener(rowTable, table);
        rowTable.addMouseMotionListener(mouseAdapter);
        rowTable.addMouseListener(mouseAdapter);
        rowTable.getColumnExt(0).setCellRenderer(new DefaultTableRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTableCellRendererComponent(final JTable table, Object value, boolean isSelected, boolean hasFocus, final int row, int column) {
                JLabel l = new JLabel("" + value.toString());
                l.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        System.out.println("" + row);
                        table.setRowSelectionInterval(row, row + 1);
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        System.out.println("" + row);
                    }
                });
                l.setBorder(BorderFactory.createRaisedBevelBorder());
                return l;
            }
        });
        return rowTable;
    }

    public static SaveTableMouseAdapter setPresentation(final JXTable table) {
        table.setSelectionMode(1);
        SaveTableMouseAdapter rightClickListener = new SaveTableMouseAdapter(table, Theme.CIcon.CSV.get(), KDB_STRING_VALER);
        table.addMouseListener(rightClickListener);
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    if (table.getSelectionMode() != 1) {
                        table.setSelectionMode(1);
                    }
                    Point point = mouseEvent.getPoint();
                    int row = table.rowAtPoint(point);
                    int col = table.columnAtPoint(point);
                    if (mouseEvent.getClickCount() == 2 && table.getSelectedRow() != -1 && row != -1) {
                        jdbc.ExtendedResultSet nestedRS;
                        int modelRow = table.convertRowIndexToModel(row);
                        int modelCol = table.convertColumnIndexToModel(col);
                        TableModel model = table.getModel();
                        Object val2 = model.getValueAt(modelRow, modelCol);
                        System.out.println(val2);
                        if (model instanceof EnrichedTableModel && (nestedRS = ((EnrichedTableModel)model).getNestedResultSetAt(modelRow, modelCol)) != null) {
                            try {
                                int rowCount = DBHelper.getSize(nestedRS);
                                if (1 < rowCount) {
                                    Component nestedTable = TableFactory.getTable(nestedRS, Integer.MAX_VALUE);
                                    String title = nestedRS.getName().length() == 0 ? "nested" : nestedRS.getName();
                                    Window w = SwingUtilities.getWindowAncestor(table);
                                    QStudioFrame.showPopup(w, nestedTable, title, Theme.CIcon.TABLE_ROW_DELETE.get16().getImage());
                                }
                            }
                            catch (SQLException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }
        });
        DefaultTableRenderer defaultTabRenderer = new DefaultTableRenderer((StringValue)KDB_STRING_VALER, 4);
        table.setDefaultRenderer(Object.class, defaultTabRenderer);
        table.setDefaultRenderer(Number.class, defaultTabRenderer);
        table.packAll();
        table.setAutoResizeMode(0);
        return rightClickListener;
    }

    public static DefaultTableModel buildTableModel(ResultSet rs2, int maxRowsShown) throws SQLException {
        ResultSetMetaData metaData = rs2.getMetaData();
        Vector<String> columnNames = new Vector<String>();
        int columnCount = metaData.getColumnCount();
        for (int column = 1; column <= columnCount; ++column) {
            columnNames.add(metaData.getColumnName(column));
        }
        Vector data = new Vector();
        for (int row = 0; rs2.next() && row < maxRowsShown; ++row) {
            Vector<Object> vector = new Vector<Object>();
            for (int columnIndex = 1; columnIndex <= columnCount; ++columnIndex) {
                vector.add(rs2.getObject(columnIndex));
            }
            data.add(vector);
        }
        if (rs2 instanceof jdbc.ExtendedResultSet) {
            return new EnrichedTableModel(data, columnNames, (jdbc.ExtendedResultSet)rs2);
        }
        return new DefaultTableModel(data, columnNames);
    }

    public static Component getTable(ResultSet rs2, int maxRowsShown) throws SQLException {
        if (rs2 != null) {
            DefaultTableModel tableModel = TableFactory.buildTableModel(rs2, maxRowsShown);
            DBHelper.ColumnInfo[] columnInfos = DBHelper.getColumnInfos(rs2);
            JScrollPane scrollPane = TableFactory.getTable(tableModel, columnInfos);
            if (DBHelper.getSize(rs2) > maxRowsShown) {
                Box b = Box.createVerticalBox();
                b.add(new JLabel("<html><b>Warning: some rows not shown as over max display limit: " + maxRowsShown + "</b></html>"));
                b.add(scrollPane);
                return b;
            }
            return scrollPane;
        }
        return null;
    }

    public static class KdbStringValuer
    implements StringValue {
        private static final long serialVersionUID = 1L;

        @Override
        public String getString(Object value) {
            String s = this.getStringSpecialized(value);
            if (s != null) {
                return s;
            }
            String o = KdbHelper.asLine(value, true);
            if (o != null) {
                return o.toString();
            }
            return StringValues.TO_STRING.getString(value);
        }

        public String getStringSpecialized(Object value) {
            if (value instanceof SerialArray) {
                try {
                    Object array = ((SerialArray)value).getArray();
                    if (array != null && array.getClass().isArray()) {
                        StringBuilder sb = new StringBuilder("[");
                        int n = Array.getLength(array);
                        for (int mi = 0; mi < n; ++mi) {
                            if (mi > 0) {
                                sb.append(", ");
                            }
                            Object o = Array.get(array, mi);
                            sb.append(this.formatSpecialized(o));
                        }
                        sb.append("]");
                        return sb.toString();
                    }
                }
                catch (SerialException e) {
                    LOG.warning(e.toString());
                    return "";
                }
            }
            return null;
        }

        public String formatSpecialized(Object o) {
            return o == null ? "NULL" : (o instanceof String ? "'" + o.toString() + "'" : o.toString());
        }
    }

    public static class EnrichedTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 1L;
        private final jdbc.ExtendedResultSet rs;
        private final int keyedColumnCount;

        public EnrichedTableModel(Vector<? extends Vector> dataVector, Vector<?> columnIdentifiers, int keyedColumnCount) {
            super(dataVector, columnIdentifiers);
            this.rs = null;
            this.keyedColumnCount = keyedColumnCount;
        }

        public EnrichedTableModel(Vector<? extends Vector> dataVector, Vector<?> columnIdentifiers, jdbc.ExtendedResultSet rs2) {
            super(dataVector, columnIdentifiers);
            this.rs = rs2;
            this.keyedColumnCount = rs2 == null ? 0 : rs2.getKeyedColumnCount();
        }

        public jdbc.ExtendedResultSet getNestedResultSetAt(int modelRow, int modelCol) {
            return this.rs == null ? null : this.rs.getNestedResultSetAt(modelRow, modelCol);
        }

        public int getKeyedColumnCount() {
            return this.keyedColumnCount;
        }
    }

    public static class TransposedTableModel
    extends EnrichedTableModel {
        private static final long serialVersionUID = 1L;

        public TransposedTableModel(JXTable table, int[] rows) {
            super(TransposedTableModel.transpose(table, rows), TransposedTableModel.toVector(rows), 1);
        }

        private static Vector<String> toVector(int[] rows) {
            Vector<String> result = new Vector<String>(rows.length);
            result.add("ColumnName");
            for (int r : rows) {
                result.add("" + r);
            }
            return result;
        }

        private static Vector<Vector<Object>> transpose(JXTable table, int[] rows) {
            Vector<Vector<Object>> data = new Vector<Vector<Object>>();
            for (int r = 0; r < table.getColumnCount(); ++r) {
                Vector<Object> vector = new Vector<Object>();
                vector.add(table.getColumnName(r));
                for (int c2 = 0; c2 < rows.length; ++c2) {
                    vector.add(table.getValueAt(rows[c2], r));
                }
                data.add(vector);
            }
            return data;
        }
    }

    private static class ExcelStyleSelectorMouseListener
    extends MouseAdapter {
        int mouseRowDown = -1;
        int mouseRowUp = -1;
        private final JXTable rowTable;
        private final JXTable table;

        @Override
        public void mousePressed(MouseEvent e) {
            int rowDown;
            if (this.mouseRowDown == -1 && e.getButton() == 1 && (rowDown = this.rowTable.rowAtPoint(e.getPoint())) != this.mouseRowDown) {
                this.mouseRowDown = rowDown;
                System.out.println("mouseDragged mouseRowDown = " + this.mouseRowDown);
            }
            super.mousePressed(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.mouseRowDown != -1) {
                int mouseUp = this.rowTable.rowAtPoint(e.getPoint());
                if (this.table.getSelectionMode() != 1) {
                    this.table.setSelectionMode(1);
                }
                if (this.mouseRowUp != mouseUp) {
                    this.mouseRowUp = mouseUp;
                    int rowCount = this.table.getRowCount();
                    if (this.mouseRowDown >= 0 && this.mouseRowDown < rowCount && this.mouseRowUp >= 0 && this.mouseRowUp < rowCount) {
                        int lowRow = Math.min(this.mouseRowDown, this.mouseRowUp);
                        int hiRow = Math.max(this.mouseRowDown, this.mouseRowUp);
                        this.table.setColumnSelectionInterval(0, this.table.getColumnCount() - 1);
                        this.table.setRowSelectionInterval(lowRow, hiRow);
                        LOG.fine("lowRow = " + lowRow + " hiRow =" + hiRow);
                    }
                }
            }
            super.mouseDragged(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getButton() == 1) {
                this.mouseRowDown = -1;
                this.mouseRowUp = -1;
            }
            super.mouseReleased(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1) {
                int row;
                if (this.table.getSelectionMode() != 2) {
                    this.table.setSelectionMode(2);
                    this.table.clearSelection();
                }
                if ((row = this.rowTable.rowAtPoint(e.getPoint())) >= 0) {
                    this.table.setColumnSelectionInterval(0, this.table.getColumnCount() - 1);
                    if (e.isShiftDown() && this.table.getSelectedRow() >= 0) {
                        int lowRow = Math.min(row, this.table.getSelectedRow());
                        int hiRow = Math.max(row, this.table.getSelectedRow());
                        this.table.setRowSelectionInterval(lowRow, hiRow);
                    } else if (e.isControlDown()) {
                        if (this.table.getSelectedRowCount() > 0) {
                            this.table.addRowSelectionInterval(row, row);
                        } else {
                            this.table.setRowSelectionInterval(row, row);
                        }
                    } else {
                        this.table.setRowSelectionInterval(row, row);
                    }
                }
            }
            super.mouseClicked(e);
        }

        public ExcelStyleSelectorMouseListener(JXTable rowTable, JXTable table) {
            this.rowTable = rowTable;
            this.table = table;
        }
    }
}

