/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.sqldash.chart;

import com.google.common.base.Preconditions;
import com.timestored.connections.JdbcTypes;
import com.timestored.sqldash.chart.ChartFormatException;
import com.timestored.sqldash.chart.ChartResultSet;
import com.timestored.sqldash.chart.ChartTheme;
import com.timestored.sqldash.chart.ExampleView;
import com.timestored.sqldash.chart.HardRefreshUpdateableView;
import com.timestored.sqldash.chart.ScatterPlotViewStrategy;
import com.timestored.sqldash.chart.TimeseriesViewStrategy;
import com.timestored.sqldash.chart.UpdateableView;
import com.timestored.sqldash.chart.ViewStrategy;
import com.timestored.sqldash.theme.DBIcons;
import com.timestored.theme.Icon;
import java.awt.Component;
import java.sql.ResultSet;
import java.text.DecimalFormat;
import java.util.List;
import net.jcip.annotations.Immutable;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.StandardTickUnitSource;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.util.Log;

@Immutable
public class StepChartViewStrategy
implements ViewStrategy {
    public static final ViewStrategy INSTANCE = new StepChartViewStrategy();

    @Override
    public UpdateableView getView(final ChartTheme theme) {
        Preconditions.checkNotNull(theme);
        return new HardRefreshUpdateableView(new HardRefreshUpdateableView.ViewGetter(){

            @Override
            public Component getView(ResultSet resultSet, ChartResultSet colResultSet) throws ChartFormatException {
                if (colResultSet == null) {
                    throw new ChartFormatException("Could not create Result Set.");
                }
                XYDataset dataset = null;
                try {
                    dataset = TimeseriesViewStrategy.generateTimeSeries(colResultSet);
                }
                catch (ChartFormatException cfe) {
                    dataset = ScatterPlotViewStrategy.createXYDataset(colResultSet);
                }
                JFreeChart chart = ChartFactory.createXYStepChart("", "", "", dataset, PlotOrientation.VERTICAL, theme.showChartLegend(), true, false);
                try {
                    XYPlot xyPlot;
                    if (chart.getPlot() instanceof XYPlot && chart.getPlot() instanceof XYPlot && (xyPlot = (XYPlot)chart.getPlot()).getRangeAxis() instanceof NumberAxis) {
                        NumberAxis na = (NumberAxis)xyPlot.getRangeAxis();
                        na.setAxisLineVisible(false);
                        na.setAutoRangeIncludesZero(false);
                        if (na.getRange().getLength() < 0.01) {
                            na.setStandardTickUnits(new StandardTickUnitSource());
                            DecimalFormat df = new DecimalFormat();
                            df.applyPattern("##0.#######");
                            na.setNumberFormatOverride(df);
                        }
                    }
                }
                catch (RuntimeException e) {
                    Log.debug(e);
                }
                if (colResultSet.getTimeCol() != null) {
                    XYItemRenderer renderer = chart.getXYPlot().getRenderer();
                    TimeseriesViewStrategy.setTimeTooltipRenderer(colResultSet, renderer);
                }
                return new ChartPanel(theme.apply(chart), false, true, true, false, true);
            }
        });
    }

    @Override
    public String getDescription() {
        return "Step Plot";
    }

    @Override
    public Icon getIcon() {
        return DBIcons.CHART_LINE;
    }

    @Override
    public String getQueryEg(JdbcTypes jdbcType) {
        return TimeseriesViewStrategy.INSTANCE.getQueryEg(jdbcType);
    }

    public String toString() {
        return ScatterPlotViewStrategy.class.getSimpleName() + "[" + this.getDescription() + "]";
    }

    @Override
    public List<ExampleView> getExamples() {
        return TimeseriesViewStrategy.INSTANCE.getExamples();
    }

    @Override
    public String getFormatExplainationHtml() {
        return TimeseriesViewStrategy.INSTANCE.getFormatExplainationHtml();
    }

    @Override
    public String getFormatExplaination() {
        return TimeseriesViewStrategy.INSTANCE.getFormatExplaination();
    }

    @Override
    public boolean isQuickToRender(ResultSet rs2, int rowCount, int columnCount) {
        return rowCount < 211000;
    }

    @Override
    public String getPulseName() {
        return "timeseries";
    }
}

