/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.sqldash.chart;

import com.timestored.sqldash.chart.AbstractCategoryViewStrategy;
import com.timestored.sqldash.chart.CategoryDatasetUpdateableView;
import com.timestored.sqldash.chart.ChartTheme;
import com.timestored.sqldash.chart.UpdateableView;
import com.timestored.sqldash.chart.ViewStrategy;
import com.timestored.sqldash.theme.DBIcons;
import java.sql.ResultSet;
import net.jcip.annotations.Immutable;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;

@Immutable
public class StackedBarChartViewStrategy
extends AbstractCategoryViewStrategy {
    public static final ViewStrategy INSTANCE = new StackedBarChartViewStrategy();

    private StackedBarChartViewStrategy() {
        super("Bar Chart Stacked", DBIcons.CHART_BAR);
    }

    @Override
    public UpdateableView getView(ChartTheme theme) {
        JFreeChart chart = ChartFactory.createStackedBarChart("", "", "values", null, PlotOrientation.VERTICAL, theme.showChartLegend(), true, false);
        return new CategoryDatasetUpdateableView(theme, chart);
    }

    public String toString() {
        return StackedBarChartViewStrategy.class.getSimpleName() + "[" + this.getDescription() + "]";
    }

    @Override
    public boolean isQuickToRender(ResultSet rs2, int rowCount, int numColumnCount) {
        return numColumnCount * rowCount < 10000;
    }

    @Override
    public String getPulseName() {
        return "stack";
    }
}

