/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.sqldash.chart;

import com.timestored.sqldash.chart.BaseResultSet;
import com.timestored.sqldash.chart.SimpleResultSetMetaData;
import java.lang.reflect.Array;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Map;

public class SimpleResultSet
extends BaseResultSet {
    private final String[] colNames;
    private final Object[] colValues;
    private int idx = 0;
    private final ResultSetMetaData resultSetMetaData;
    private boolean wasNull;

    public SimpleResultSet(String[] colNames) {
        this(colNames, new Object[0]);
    }

    public SimpleResultSet(String[] colNames, Object[] colValues) {
        this.colNames = colNames;
        this.colValues = colValues;
        int[] types = null;
        if (colValues.length == 0) {
            types = new int[colNames.length];
            Arrays.fill(types, 12);
        } else {
            types = SimpleResultSet.getTypes(colValues);
        }
        this.resultSetMetaData = new SimpleResultSetMetaData(colNames, types);
    }

    private static int getType(Object o) {
        if (o instanceof String[]) {
            return 12;
        }
        if (o instanceof boolean[]) {
            return -7;
        }
        if (o instanceof short[]) {
            return 5;
        }
        if (o instanceof int[]) {
            return 4;
        }
        if (o instanceof Integer[]) {
            return 4;
        }
        if (o instanceof long[]) {
            return -5;
        }
        if (o instanceof float[]) {
            return 7;
        }
        if (o instanceof double[]) {
            return 8;
        }
        if (o instanceof Date[]) {
            return 91;
        }
        if (o instanceof Time[]) {
            return 92;
        }
        if (o instanceof Timestamp[]) {
            return 93;
        }
        return 12;
    }

    private static int[] getTypes(Object[] colValues) {
        int[] r = new int[colValues.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = SimpleResultSet.getType(colValues[i]);
        }
        return r;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.idx = row - 1;
        return true;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.idx = -1;
    }

    @Override
    public void afterLast() throws SQLException {
        if (this.colValues.length > 0) {
            this.idx = Array.getLength(this.colValues[0]) + 1;
        }
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        for (int i = 0; i < this.colNames.length; ++i) {
            if (!this.colNames[i].equals(columnLabel)) continue;
            return i + 1;
        }
        throw new SQLException();
    }

    @Override
    public boolean first() throws SQLException {
        this.idx = 0;
        return true;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.resultSetMetaData;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        Object o = Array.get(this.colValues[columnIndex - 1], this.idx);
        this.wasNull = o == null;
        return o;
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getRow() throws SQLException {
        return this.idx;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.idx >= this.colNames.length;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.idx < 0;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.idx == 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.idx == this.colNames.length - 1;
    }

    @Override
    public boolean last() throws SQLException {
        if (this.colValues.length > 0) {
            this.idx = Array.getLength(this.colValues[0]);
            return true;
        }
        return false;
    }

    @Override
    public boolean next() throws SQLException {
        ++this.idx;
        return this.colValues.length > 0 && this.idx < Array.getLength(this.colValues[0]);
    }

    @Override
    public boolean previous() throws SQLException {
        --this.idx;
        return this.idx >= 0;
    }
}

