/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.sqldash.chart;

import com.timestored.connections.JdbcTypes;
import com.timestored.sqldash.chart.ChartFormatException;
import com.timestored.sqldash.chart.ChartResultSet;
import com.timestored.sqldash.chart.ChartTheme;
import com.timestored.sqldash.chart.ExampleView;
import com.timestored.sqldash.chart.UpdateableView;
import com.timestored.sqldash.chart.ViewStrategy;
import com.timestored.theme.Icon;
import com.timestored.theme.Theme;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.sql.ResultSet;
import java.util.Collections;
import java.util.List;
import javax.swing.JPanel;

public enum NoRedrawViewStrategy implements ViewStrategy
{
    INSTANCE;

    private static final String DESC = "Do not draw anything.<br /> This selection does nothing and is for use by those who do not want a chart, allowing quicker result drawing times.";

    @Override
    public UpdateableView getView(ChartTheme theme) {
        return new UpdateableView(){

            @Override
            public void update(ResultSet rs2, ChartResultSet chartResultSet) throws ChartFormatException {
            }

            @Override
            public Component getComponent() {
                JPanel p = new JPanel(new BorderLayout());
                p.add((Component)Theme.getHeader("No Chart Drawing"), "North");
                p.add((Component)Theme.getHtmlText(NoRedrawViewStrategy.DESC), "Center");
                p.setPreferredSize(new Dimension(150, 40));
                return p;
            }
        };
    }

    @Override
    public String getDescription() {
        return "No Redraw";
    }

    @Override
    public String getFormatExplainationHtml() {
        return DESC;
    }

    @Override
    public String getFormatExplaination() {
        return DESC;
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public String getQueryEg(JdbcTypes jdbcType) {
        return null;
    }

    @Override
    public List<ExampleView> getExamples() {
        return Collections.emptyList();
    }

    public String toString() {
        return this.getDescription();
    }

    @Override
    public boolean isQuickToRender(ResultSet rs2, int rowCount, int numColumnCount) {
        return true;
    }

    @Override
    public String getPulseName() {
        return null;
    }
}

