/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.sqldash.chart;

import com.google.common.base.Preconditions;
import com.timestored.connections.JdbcTypes;
import com.timestored.sqldash.chart.ExampleView;
import com.timestored.sqldash.chart.ViewStrategy;
import com.timestored.sqldash.chart.ViewStrategyFactory;
import com.timestored.sqldash.exampledb.ExampleChartDB;
import com.timestored.sqldash.exampledb.ExampleChartQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class KdbExampleChartDB
implements ExampleChartDB {
    private static ExampleChartDB INSTANCE = new KdbExampleChartDB();

    private KdbExampleChartDB() {
    }

    public static ExampleChartDB getInstance() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return "Self-Contained Queries";
    }

    @Override
    public String getDescription() {
        return "Database where no initialisation is needed and each chart example is self-cointained.";
    }

    @Override
    public List<String> getInitSQL(boolean withComments) {
        return Collections.emptyList();
    }

    @Override
    public JdbcTypes getDbType() {
        return JdbcTypes.KDB;
    }

    @Override
    public List<ExampleChartQuery> getQueries() {
        ArrayList<ExampleChartQuery> l = new ArrayList<ExampleChartQuery>();
        for (ViewStrategy vs : ViewStrategyFactory.getStrategies()) {
            for (ExampleView ev : vs.getExamples()) {
                l.add(new ExampleWrapper(ev, vs));
            }
        }
        return l;
    }

    private static class ExampleWrapper
    implements ExampleChartQuery {
        private final ExampleView ev;
        private final ViewStrategy vs;

        ExampleWrapper(ExampleView exampleView, ViewStrategy viewStrategy) {
            this.ev = Preconditions.checkNotNull(exampleView);
            this.vs = Preconditions.checkNotNull(viewStrategy);
        }

        @Override
        public String getName() {
            return this.ev.getName();
        }

        @Override
        public String getDescription() {
            return this.ev.getDescription();
        }

        @Override
        public String getSqlQuery() {
            return this.ev.getTestCase().getKdbQuery();
        }

        @Override
        public ViewStrategy getSupportedViewStrategy() {
            return this.vs;
        }
    }
}

