/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.sqldash.chart;

import com.google.common.base.Preconditions;
import com.timestored.TimeStored;
import com.timestored.babeldb.DBHelper;
import com.timestored.kdb.KError;
import com.timestored.misc.InfoLink;
import com.timestored.sqldash.chart.ChartFormatException;
import com.timestored.sqldash.chart.ChartResultSet;
import com.timestored.sqldash.chart.ChartTheme;
import com.timestored.sqldash.chart.UpdateableView;
import com.timestored.sqldash.chart.ViewStrategy;
import com.timestored.theme.Theme;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import kx.c;
import org.jfree.util.Log;

public class JdbcChartPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static boolean TEST_MODE = true;
    private static final Logger LOG = Logger.getLogger(JdbcChartPanel.class.getName());
    private ViewStrategy viewCreator;
    private ChartTheme theme;
    private boolean renderLargeDataSets = false;
    private UpdateableView updateableView;
    private ResultSet prevRS = null;
    private Exception e = null;
    private ChartFormatException lastChartFormatException = null;
    private ChartResultSet prevCRS = null;

    JdbcChartPanel(ViewStrategy viewCreator, ChartTheme theme) {
        this.viewCreator = Preconditions.checkNotNull(viewCreator);
        this.theme = Preconditions.checkNotNull(theme);
        this.updateableView = viewCreator.getView(theme);
        this.setLayout(new GridLayout(1, 0));
        this.add(this.updateableView.getComponent());
    }

    public void setTheme(ChartTheme theme) {
        if (!this.theme.equals(theme)) {
            this.theme = Preconditions.checkNotNull(theme);
            this.refreshGUI();
        }
    }

    public void setViewStrategy(ViewStrategy viewCreator) {
        if (!this.viewCreator.equals(viewCreator)) {
            this.viewCreator = Preconditions.checkNotNull(viewCreator);
            this.refreshGUI();
        }
    }

    private void refreshGUI() {
        LOG.fine("JdbcChartPanel refreshGUI()");
        ResultSet rs2 = this.prevRS;
        Exception err = this.e;
        JdbcChartPanel.runInUIthread(() -> this.runn(rs2, err), TEST_MODE);
    }

    public static void runInUIthread(Runnable r, boolean invokeAndWait) {
        if (EventQueue.isDispatchThread()) {
            r.run();
        } else if (invokeAndWait) {
            try {
                EventQueue.invokeAndWait(r);
            }
            catch (InterruptedException | InvocationTargetException e) {
                LOG.severe("Severe Error Updating Chart");
            }
        } else {
            EventQueue.invokeLater(r);
        }
    }

    private boolean isNumType(int sqlType) {
        return sqlType == -5 || sqlType == 3 || sqlType == 8 || sqlType == 6 || sqlType == 4 || sqlType == 2 || sqlType == 7 || sqlType == 5 || sqlType == -6;
    }

    private void runn(ResultSet rs2, Exception err) {
        Component c2;
        block14: {
            c2 = null;
            try {
                this.updateableView = this.viewCreator.getView(this.theme);
                if (rs2 != null) {
                    boolean isVerySafeToRender = true;
                    try {
                        int rowCount = DBHelper.getSize(rs2);
                        int numColCount = 0;
                        ResultSetMetaData rsmd = this.prevRS.getMetaData();
                        for (int col = 1; col <= rsmd.getColumnCount(); ++col) {
                            if (!this.isNumType(rsmd.getColumnType(col))) continue;
                            ++numColCount;
                        }
                        isVerySafeToRender = this.viewCreator.isQuickToRender(rs2, rowCount, numColCount);
                    }
                    catch (SQLException e) {
                        Log.warn("Problem assessing how safe it is to render chart:" + err);
                    }
                    this.lastChartFormatException = null;
                    if (isVerySafeToRender || this.renderLargeDataSets) {
                        this.updateableView.update(this.prevRS, this.prevCRS);
                        c2 = this.updateableView.getComponent();
                    } else {
                        String html = "<html>The data is large, it has many rows and/or columns.<br /><b>To continue and draw the chart click the checkbox on the left hand side.</b><br />This may take some time and consume significant memory.</html>";
                        c2 = Theme.getErrorBox("Dataset very large", Theme.getHtmlText(html));
                    }
                    break block14;
                }
                if (this.e instanceof c.KException) {
                    c2 = new JScrollPane(KError.getDescriptionComponent((c.KException)this.e));
                } else if (this.e != null) {
                    String msg = "Error retrieving query";
                    if (this.e != null) {
                        msg = this.e.getMessage();
                    }
                    JTextArea errDetails = Theme.getTextArea("qryErr", msg);
                    c2 = new JScrollPane(Theme.getErrorBox("Query Error", errDetails));
                } else {
                    c2 = new JScrollPane(Theme.getTextArea("noRes", "No table returned."));
                }
            }
            catch (ChartFormatException cfe) {
                this.lastChartFormatException = cfe;
                c2 = JdbcChartPanel.getChartFormatExplaination(this.viewCreator, cfe);
            }
            catch (Exception npe) {
                String txt = "Problem updating view from RecordSet";
                LOG.log(Level.SEVERE, txt, npe);
                c2 = JdbcChartPanel.getChartFormatExplaination(this.viewCreator, null);
            }
        }
        this.removeAll();
        this.add(c2);
        this.revalidate();
    }

    private static Component getChartFormatExplaination(ViewStrategy viewStrategy, ChartFormatException cfe) {
        String text = viewStrategy.getFormatExplainationHtml();
        JEditorPane editPane = new JEditorPane("text/html", "<html>" + text + "</html>");
        JPanel wrapPanel = Theme.getVerticalBoxPanel();
        wrapPanel.add(Theme.getHeader(viewStrategy.getDescription()));
        if (cfe != null) {
            wrapPanel.add(new JLabel(cfe.getDetails()));
        }
        wrapPanel.add(Theme.getSubHeader("Data Format Expected"));
        editPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        wrapPanel.add(editPane);
        wrapPanel.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)InfoLink.getButton("See Example Charts", "Click here to see chart examples", TimeStored.Page.SQLDASH_HELP_EG), "West");
        p.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        wrapPanel.add(p);
        return new JScrollPane(wrapPanel);
    }

    public void update(ResultSet resultSet) {
        this.prevRS = resultSet;
        this.e = null;
        this.prevCRS = null;
        if (resultSet != null) {
            try {
                this.prevCRS = ChartResultSet.getInstance(resultSet);
            }
            catch (SQLException e) {
                LOG.log(Level.INFO, "could not create chartResultSet ", e);
            }
            catch (IllegalArgumentException e) {
                LOG.log(Level.WARNING, "could not create chartResultSet ", e);
            }
            catch (NullPointerException e) {
                LOG.log(Level.WARNING, "could not create chartResultSet ", e);
            }
        }
        this.refreshGUI();
    }

    public void update(Exception e) {
        this.prevRS = null;
        this.e = Preconditions.checkNotNull(e);
        this.prevCRS = null;
        this.refreshGUI();
    }

    public ChartFormatException getLastChartFormatException() {
        return this.lastChartFormatException;
    }

    public void setRenderLargeDataSets(boolean renderLargeDataSets) {
        this.renderLargeDataSets = renderLargeDataSets;
    }

    public boolean isRenderLargeDataSets() {
        return this.renderLargeDataSets;
    }
}

