/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.sqldash.chart;

import com.timestored.sqldash.chart.ColorScheme;
import java.awt.Color;

public class InverseColorScheme
implements ColorScheme {
    private final Color bg;
    private final Color fg;
    private final Color text;
    private final Color gridLines;
    private final Color[] seriesColors;
    private final Color altBgColor;
    private final Color selectedBgColor;

    public InverseColorScheme(ColorScheme colorScheme) {
        this.bg = InverseColorScheme.invert(colorScheme.getBG());
        this.fg = InverseColorScheme.invert(colorScheme.getFG());
        this.text = InverseColorScheme.invert(colorScheme.getText());
        this.gridLines = InverseColorScheme.invert(colorScheme.getGridlines());
        this.altBgColor = InverseColorScheme.invert(colorScheme.getAltBG());
        this.selectedBgColor = InverseColorScheme.invert(colorScheme.getSelectedBG());
        Color[] originalColors = colorScheme.getColorArray();
        this.seriesColors = new Color[originalColors.length];
        for (int i = 0; i < originalColors.length; ++i) {
            this.seriesColors[i] = InverseColorScheme.invert(originalColors[i]);
        }
    }

    private static Color invert(Color c2) {
        return new Color(255 - c2.getRed(), 255 - c2.getGreen(), 255 - c2.getBlue());
    }

    @Override
    public Color getBG() {
        return this.bg;
    }

    @Override
    public Color getAltBG() {
        return this.altBgColor;
    }

    @Override
    public Color getSelectedBG() {
        return this.selectedBgColor;
    }

    @Override
    public Color getFG() {
        return this.fg;
    }

    @Override
    public Color getGridlines() {
        return this.gridLines;
    }

    @Override
    public Color[] getColorArray() {
        return this.seriesColors;
    }

    @Override
    public Color getText() {
        return this.text;
    }
}

