/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.sqldash.chart;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.timestored.connections.JdbcTypes;
import com.timestored.sqldash.chart.ChartFormatException;
import com.timestored.sqldash.chart.ChartResultSet;
import com.timestored.sqldash.chart.ChartTheme;
import com.timestored.sqldash.chart.ExampleView;
import com.timestored.sqldash.chart.KdbFunctions;
import com.timestored.sqldash.chart.SimpleResultSet;
import com.timestored.sqldash.chart.TestCase;
import com.timestored.sqldash.chart.Tooltip;
import com.timestored.sqldash.chart.UpdateableView;
import com.timestored.sqldash.chart.ViewStrategy;
import com.timestored.sqldash.theme.DBIcons;
import com.timestored.theme.Icon;
import java.awt.Component;
import java.sql.ResultSet;
import java.util.List;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.statistics.HistogramDataset;

public enum HistogramViewStrategy implements ViewStrategy
{
    INSTANCE;

    public static final int NUMBER_BINS = 100;
    private static final String KDB_QUERY = "([] Returns:cos 0.0015*til 500; Losses:cos 0.002*til 500)";
    private static final String FORMAT = "Each Numeric column represents a separate series in the histogram. The series values are placed into buckets and their frquency tallied.";

    @Override
    public UpdateableView getView(ChartTheme theme) {
        return new HistogramUpdateableView(theme);
    }

    @Override
    public String getDescription() {
        return "Histogram";
    }

    @Override
    public List<ExampleView> getExamples() {
        String description = "Distribution of Returns and Losses";
        String name = "Profit Distribution";
        String[] colNames = new String[]{"Returns", "Losses"};
        double[] returns = KdbFunctions.cos(KdbFunctions.mul(KdbFunctions.til(500), 0.0015));
        double[] losses = KdbFunctions.cos(KdbFunctions.mul(KdbFunctions.til(500), 0.002));
        Object[] colValues = new Object[]{returns, losses};
        SimpleResultSet resultSet = new SimpleResultSet(colNames, colValues);
        TestCase testCase = new TestCase(name, resultSet, KDB_QUERY);
        return ImmutableList.of(new ExampleView(name, description, testCase));
    }

    @Override
    public String getFormatExplainationHtml() {
        return FORMAT;
    }

    @Override
    public String getFormatExplaination() {
        return FORMAT;
    }

    @Override
    public String getQueryEg(JdbcTypes jdbcType) {
        return jdbcType.equals((Object)JdbcTypes.KDB) ? KDB_QUERY : null;
    }

    @Override
    public Icon getIcon() {
        return DBIcons.CHART_HISTOGRAM;
    }

    public String toString() {
        return HistogramViewStrategy.class.getSimpleName() + "[" + this.getDescription() + "]";
    }

    @Override
    public boolean isQuickToRender(ResultSet rs2, int rowCount, int numColumnCount) {
        return rowCount < 211000;
    }

    @Override
    public String getPulseName() {
        return null;
    }

    private static class HistogramUpdateableView
    implements UpdateableView {
        private final ChartPanel chartPanel;

        public HistogramUpdateableView(ChartTheme theme) {
            Preconditions.checkNotNull(theme);
            JFreeChart chart = ChartFactory.createHistogram("", null, "Frequency", null, PlotOrientation.VERTICAL, true, true, false);
            chart.getXYPlot().getRenderer().setBaseToolTipGenerator(Tooltip.getXYNumbersGenerator());
            this.chartPanel = new ChartPanel(theme.apply(chart));
        }

        @Override
        public void update(ResultSet rs2, ChartResultSet chartRS) throws ChartFormatException {
            if (chartRS.getNumericColumns().size() < 1) {
                throw new ChartFormatException("There must be atleast one number column.");
            }
            HistogramDataset dataset = new HistogramDataset();
            for (ChartResultSet.NumericCol numCol : chartRS.getNumericColumns()) {
                dataset.addSeries((Comparable)((Object)numCol.getLabel()), numCol.getDoubles(), 100);
            }
            XYPlot xyplot = (XYPlot)this.chartPanel.getChart().getPlot();
            xyplot.setDataset(dataset);
            xyplot.getDomainAxis().setLabel(chartRS.getRowTitle());
        }

        @Override
        public Component getComponent() {
            return this.chartPanel;
        }
    }
}

