/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.sqldash.chart;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.timestored.connections.JdbcTypes;
import com.timestored.sqldash.chart.ChartFormatException;
import com.timestored.sqldash.chart.ChartResultSet;
import com.timestored.sqldash.chart.ChartTheme;
import com.timestored.sqldash.chart.ExampleTestCases;
import com.timestored.sqldash.chart.ExampleView;
import com.timestored.sqldash.chart.HardRefreshUpdateableView;
import com.timestored.sqldash.chart.UpdateableView;
import com.timestored.sqldash.chart.ViewStrategy;
import com.timestored.sqldash.theme.DBIcons;
import com.timestored.theme.Icon;
import java.awt.Component;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import net.sf.jtreemap.swing.JTreeMap;
import net.sf.jtreemap.swing.TreeMapNode;
import net.sf.jtreemap.swing.TreeMapNodeBuilder;
import net.sf.jtreemap.swing.ValuePercent;
import net.sf.jtreemap.swing.provider.RedGreenColorProvider;
import net.sf.jtreemap.swing.provider.ZoomPopupMenu;

public enum HeatMapViewStrategy implements ViewStrategy
{
    INSTANCE;

    private static final String[] FORMATA;

    @Override
    public UpdateableView getView(ChartTheme theme) {
        return new HardRefreshUpdateableView(new HardRefreshUpdateableView.ViewGetter(){

            @Override
            public Component getView(ResultSet resultSet, ChartResultSet chartResultSet) throws ChartFormatException {
                JTreeMap treeMap = new JTreeMap(HeatMapViewStrategy.this.createTreeMapDataset(chartResultSet));
                treeMap.setBorder(BorderFactory.createEtchedBorder(1));
                treeMap.setColorProvider(new RedGreenColorProvider(treeMap));
                new ZoomPopupMenu(treeMap);
                return treeMap;
            }
        });
    }

    @Override
    public Icon getIcon() {
        return DBIcons.CHART_HEATMAP;
    }

    private TreeMapNode createTreeMapDataset(ChartResultSet colResultSet) throws ChartFormatException {
        double[] weights;
        List<ChartResultSet.NumericCol> numColumns = colResultSet.getNumericColumns();
        if (numColumns.size() < 1) {
            throw new ChartFormatException("There must be atleast one number column.");
        }
        List<ChartResultSet.StringyCol> stringCols = colResultSet.getStringyColumns();
        if (stringCols.size() == 0) {
            stringCols = ImmutableList.of(colResultSet.getRowLabels());
        }
        double[] values = weights = numColumns.get(0).getDoubles();
        if (numColumns.size() > 1) {
            values = numColumns.get(1).getDoubles();
        }
        return HeatMapViewStrategy.buildStringColTree(stringCols, weights, values);
    }

    private static TreeMapNode buildStringColTree(List<ChartResultSet.StringyCol> stringCols, double[] weights, double[] values) {
        Preconditions.checkArgument(stringCols.size() > 0);
        TreeMapNodeBuilder builder = new TreeMapNodeBuilder();
        TreeMapNode rootNode = builder.buildBranch("Root", null);
        int levels = stringCols.size() - 1;
        if (levels >= 0) {
            ArrayList levelMaps = Lists.newArrayListWithCapacity(levels);
            for (int l = 0; l < levels; ++l) {
                levelMaps.add(new HashMap());
            }
            for (int row = 0; row < weights.length; ++row) {
                TreeMapNode parent = rootNode;
                for (int col = 0; col < stringCols.size(); ++col) {
                    boolean atBranch;
                    List<Object> curLabels = stringCols.get(col).getVals();
                    boolean bl = atBranch = col != stringCols.size() - 1;
                    if (atBranch) {
                        String branchName = stringCols.get(col).getVals().get(row).toString();
                        TreeMapNode branchNode = (TreeMapNode)((Map)levelMaps.get(col)).get(branchName);
                        if (branchNode == null) {
                            branchNode = builder.buildBranch(branchName, parent);
                            ((Map)levelMaps.get(col)).put(branchName, branchNode);
                        }
                        parent = branchNode;
                        continue;
                    }
                    builder.buildLeaf(curLabels.get(row).toString(), weights[row], new ValuePercent(values[row]), parent);
                }
            }
        }
        return builder.getRoot();
    }

    @Override
    public String getDescription() {
        return "Heat Map";
    }

    @Override
    public String getFormatExplainationHtml() {
        return "A HeatMap works best with 1+ string columns.<ol><li>" + Joiner.on("</li><li>").join(FORMATA) + "</li></ol>";
    }

    @Override
    public String getFormatExplaination() {
        return "A HeatMap works best with 1+ string columns.\r\n" + Joiner.on("\r\n").join(FORMATA);
    }

    @Override
    public List<ExampleView> getExamples() {
        ExampleView ev = new ExampleView("Country GDP's", "The continent column is a top-level branch, the country column becomes leafs.The first two columns are GDP and GDP per Capita which become the size and color of the leafs respectively.", ExampleTestCases.COUNTRY_STATS);
        return ImmutableList.of(ev);
    }

    @Override
    public String getQueryEg(JdbcTypes jdbcType) {
        if (jdbcType.equals((Object)JdbcTypes.KDB)) {
            return ExampleTestCases.COUNTRY_STATS.getKdbQuery();
        }
        return null;
    }

    public String toString() {
        return HeatMapViewStrategy.class.getSimpleName() + "[" + this.getDescription() + "]";
    }

    @Override
    public boolean isQuickToRender(ResultSet rs2, int rowCount, int numColumnCount) {
        return rowCount < 4000;
    }

    @Override
    public String getPulseName() {
        return "heatmap";
    }

    static {
        FORMATA = new String[]{"Starting from the left each string column is taken as one nesting level", "The first numerical column will be taken as size, the second as colour."};
    }
}

