/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.sqldash.chart;

import com.google.common.base.Preconditions;
import com.timestored.sqldash.chart.ChartFormatException;
import com.timestored.sqldash.chart.ChartResultSet;
import com.timestored.sqldash.chart.UpdateableView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.sql.ResultSet;
import javax.swing.JPanel;

class HardRefreshUpdateableView
implements UpdateableView {
    private final ViewGetter viewGetter;
    private final JPanel panel = new JPanel(new BorderLayout());

    public HardRefreshUpdateableView(ViewGetter viewGetter) {
        this.viewGetter = Preconditions.checkNotNull(viewGetter);
    }

    @Override
    public void update(ResultSet resultSet, ChartResultSet chartResultSet) throws ChartFormatException {
        if (chartResultSet == null) {
            throw new ChartFormatException("Could not construct ResultSet.");
        }
        Component c2 = this.viewGetter.getView(resultSet, chartResultSet);
        if (c2 != null) {
            final Component com = c2;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HardRefreshUpdateableView.this.panel.removeAll();
                    HardRefreshUpdateableView.this.panel.add(com, "Center");
                    HardRefreshUpdateableView.this.panel.revalidate();
                }
            });
        }
    }

    @Override
    public Component getComponent() {
        return this.panel;
    }

    public static interface ViewGetter {
        public Component getView(ResultSet var1, ChartResultSet var2) throws ChartFormatException;
    }
}

