/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.sqldash.chart;

import com.google.common.base.Preconditions;
import com.timestored.sqldash.chart.KdbFunctions;
import com.timestored.sqldash.chart.SimpleResultSet;
import com.timestored.sqldash.chart.TestCase;
import java.sql.Date;
import java.util.Calendar;

public class ExampleTestCases {
    public static final TestCase COUNTRY_STATS;
    public static final TestCase COUNTRY_STATS_WITHOUT_CONTINENT;
    public static final TestCase COUNTRY_STATS_ADJUSTED_POP;
    public static final TestCase COUNTRY_STATS_GDP_ONLY;
    public static final TestCase MONTHLY_COSTS_SALES;
    public static final TestCase MONTHLY_COSTS_SALES_OVER_MANY_YEARS;
    private static final String[] COUNTRIES;
    private static final String[] CONTINENT;
    public static final double[] GDP;
    private static final double[] GDP_PER_CAPITA;
    private static final double[] POPULATION;
    private static final double[] LIFE_EXP;
    private static final String[] MONTHS;
    private static final double[] COSTS;
    private static final double[] SALES;

    private static String[] getMonths(int year, int month, int count) {
        String[] r = new String[count];
        for (int i = 0; i < count; ++i) {
            int m = (month + i) % 12;
            r[i] = year + i / 12 + "." + (m < 9 ? "0" : "") + (m + 1);
        }
        return r;
    }

    static Date[] getDays(int year, int month, int day, int count) {
        Date[] r = new Date[count];
        for (int i = 0; i < count; ++i) {
            r[i] = new Date(year - 1900, month - 1, day + i);
        }
        return r;
    }

    static Date[] getWeekDays(int year, int month, int day, int count) {
        Preconditions.checkArgument(count >= 0);
        Calendar cal = Calendar.getInstance();
        Date[] r = new Date[count];
        int i = 0;
        Date dt = new Date(year - 1900, month - 1, day + i - 1);
        cal.setTime(dt);
        while (i < count) {
            for (int j = 0; j < 5 && i < count; ++j, ++i) {
                cal.add(5, 1);
                r[i] = new Date(cal.getTimeInMillis());
            }
            cal.add(5, 2);
        }
        return r;
    }

    static String[] getTimes(int hour, int min, int minStep, int count) {
        String[] r = new String[count];
        for (int i = 0; i < r.length; ++i) {
            int m = (min + i * minStep) % 60;
            int h = hour + (min + i * minStep) / 60;
            r[i] = (h < 10 ? "0" : "") + h + ":" + (m < 10 ? "0" : "") + m + ":00";
        }
        return r;
    }

    private static String toQ(double[] nums) {
        StringBuilder sb = new StringBuilder();
        for (double d : nums) {
            sb.append(d);
            sb.append(' ');
        }
        return sb.toString();
    }

    private static String toQ(String[] symSafeStrings) {
        StringBuilder sb = new StringBuilder();
        for (String s : symSafeStrings) {
            sb.append('`');
            sb.append(s);
        }
        return sb.toString();
    }

    static {
        COUNTRIES = new String[]{"US", "China", "japan", "Germany", "UK", "Zimbabwe", "Bangladesh", "Nigeria", "Vietnam"};
        CONTINENT = new String[]{"NorthAmerica", "Asia", "Asia", "Europe", "Europe", "Africa", "Asia", "Africa", "Asia"};
        GDP = new double[]{15080.0, 11300.0, 4444.0, 3114.0, 2228.0, 9.9, 113.0, 196.0, 104.0};
        GDP_PER_CAPITA = new double[]{48300.0, 8400.0, 34700.0, 38100.0, 36500.0, 413.0, 1788.0, 732.0, 3359.0};
        POPULATION = new double[]{313847.0, 1343239.0, 127938.0, 81308.0, 63047.0, 13010.0, 152518.0, 166629.0, 87840.0};
        LIFE_EXP = new double[]{77.14, 72.22, 80.93, 78.42, 78.16, 39.01, 61.33, 51.01, 70.05};
        MONTHS = ExampleTestCases.getMonths(2000, 0, 12);
        COSTS = new double[]{30.0, 40.0, 45.0, 55.0, 58.0, 63.0, 55.0, 65.0, 78.0, 80.0, 75.0, 90.0};
        SALES = new double[]{10.0, 12.0, 14.0, 18.0, 26.0, 42.0, 74.0, 90.0, 110.0, 130.0, 155.0, 167.0};
        String countryCol = " Country:" + ExampleTestCases.toQ(COUNTRIES) + "; ";
        String numCols = "\r\n\t Population:" + ExampleTestCases.toQ(POPULATION) + ";\r\n\t GDP:" + ExampleTestCases.toQ(GDP) + "; \r\n\tGDPperCapita:" + ExampleTestCases.toQ(GDP_PER_CAPITA) + ";  \r\n\tLifeExpectancy:" + ExampleTestCases.toQ(LIFE_EXP) + ")";
        String countryQuery = "([] Continent:" + ExampleTestCases.toQ(CONTINENT) + ";\r\n\t" + countryCol + numCols;
        String[] colTitles = new String[]{"Continent", "Country", "Population", "GDP", "GDPperCapita", "LifeExpectancy"};
        Object[] colValues = new Object[]{CONTINENT, COUNTRIES, POPULATION, GDP, GDP_PER_CAPITA, LIFE_EXP};
        SimpleResultSet rs2 = new SimpleResultSet(colTitles, colValues);
        COUNTRY_STATS = new TestCase("COUNTRY_STATS", rs2, countryQuery);
        String query = "update GDPperCapita%20 from " + countryQuery;
        colValues = new Object[]{CONTINENT, COUNTRIES, POPULATION, GDP, KdbFunctions.mul(GDP_PER_CAPITA, 0.05), LIFE_EXP};
        rs2 = new SimpleResultSet(colTitles, colValues);
        COUNTRY_STATS_ADJUSTED_POP = new TestCase("COUNTRY_STATS", rs2, query);
        query = "([] " + countryCol + numCols;
        colTitles = new String[]{"Country", "Population", "GDP", "GDPperCapita"};
        rs2 = new SimpleResultSet(colTitles, new Object[]{COUNTRIES, POPULATION, GDP, GDP_PER_CAPITA});
        COUNTRY_STATS_WITHOUT_CONTINENT = new TestCase("COUNTRY_STATS_WITHOUT_CONTINENT", rs2, query);
        query = "([] Country:" + ExampleTestCases.toQ(COUNTRIES) + "; \r\n\t GDP:" + ExampleTestCases.toQ(GDP) + ")";
        colTitles = new String[]{"Country", "GDP"};
        rs2 = new SimpleResultSet(colTitles, new Object[]{COUNTRIES, GDP});
        COUNTRY_STATS_GDP_ONLY = new TestCase("COUNTRY_STATS_GDP_ONLY", rs2, query);
        query = "([Month:2000.01m + til 12]  \r\n\t Costs:" + ExampleTestCases.toQ(COSTS) + "; \r\n\t Sales:" + ExampleTestCases.toQ(SALES) + ")";
        colTitles = new String[]{"Month", "Costs", "Sales"};
        rs2 = new SimpleResultSet(colTitles, new Object[]{MONTHS, COSTS, SALES});
        MONTHLY_COSTS_SALES = new TestCase("MONTHLY_COSTS_SALES", rs2, query);
        query = "([Month:2000.01m + til 36]  \r\n\t Costs:36#" + ExampleTestCases.toQ(COSTS) + "; \r\n\t Sales:raze 0 10 20+\\:" + ExampleTestCases.toQ(SALES) + ")";
        colTitles = new String[]{"Month", "Costs", "Sales"};
        double[] threeYearCosts = new double[COSTS.length * 3];
        for (int i = 0; i < threeYearCosts.length; ++i) {
            threeYearCosts[i] = COSTS[i % COSTS.length];
        }
        double[] increasingSales = new double[COSTS.length * 3];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < COSTS.length; ++j) {
                increasingSales[i * ExampleTestCases.COSTS.length + j] = SALES[j] + (double)(i * 10);
            }
        }
        rs2 = new SimpleResultSet(colTitles, new Object[]{ExampleTestCases.getMonths(2000, 0, 36), threeYearCosts, increasingSales});
        MONTHLY_COSTS_SALES_OVER_MANY_YEARS = new TestCase("MONTHLY_COSTS_SALES_OVER_MANY_YEARS", rs2, query);
    }
}

