/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.sqldash.chart;

import com.google.common.base.Preconditions;
import com.timestored.sqldash.chart.ChartTheme;
import com.timestored.sqldash.chart.ColorScheme;
import com.timestored.sqldash.chart.LightColorScheme;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.util.List;
import java.util.Locale;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.title.LegendTitle;

class DefaultTheme
implements ChartTheme {
    private static final StandardXYBarPainter barPainter = new StandardXYBarPainter();
    private static final StandardBarPainter sbarPainter = new StandardBarPainter();
    private static final DefaultTheme INSTANCE = new DefaultTheme(new LightColorScheme(), "Default", "Default");
    private final ColorScheme colorScheme;
    private final StandardChartTheme chartTheme;
    private final DrawingSupplier drawingSupplier;
    private final String description;
    private final String title;

    private DefaultTheme(final ColorScheme colorScheme, String title, String description) {
        this.colorScheme = Preconditions.checkNotNull(colorScheme);
        this.title = Preconditions.checkNotNull(title);
        this.description = Preconditions.checkNotNull(description);
        this.chartTheme = (StandardChartTheme)StandardChartTheme.createJFreeTheme();
        this.chartTheme.setXYBarPainter(barPainter);
        this.chartTheme.setBarPainter(sbarPainter);
        this.chartTheme.setShadowVisible(false);
        this.chartTheme.setShadowPaint(colorScheme.getGridlines());
        this.chartTheme.setPlotBackgroundPaint(colorScheme.getBG());
        this.chartTheme.setDomainGridlinePaint(colorScheme.getGridlines());
        this.chartTheme.setRangeGridlinePaint(colorScheme.getGridlines());
        this.chartTheme.setPlotOutlinePaint(colorScheme.getGridlines());
        this.chartTheme.setChartBackgroundPaint(colorScheme.getBG());
        this.chartTheme.setTitlePaint(colorScheme.getFG());
        this.chartTheme.setAxisLabelPaint(colorScheme.getText());
        this.chartTheme.setLabelLinkPaint(colorScheme.getFG());
        this.chartTheme.setLegendItemPaint(colorScheme.getText());
        this.chartTheme.setLegendBackgroundPaint(colorScheme.getBG());
        if (Locale.getDefault().getLanguage().equals(Locale.SIMPLIFIED_CHINESE.getLanguage())) {
            Font oldExtraLargeFont = this.chartTheme.getExtraLargeFont();
            Font oldLargeFont = this.chartTheme.getLargeFont();
            Font oldRegularFont = this.chartTheme.getRegularFont();
            Font oldSmallFont = this.chartTheme.getSmallFont();
            Font extraLargeFont = new Font("Sans-serif", oldExtraLargeFont.getStyle(), oldExtraLargeFont.getSize());
            Font largeFont = new Font("Sans-serif", oldLargeFont.getStyle(), oldLargeFont.getSize());
            Font regularFont = new Font("Sans-serif", oldRegularFont.getStyle(), oldRegularFont.getSize());
            Font smallFont = new Font("Sans-serif", oldSmallFont.getStyle(), oldSmallFont.getSize());
            this.chartTheme.setExtraLargeFont(extraLargeFont);
            this.chartTheme.setLargeFont(largeFont);
            this.chartTheme.setRegularFont(regularFont);
            this.chartTheme.setSmallFont(smallFont);
        }
        this.drawingSupplier = new DefaultDrawingSupplier(){
            private static final long serialVersionUID = 1L;
            int i = 0;
            int j = 0;
            Color[] colors = colorScheme.getColorArray();

            @Override
            public Paint getNextPaint() {
                return this.colors[this.i++ % this.colors.length];
            }

            @Override
            public Paint getNextFillPaint() {
                return this.colors[this.j++ % this.colors.length];
            }
        };
        this.chartTheme.setDrawingSupplier(this.drawingSupplier);
    }

    public static ChartTheme getInstance(ColorScheme colorScheme, String title, String description) {
        return new DefaultTheme(colorScheme, title, description);
    }

    public static ChartTheme getInstance() {
        return INSTANCE;
    }

    @Override
    public JFreeChart apply(JFreeChart chart) {
        Plot p = chart.getPlot();
        LegendTitle legend = chart.getLegend();
        if (legend != null) {
            legend.setFrame(BlockBorder.NONE);
        }
        p.setDrawingSupplier(this.drawingSupplier);
        p.setForegroundAlpha(0.8f);
        chart.setAntiAlias(true);
        chart.setTextAntiAlias(true);
        this.chartTheme.apply(chart);
        if (chart.getPlot() instanceof CombinedDomainXYPlot) {
            List plots = ((CombinedDomainXYPlot)chart.getPlot()).getSubplots();
            for (Plot plot : plots) {
                int i;
                int domainAxisCount = ((XYPlot)plot).getDomainAxisCount();
                int rangeAxisCount = ((XYPlot)plot).getRangeAxisCount();
                for (i = 0; i < domainAxisCount; ++i) {
                    DefaultTheme.setAxisColor(((XYPlot)plot).getDomainAxis(i), this.colorScheme);
                }
                for (i = 0; i < rangeAxisCount; ++i) {
                    DefaultTheme.setAxisColor(((XYPlot)plot).getRangeAxis(i), this.colorScheme);
                }
            }
        } else {
            Plot plot = chart.getPlot();
            if (plot instanceof XYPlot) {
                int i;
                XYPlot xyPlot = (XYPlot)plot;
                int domainAxisCount = xyPlot.getDomainAxisCount();
                int rangeAxisCount = xyPlot.getRangeAxisCount();
                for (i = 0; i < domainAxisCount; ++i) {
                    DefaultTheme.setAxisColor(xyPlot.getDomainAxis(i), this.colorScheme);
                }
                for (i = 0; i < rangeAxisCount; ++i) {
                    DefaultTheme.setAxisColor(xyPlot.getRangeAxis(i), this.colorScheme);
                }
            }
        }
        if (chart.getPlot() instanceof CategoryPlot) {
            CategoryPlot categoryPlot = (CategoryPlot)chart.getPlot();
            categoryPlot.setDomainGridlinesVisible(true);
            CategoryAxis categoryAxis = categoryPlot.getDomainAxis();
            categoryAxis.setCategoryLabelPositions(CategoryLabelPositions.DOWN_45);
            double margin = 0.02;
            categoryAxis.setCategoryMargin(0.02);
            categoryAxis.setLowerMargin(0.0);
            categoryAxis.setUpperMargin(0.0);
            categoryAxis.setAxisLinePaint(this.colorScheme.getGridlines());
            categoryAxis.setTickMarkPaint(this.colorScheme.getFG());
            categoryAxis.setTickLabelPaint(this.colorScheme.getFG());
            DefaultTheme.setAxisColor(categoryPlot.getRangeAxis(), this.colorScheme);
        } else if (chart.getPlot() instanceof PiePlot) {
            PiePlot piePlot = (PiePlot)chart.getPlot();
            piePlot.setLabelOutlinePaint(this.colorScheme.getFG());
            piePlot.setLabelLinkPaint(this.colorScheme.getFG());
        }
        return chart;
    }

    public static void setAxisColor(ValueAxis valueAxis, ColorScheme colorScheme) {
        valueAxis.setAxisLinePaint(colorScheme.getFG());
        valueAxis.setTickMarkPaint(colorScheme.getText());
        valueAxis.setTickLabelPaint(colorScheme.getText());
    }

    @Override
    public boolean showChartLegend() {
        return true;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Color getForegroundColor() {
        return this.colorScheme.getFG();
    }

    @Override
    public Color getBackgroundColor() {
        return this.colorScheme.getBG();
    }

    @Override
    public Color getAltBackgroundColor() {
        return this.colorScheme.getAltBG();
    }

    @Override
    public Color getSelectedBackgroundColor() {
        return this.colorScheme.getSelectedBG();
    }
}

