/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.sqldash.chart;

import com.google.common.collect.ImmutableList;
import com.timestored.connections.JdbcTypes;
import com.timestored.sqldash.chart.ChartFormatException;
import com.timestored.sqldash.chart.ChartResultSet;
import com.timestored.sqldash.chart.ChartTheme;
import com.timestored.sqldash.chart.ExampleTestCases;
import com.timestored.sqldash.chart.ExampleView;
import com.timestored.sqldash.chart.TableFactory;
import com.timestored.sqldash.chart.TimeStringValuer;
import com.timestored.sqldash.chart.UpdateableView;
import com.timestored.sqldash.chart.ViewStrategy;
import com.timestored.theme.Icon;
import com.timestored.theme.Theme;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.swing.JPanel;

public class DataTableViewStrategy
implements ViewStrategy {
    private static final ViewStrategy INSTANCE = new DataTableViewStrategy(false);
    private final boolean debugView;
    private static final List<ExampleView> EXAMPLES;
    private static final TimeStringValuer TIME_STRINGVAL;
    private static final String FORMAT = "Any format of table is acceptable, all rows/columns will be shown as a plain table.";

    private DataTableViewStrategy(boolean debugView) {
        this.debugView = debugView;
    }

    public static ViewStrategy getInstance() {
        return INSTANCE;
    }

    @Override
    public UpdateableView getView(ChartTheme theme) {
        return new DataTableUpdateableView(this.debugView);
    }

    @Override
    public String getDescription() {
        return this.debugView ? "Debug Table" : "Data Table";
    }

    @Override
    public String getFormatExplainationHtml() {
        return FORMAT;
    }

    @Override
    public String getFormatExplaination() {
        return FORMAT;
    }

    @Override
    public List<ExampleView> getExamples() {
        return EXAMPLES;
    }

    @Override
    public String getQueryEg(JdbcTypes jdbcType) {
        if (jdbcType.equals((Object)JdbcTypes.KDB)) {
            return ExampleTestCases.COUNTRY_STATS.getKdbQuery();
        }
        return null;
    }

    @Override
    public Icon getIcon() {
        return Theme.CIcon.TABLE_ELEMENT;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.debugView ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataTableViewStrategy other = (DataTableViewStrategy)obj;
        return this.debugView == other.debugView;
    }

    public String toString() {
        return DataTableViewStrategy.class.getSimpleName() + "[" + this.getDescription() + "]";
    }

    @Override
    public boolean isQuickToRender(ResultSet rs2, int rowCount, int numColumnCount) {
        return rowCount < 211000;
    }

    @Override
    public String getPulseName() {
        return "grid";
    }

    static {
        TIME_STRINGVAL = new TimeStringValuer();
        ExampleView ev3 = new ExampleView("Many Columned Table", "All rows/columns will be shown as a plain table.", ExampleTestCases.COUNTRY_STATS);
        EXAMPLES = ImmutableList.of(ev3);
    }

    private static class DataTableUpdateableView
    implements UpdateableView {
        private final JPanel p;
        private final boolean debugView;

        public DataTableUpdateableView(boolean debugView) {
            this.debugView = debugView;
            this.p = new JPanel(new BorderLayout());
        }

        @Override
        public void update(ResultSet rs2, ChartResultSet chartResultSet) throws ChartFormatException {
            try {
                this.p.removeAll();
                Component tbl = TableFactory.getTable(rs2, Integer.MAX_VALUE);
                this.p.add(tbl, "Center");
                this.p.revalidate();
            }
            catch (SQLException e) {
                throw new ChartFormatException("Could not create ResultSet.");
            }
        }

        @Override
        public Component getComponent() {
            return this.p;
        }

        private static Color getColor(String cVal) {
            Color cl = null;
            try {
                try {
                    Field f = Color.class.getField(cVal);
                    cl = (Color)f.get(null);
                }
                catch (SecurityException securityException) {
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
                if (cl == null) {
                    cl = Color.decode(cVal);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return cl;
        }
    }
}

