/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.sqldash.chart;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ChartViewConfiguration {
    private final Set<String> domainColumnNames = new HashSet<String>();
    private final Map<String, ColumnConfiguration> colConfigs = new HashMap<String, ColumnConfiguration>();
    private static final ColumnConfiguration DEFAULT_COLUMN_CONFIG = new ColumnConfiguration(Shape.LINE, Axis.LEFT);

    private boolean refresh(ResultSet tab) {
        this.domainColumnNames.clear();
        return true;
    }

    public List<String> getAllColumnNames() {
        HashSet<String> cols = new HashSet<String>(this.colConfigs.keySet());
        cols.addAll(this.domainColumnNames);
        return new ArrayList<String>(cols);
    }

    public boolean isDomainColumn(String colName) {
        return this.domainColumnNames.contains(colName);
    }

    public Shape getShape(String colName) {
        ColumnConfiguration colConfig = this.colConfigs.get(colName);
        if (colConfig == null) {
            throw new IllegalArgumentException("column name not known");
        }
        return colConfig.shape;
    }

    public Axis getAxis(String colName) {
        ColumnConfiguration colConfig = this.colConfigs.get(colName);
        if (colConfig == null) {
            throw new IllegalArgumentException("column name not known:" + colName);
        }
        return colConfig.axis;
    }

    private static class ColumnConfiguration {
        private final Shape shape;
        private final Axis axis;

        public ColumnConfiguration(Shape shape, Axis axis) {
            this.shape = shape;
            this.axis = axis;
        }
    }

    public static enum Axis {
        LEFT,
        RIGHT,
        HIDE;

    }

    public static enum Shape {
        LINE,
        BAR,
        AREA,
        CANDLESTICK,
        HIGHLOW;

    }
}

