/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.sqldash.chart;

import com.timestored.babeldb.BabelDBJdbcDriver;
import com.timestored.misc.SaveableFrame;
import com.timestored.sqldash.chart.ChartFormatException;
import com.timestored.sqldash.chart.ChartTheme;
import com.timestored.sqldash.chart.JdbcChartPanel;
import com.timestored.sqldash.chart.ViewStrategy;
import com.timestored.sqldash.chart.ViewStrategyFactory;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class ChartUtils {
    private static final int HEIGHT = 600;
    private static final int WIDTH = 800;

    static void save(ViewStrategy viewStrategy, ResultSet resultSet, File file) throws IOException {
        ChartUtils.save(viewStrategy, resultSet, file, 800, 600);
    }

    public static void save(ViewStrategy viewStrategy, ResultSet resultSet, File file, int width, int height) throws IOException {
        ChartUtils.save(viewStrategy, resultSet, file, width, height, null);
    }

    public static void save(ViewStrategy viewStrategy, ResultSet resultSet, File file, int width, int height, ChartTheme chartTheme) throws IOException {
        final JdbcChartPanel jdbcChartPanel = ViewStrategyFactory.getJdbcChartpanel(viewStrategy);
        if (chartTheme != null) {
            jdbcChartPanel.setTheme(chartTheme);
        }
        jdbcChartPanel.update(resultSet);
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    jdbcChartPanel.validate();
                    jdbcChartPanel.repaint();
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        ChartFormatException cfe = jdbcChartPanel.getLastChartFormatException();
        if (cfe != null) {
            throw cfe;
        }
        SaveableFrame.saveComponentImage(jdbcChartPanel, width, height, file);
    }

    public static void queryKdbAndSave(ViewStrategy viewStrategy, String query, File file, Connection conn) throws IOException {
        try {
            Statement st2 = conn.createStatement();
            ResultSet rs2 = st2.executeQuery("q)" + query);
            ChartUtils.save(viewStrategy, rs2, file, 800, 600);
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    public static void queryDuckdbAndSave(ViewStrategy viewStrategy, String query, File file, BabelDBJdbcDriver babeldb) throws IOException {
        ResultSet rs2 = babeldb.executeQryForTestsOnly(query);
        ChartUtils.save(viewStrategy, rs2, file, 800, 600);
    }
}

