/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.sqldash.chart;

import com.timestored.sqldash.chart.ChartResultSet;
import com.timestored.sqldash.chart.SqlHelper;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

class ChartResultSetBuilder {
    ChartResultSetBuilder() {
    }

    public static ChartResultSet getChartResultSet(List<ChartResultSet.NumericCol> numericColumns, ChartResultSet.StringyCol rowLabels) throws SQLException {
        ArrayList<ChartResultSet.StringyCol> stringyColumns = new ArrayList<ChartResultSet.StringyCol>();
        stringyColumns.add(rowLabels);
        List<String> rowLabelsL = rowLabels.getVals().stream().map(v -> "" + v).collect(Collectors.toList());
        return new ChartResultSet(numericColumns, stringyColumns, rowLabelsL, null, "Row", "");
    }

    public static ChartResultSet transpose(ChartResultSet crs) {
        if (crs.getRowCount() != 1 || crs.getNumericColumns().size() < 2) {
            throw new IllegalArgumentException("Can only transpose limited results sets for now.");
        }
        ArrayList<ChartResultSet.StringyCol> stringyColumns = new ArrayList<ChartResultSet.StringyCol>();
        List<String> rowLabels = crs.getNumericColumns().stream().map(nc -> nc.getLabel()).collect(Collectors.toList());
        List<Object> rowLabelsO = rowLabels.stream().collect(Collectors.toList());
        stringyColumns.add(new ChartResultSet.StringyCol("Name", 12, rowLabelsO));
        double[] va = new double[rowLabels.size()];
        for (int i = 0; i < va.length; ++i) {
            va[i] = crs.getNumericColumns().get(i).getDoubles()[0];
        }
        String rl = crs.getRowLabel(0).equals("1") ? "" : crs.getRowLabel(0);
        ChartResultSet.NumericCol nc2 = new ChartResultSet.NumericCol(rl, 8, va);
        ArrayList<ChartResultSet.NumericCol> lnc = new ArrayList<ChartResultSet.NumericCol>(1);
        lnc.add(nc2);
        return new ChartResultSet(lnc, stringyColumns, rowLabels, null, "Row", "");
    }

    public static ChartResultSet getChartResultSet(ResultSet rs2) throws SQLException {
        int ctype;
        rs2.beforeFirst();
        ResultSetMetaData md = rs2.getMetaData();
        int colCount = md.getColumnCount();
        ArrayList<ChartResultSet.NumericCol> numericColumns = new ArrayList<ChartResultSet.NumericCol>();
        ArrayList<ChartResultSet.StringyCol> stringyColumns = new ArrayList<ChartResultSet.StringyCol>();
        ChartResultSet.TimeCol timeColumn = null;
        String rowTitle = "";
        ArrayList<Integer> stringIdxs = new ArrayList<Integer>();
        for (int c2 = 1; c2 <= colCount && !SqlHelper.isNumeric(ctype = md.getColumnType(c2), md.getColumnTypeName(c2)); ++c2) {
            rowTitle = rowTitle + (c2 == 1 ? "" : " - ") + md.getColumnName(c2);
            stringIdxs.add(c2);
        }
        if (rowTitle.length() == 0) {
            rowTitle = "Row";
        }
        List<String> rowLabels = ChartResultSetBuilder.getRowLabels(rs2, stringIdxs);
        int rowCount = rowLabels.size();
        for (int c3 = 1; c3 <= colCount; ++c3) {
            int ctype2 = md.getColumnType(c3);
            if (SqlHelper.isNumeric(ctype2, md.getColumnTypeName(c3))) {
                numericColumns.add(new ChartResultSet.NumericCol(md.getColumnName(c3), ctype2, ChartResultSetBuilder.getDoubles(c3, rs2, rowCount)));
                continue;
            }
            if (SqlHelper.isTemporal(ctype2, md.getColumnTypeName(c3)) && timeColumn == null) {
                timeColumn = new ChartResultSet.TimeCol(md.getColumnName(c3), ctype2, ChartResultSetBuilder.getObjects(c3, rs2));
            }
            stringyColumns.add(new ChartResultSet.StringyCol(md.getColumnName(c3), ctype2, ChartResultSetBuilder.getObjects(c3, rs2)));
        }
        return new ChartResultSet(numericColumns, stringyColumns, rowLabels, timeColumn, rowTitle, "");
    }

    private static List<String> getRowLabels(ResultSet rs2, List<Integer> stringIdxs) throws SQLException {
        ArrayList<String> rowNames = new ArrayList<String>();
        rs2.beforeFirst();
        if (stringIdxs.size() > 0) {
            while (rs2.next()) {
                String s = "" + rs2.getObject(stringIdxs.get(0));
                for (int idx = 1; idx < stringIdxs.size(); ++idx) {
                    s = s + " - " + rs2.getObject(stringIdxs.get(idx));
                }
                rowNames.add(s);
            }
        } else {
            int row = 1;
            while (rs2.next()) {
                rowNames.add("" + row++);
            }
        }
        return rowNames;
    }

    private static double[] getDoubles(int column, ResultSet rs2, int rowCount) throws SQLException {
        double[] nums = new double[rowCount];
        rs2.beforeFirst();
        int i = 0;
        while (rs2.next()) {
            Object o = rs2.getObject(column);
            if (o == null) {
                nums[i] = Double.NaN;
            } else if (o instanceof Number) {
                Number n = (Number)rs2.getObject(column);
                nums[i] = n.doubleValue();
            } else {
                nums[i] = rs2.getDouble(column);
            }
            ++i;
        }
        assert (i == nums.length);
        return nums;
    }

    private static List<Object> getObjects(int column, ResultSet rs2) throws SQLException {
        ArrayList<Object> vals = new ArrayList<Object>();
        rs2.beforeFirst();
        while (rs2.next()) {
            vals.add(rs2.getObject(column));
        }
        return vals;
    }
}

