/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.sqldash.chart;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.timestored.sqldash.chart.ChartResultSetBuilder;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.jfree.data.time.Day;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;

class ChartResultSet {
    private final List<NumericCol> numericColumns;
    private final List<StringyCol> stringyColumns;
    private final TimeCol timeCol;
    private final List<String> rowLabels;
    private final String rowTitle;
    private final String colTitle;

    public static ChartResultSet getInstance(ResultSet rs2) throws SQLException {
        return ChartResultSetBuilder.getChartResultSet(rs2);
    }

    public static ChartResultSet getTransposedInstance(ResultSet rs2) throws SQLException {
        return ChartResultSetBuilder.getChartResultSet(rs2);
    }

    ChartResultSet(List<NumericCol> numericColumns, List<StringyCol> stringyColumns, List<String> rowTitles, TimeCol timeCol, String rowTitle, String colTitle) {
        this.numericColumns = Collections.unmodifiableList(Preconditions.checkNotNull(numericColumns));
        this.stringyColumns = Collections.unmodifiableList(Preconditions.checkNotNull(stringyColumns));
        this.rowLabels = Collections.unmodifiableList(Preconditions.checkNotNull(rowTitles));
        this.rowTitle = Preconditions.checkNotNull(rowTitle);
        this.colTitle = Preconditions.checkNotNull(colTitle);
        this.timeCol = timeCol;
        int rowCount = rowTitles.size();
        Preconditions.checkArgument(timeCol == null || timeCol.size() == rowCount);
        for (NumericCol numericCol : this.numericColumns) {
            Preconditions.checkArgument(numericCol.getDoubles().length == rowCount);
        }
        for (StringyCol stringyCol : this.stringyColumns) {
            Preconditions.checkArgument(stringyCol.getVals().size() == rowCount);
        }
    }

    public NumericCol getNumericalColumn(String columnLabel) {
        for (NumericCol nc : this.numericColumns) {
            if (!nc.getLabel().equalsIgnoreCase(columnLabel)) continue;
            return nc;
        }
        return null;
    }

    public int getRowCount() {
        return this.rowLabels.size();
    }

    public TimeCol getTimeCol() {
        return this.timeCol;
    }

    public List<NumericCol> getNumericColumns() {
        return this.numericColumns;
    }

    public List<StringyCol> getStringyColumns() {
        return this.stringyColumns;
    }

    public String getRowLabel(int row) {
        return this.rowLabels.get(row);
    }

    private List<String> getColumnNames(List<? extends Col> cols) {
        ArrayList<String> n = Lists.newArrayList();
        for (Col col : cols) {
            n.add(col.getLabel());
        }
        return n;
    }

    public String toString() {
        MoreObjects.ToStringHelper tsh = MoreObjects.toStringHelper(this).add("numericColumns", Joiner.on(',').join(this.getColumnNames(this.numericColumns)));
        if (this.timeCol == null) {
            tsh.add("timeCol", "no time col");
        } else {
            tsh.add("timeCol", this.timeCol.getLabel());
        }
        if (this.numericColumns.size() > 0) {
            tsh.add("numeric rows", this.numericColumns.get(0).getDoubles().length);
        }
        return tsh.toString();
    }

    public String getRowTitle() {
        return this.rowTitle;
    }

    public String getColTitle() {
        return this.colTitle;
    }

    public StringyCol getRowLabels() {
        ArrayList<Object> objList = new ArrayList<Object>(this.rowLabels.size());
        for (String s : this.rowLabels) {
            objList.add(s);
        }
        return new StringyCol(this.getRowTitle(), 12, objList);
    }

    public static class TimeCol
    extends StringyCol {
        private volatile Date[] dates = null;

        TimeCol(String name, int type, List<Object> vals) {
            super(name, type, vals);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Date[] getDates() {
            if (this.dates == null) {
                TimeCol timeCol = this;
                synchronized (timeCol) {
                    if (this.dates == null) {
                        this.dates = this.convertToDate(this.vals);
                    }
                }
            }
            return this.dates;
        }

        public RegularTimePeriod[] getRegularTimePeriods() {
            return this.convertToJFreeTime(this.vals);
        }

        private RegularTimePeriod[] convertToJFreeTime(List<Object> timeObjects) {
            int rowCount = timeObjects.size();
            RegularTimePeriod[] res = new RegularTimePeriod[rowCount];
            int unconvertedRows = 0;
            for (int row = 0; row < rowCount; ++row) {
                Object timeObject = timeObjects.get(row);
                RegularTimePeriod timePeriod = null;
                if (timeObject instanceof RegularTimePeriod) {
                    timePeriod = (RegularTimePeriod)timeObject;
                } else if (timeObject instanceof YearMonth) {
                    YearMonth t = (YearMonth)timeObject;
                    LocalDate ld = t.atDay(1);
                    timePeriod = new Day(ld.getDayOfMonth(), ld.getMonthValue(), ld.getYear());
                } else if (timeObject instanceof Time) {
                    Time t = (Time)timeObject;
                    timePeriod = new Millisecond(new Date(t.getTime()));
                } else if (timeObject instanceof OffsetTime) {
                    timePeriod = new Millisecond(new Date(((OffsetTime)timeObject).getLong(ChronoField.MILLI_OF_DAY)));
                } else if (timeObject instanceof OffsetDateTime) {
                    timePeriod = new Day(new Date(((OffsetDateTime)timeObject).toInstant().toEpochMilli()));
                } else if (timeObject instanceof LocalTime) {
                    long tick = ((LocalTime)timeObject).atOffset(ZoneOffset.UTC).getLong(ChronoField.MILLI_OF_DAY);
                    timePeriod = new Millisecond(new Date(tick), TimeZone.getTimeZone("UTC"));
                } else if (timeObject instanceof Timestamp) {
                    timePeriod = new Millisecond((Timestamp)timeObject, TimeZone.getTimeZone("UTC"));
                } else if (timeObject instanceof LocalDate) {
                    LocalDate ld = (LocalDate)timeObject;
                    timePeriod = new Day(ld.getDayOfMonth(), ld.getMonthValue(), ld.getYear());
                } else if (timeObject instanceof LocalDateTime) {
                    long tick = ((LocalDateTime)timeObject).atZone(ZoneOffset.UTC).toInstant().toEpochMilli();
                    timePeriod = new Millisecond(new Date(tick), TimeZone.getTimeZone("UTC"));
                } else if (timeObject instanceof Timestamp) {
                    timePeriod = new Millisecond((Timestamp)timeObject, TimeZone.getTimeZone("UTC"));
                } else if (timeObject instanceof Date) {
                    timePeriod = new Day((Date)timeObject, TimeZone.getTimeZone("UTC"));
                } else if (timeObject instanceof Instant) {
                    long tick = ((Instant)timeObject).toEpochMilli();
                    timePeriod = new Millisecond(new Date(tick), TimeZone.getTimeZone("UTC"));
                } else {
                    ++unconvertedRows;
                }
                res[row] = timePeriod;
            }
            if (rowCount > 0 && unconvertedRows == rowCount) {
                throw new IllegalArgumentException("Could not convert any rows of the time column");
            }
            return res;
        }

        private Date[] convertToDate(List<Object> timeObjects) {
            int rowCount = timeObjects.size();
            Date[] res = new Date[rowCount];
            int nullRows = 0;
            for (int row = 0; row < rowCount; ++row) {
                Object timeObject = timeObjects.get(row);
                Date timePeriod = null;
                if (timeObject instanceof Date) {
                    timePeriod = (Date)timeObject;
                } else if (timeObject instanceof Timestamp) {
                    Timestamp t = (Timestamp)timeObject;
                    timePeriod = new Date(t.getTime());
                } else if (timeObject instanceof LocalDate) {
                    LocalDate ld = (LocalDate)timeObject;
                    timePeriod = Date.from(ld.atStartOfDay(ZoneId.of("UTC")).toInstant());
                } else if (timeObject instanceof LocalDateTime) {
                    timePeriod = new Date(((LocalDateTime)timeObject).atZone(ZoneOffset.UTC).toInstant().toEpochMilli());
                } else {
                    ++nullRows;
                }
                res[row] = timePeriod;
            }
            if (rowCount > 0 && nullRows == rowCount) {
                throw new IllegalArgumentException("no known time row found");
            }
            return res;
        }
    }

    public static class StringyCol
    extends Col {
        protected final List<Object> vals;

        StringyCol(String name, int type, List<Object> vals) {
            super(name, type);
            this.vals = vals;
        }

        public int size() {
            return this.vals == null ? 0 : this.vals.size();
        }

        public List<Object> getVals() {
            return this.vals;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.vals == null ? 0 : this.vals.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (obj != null && this.getClass() == obj.getClass()) {
                StringyCol that = (StringyCol)obj;
                if (this.vals.size() != that.vals.size()) {
                    return false;
                }
                for (int i = 0; i < this.vals.size(); ++i) {
                    if (this.vals.get(i).toString().equals(that.vals.get(i).toString())) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public String toString() {
            return "StringyCol [vals=" + this.vals + "]";
        }
    }

    public static class NumericCol
    extends Col {
        private final double[] vals;

        NumericCol(String name, int type, double[] vals) {
            super(name, type);
            this.vals = vals;
        }

        public double[] getDoubles() {
            return this.vals;
        }

        public String toString() {
            return "NumericCol [vals=" + Arrays.toString(this.vals) + "]";
        }
    }

    public static abstract class Col {
        private final int type;
        private final String name;

        Col(String name, int type) {
            this.name = name;
            this.type = type;
        }

        public String getLabel() {
            return this.name;
        }

        public int getType() {
            return this.type;
        }
    }
}

