/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.sqldash.chart;

import com.timestored.sqldash.chart.AbstractCategoryViewStrategy;
import com.timestored.sqldash.chart.CategoryDatasetUpdateableView;
import com.timestored.sqldash.chart.ChartTheme;
import com.timestored.sqldash.chart.UpdateableView;
import com.timestored.sqldash.chart.ViewStrategy;
import com.timestored.sqldash.theme.DBIcons;
import java.awt.Color;
import java.sql.ResultSet;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;

class AreaChartViewStrategy
extends AbstractCategoryViewStrategy {
    public static final ViewStrategy INSTANCE = new AreaChartViewStrategy();

    private AreaChartViewStrategy() {
        super("Area Chart", DBIcons.CHART_AREA);
    }

    @Override
    public UpdateableView getView(ChartTheme theme) {
        JFreeChart chart = ChartFactory.createAreaChart("", "", "", null, PlotOrientation.VERTICAL, theme.showChartLegend(), true, false);
        chart.setBackgroundPaint(Color.white);
        chart.getPlot().setForegroundAlpha(0.8f);
        return new CategoryDatasetUpdateableView(theme, chart);
    }

    public String toString() {
        return AreaChartViewStrategy.class.getSimpleName() + "[" + this.getDescription() + "]";
    }

    @Override
    public boolean isQuickToRender(ResultSet rs2, int rowCount, int numColumnCount) {
        return numColumnCount * rowCount < 10000;
    }

    @Override
    public String getPulseName() {
        return "area";
    }
}

