/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.sqldash;

import com.google.common.base.Joiner;
import com.google.common.io.Files;
import com.timestored.connections.ConnectionManager;
import com.timestored.connections.ServerConfig;
import com.timestored.misc.CmdRunner;
import com.timestored.sqldash.ChartParams;
import com.timestored.sqldash.chart.ChartFormatException;
import com.timestored.sqldash.chart.ChartUtils;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.logging.Handler;
import java.util.logging.Logger;
import javax.sql.rowset.CachedRowSet;
import joptsimple.OptionException;
import joptsimple.OptionSet;

public class SqlChart {
    private static final Logger LOG = Logger.getLogger(SqlChart.class.getName());

    public static void main(String ... args) {
        Handler[] handlers;
        Logger globalLogger = Logger.getLogger("");
        for (Handler handler : handlers = globalLogger.getHandlers()) {
            globalLogger.removeHandler(handler);
        }
        System.exit(SqlChart.run(args));
    }

    public static int run(String ... args) {
        int exitCode = 0;
        if (args.length > 0) {
            Exception ex;
            block13: {
                ex = null;
                try {
                    LOG.info("Generating Chart for args: " + Joiner.on(" ").join(args));
                    OptionSet o = ChartParams.parse(args);
                    if (o.has("?")) {
                        try {
                            ChartParams.printHelpOn(System.out);
                            break block13;
                        }
                        catch (IOException e) {
                            throw new IOException("Error displaying help.");
                        }
                    }
                    SqlChart.generate(ChartParams.getChartParams(o));
                }
                catch (IOException e) {
                    ex = e;
                }
                catch (SQLException e) {
                    ex = new SQLException("SQL Error: " + e.getMessage());
                }
                catch (OptionException e) {
                    ex = e;
                }
                catch (IllegalArgumentException e) {
                    ex = e;
                }
            }
            if (ex != null) {
                System.err.println(ex.getMessage());
                exitCode = 1;
            }
        } else {
            try {
                ChartParams.printHelpOn(System.out);
            }
            catch (IOException e) {
                System.err.println("Error printing help.");
            }
        }
        return exitCode;
    }

    public static int testGenerate(String arg) {
        return SqlChart.run(CmdRunner.parseCommand(arg));
    }

    public static void generate(ChartParams chartParams) throws IOException, SQLException {
        ServerConfig sc = chartParams.serverConfig;
        try {
            Class.forName(sc.getJdbcType().getDriver());
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Database driver could not be loaded.");
        }
        try {
            ConnectionManager connMan = ConnectionManager.newInstance();
            connMan.addServer(sc);
            Connection conn = DriverManager.getConnection(sc.getUrl(), sc.getUsername(), sc.getPassword());
            CachedRowSet rs2 = connMan.executeQuery(sc, chartParams.query);
            File file = chartParams.file;
            try {
                Files.createParentDirs(file);
                ChartUtils.save(chartParams.viewStrategy, rs2, file, chartParams.width, chartParams.height, chartParams.chartTheme);
                System.out.println(file.getAbsolutePath());
            }
            catch (ChartFormatException e) {
                String msg = "Error: " + e.getMessage() + "\r\n\r\nFormat Expected:\r\n";
                msg = msg + chartParams.viewStrategy.getFormatExplaination();
                throw new IOException(msg);
            }
            catch (IOException e) {
                throw new IOException("Error creating necessary output folders/files: " + file.getPath());
            }
        }
        catch (SQLException e) {
            throw new IOException("Error getting database connection: " + e.getMessage());
        }
    }
}

