/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.sqldash;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;

public class Queryable {
    private static final Logger LOG = Logger.getLogger(Queryable.class.getName());
    private final transient List<Listener> listeners = new CopyOnWriteArrayList<Listener>();
    private String serverName = "localhost:5000";
    private String query = "";
    private int refreshPeriod;

    public Queryable() {
    }

    public Queryable(String serverName, String query, int refreshPeriod) {
        this.serverName = serverName;
        this.query = query;
        this.refreshPeriod = refreshPeriod;
    }

    public Queryable(String serverName, String query) {
        this(serverName, query, 0);
    }

    Queryable(Queryable app) {
        this.serverName = app.getServerName();
        this.query = app.getQuery();
        this.refreshPeriod = app.getRefreshPeriod();
    }

    public void setQuery(String query) {
        this.query = Preconditions.checkNotNull(query);
        this.cc();
    }

    public void setServerName(String serverName) {
        this.serverName = Preconditions.checkNotNull(serverName);
        this.cc();
    }

    public void setRefreshPeriod(int milliseconds) {
        if (milliseconds < -1) {
            throw new IllegalArgumentException("refresh period must be >=-1");
        }
        this.refreshPeriod = milliseconds;
        this.cc();
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getQuery() {
        return this.query;
    }

    public int getRefreshPeriod() {
        return this.refreshPeriod;
    }

    private void cc() {
        LOG.info("Queryable configChanged");
        for (Listener l : this.listeners) {
            l.configChanged(this);
        }
    }

    public boolean addListener(Listener queryableListener) {
        return this.listeners.add(queryableListener);
    }

    public boolean removeListener(Listener queryableListener) {
        return this.listeners.remove(queryableListener);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.query == null ? 0 : this.query.hashCode());
        result = 31 * result + this.refreshPeriod;
        result = 31 * result + (this.serverName == null ? 0 : this.serverName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Queryable other = (Queryable)obj;
        if (this.query == null ? other.query != null : !this.query.equals(other.query)) {
            return false;
        }
        if (this.refreshPeriod != other.refreshPeriod) {
            return false;
        }
        return !(this.serverName == null ? other.serverName != null : !this.serverName.equals(other.serverName));
    }

    public String toString() {
        return "Queryable(listeners=" + this.listeners + ", serverName=" + this.getServerName() + ", query=" + this.getQuery() + ", refreshPeriod=" + this.getRefreshPeriod() + ")";
    }

    public static interface Listener {
        public void configChanged(Queryable var1);
    }
}

