/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.sqldash;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import joptsimple.HelpFormatter;
import joptsimple.OptionDescriptor;

class HtmlHelpFormatter
implements HelpFormatter {
    HtmlHelpFormatter() {
    }

    @Override
    public String format(Map<String, ? extends OptionDescriptor> options) {
        StringBuilder sb = new StringBuilder();
        if (!options.isEmpty()) {
            Comparator<OptionDescriptor> comparator = new Comparator<OptionDescriptor>(){

                @Override
                public int compare(OptionDescriptor first, OptionDescriptor second) {
                    return first.options().iterator().next().compareTo(second.options().iterator().next());
                }
            };
            TreeSet<OptionDescriptor> sorted = new TreeSet<OptionDescriptor>(comparator);
            HashSet<String> seenCommands = Sets.newHashSet();
            for (OptionDescriptor optionDescriptor : options.values()) {
                String k = this.getOptionDisplay(optionDescriptor);
                if (seenCommands.contains(k)) continue;
                seenCommands.add(k);
                sorted.add(optionDescriptor);
            }
            sb.append("<table>\r\n<tr><th>Option");
            if (this.hasRequiredOption(sorted)) {
                sb.append(" (<span class='required'>*</span> = required)");
            }
            sb.append("</th><th>Description</th></tr>");
            for (OptionDescriptor optionDescriptor : sorted) {
                sb.append("\r\n\t<tr>");
                sb.append("<td style='white-space:nowrap;'><code>");
                sb.append(this.getOptionDisplay(optionDescriptor));
                sb.append("</code></td><td>");
                List<?> defVals = optionDescriptor.defaultValues();
                if (defVals.isEmpty()) {
                    sb.append(optionDescriptor.description());
                } else {
                    String def = defVals.size() == 1 ? defVals.get(0).toString() : defVals.toString();
                    sb.append(optionDescriptor.description() + " (default: " + def + ")");
                }
                sb.append("</td></tr>");
            }
            sb.append("\r\n</table>");
        }
        return sb.toString();
    }

    private boolean hasRequiredOption(Collection<? extends OptionDescriptor> options) {
        for (OptionDescriptor optionDescriptor : options) {
            if (!optionDescriptor.isRequired()) continue;
            return true;
        }
        return false;
    }

    private String getOptionDisplay(OptionDescriptor descriptor) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(descriptor.isRequired() ? "<span class='required'>*</span>" : "");
        Iterator<String> i = descriptor.options().iterator();
        while (i.hasNext()) {
            String option = i.next();
            buffer.append(option.length() > 1 ? "--" : "-");
            buffer.append(option);
            if (!i.hasNext()) continue;
            buffer.append(", ");
        }
        this.maybeAppendOptionInfo(buffer, descriptor);
        return buffer.toString();
    }

    private void maybeAppendOptionInfo(StringBuilder buffer, OptionDescriptor descriptor) {
        String indicator = this.extractTypeIndicator(descriptor);
        String description = descriptor.argumentDescription();
        if (indicator != null || !Strings.isNullOrEmpty(description)) {
            this.appendOptionHelp(buffer, indicator, description, descriptor.requiresArgument());
        }
    }

    private String extractTypeIndicator(OptionDescriptor descriptor) {
        String indicator = descriptor.argumentTypeIndicator();
        if (!Strings.isNullOrEmpty(indicator) && !String.class.getName().equals(indicator)) {
            return indicator;
        }
        return null;
    }

    private void appendOptionHelp(StringBuilder buffer, String typeIndicator, String description, boolean required) {
        if (required) {
            this.appendTypeIndicator(buffer, typeIndicator, description, "&lt;", "&gt;");
        } else {
            this.appendTypeIndicator(buffer, typeIndicator, description, "[", "]");
        }
    }

    private void appendTypeIndicator(StringBuilder buffer, String typeIndicator, String description, String start, String end) {
        buffer.append(' ').append(start);
        if (typeIndicator != null) {
            buffer.append(typeIndicator);
        }
        if (!Strings.isNullOrEmpty(description)) {
            if (typeIndicator != null) {
                buffer.append(": ");
            }
            buffer.append(description);
        }
        buffer.append(end);
    }
}

