/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.sqldash;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.timestored.sqldash.AbstractWidget;
import com.timestored.sqldash.Queryable;
import com.timestored.sqldash.Widget;
import com.timestored.sqldash.chart.ChartTheme;
import com.timestored.sqldash.chart.ChartViewConfiguration;
import com.timestored.sqldash.chart.DataTableViewStrategy;
import com.timestored.sqldash.chart.JdbcChartPanel;
import com.timestored.sqldash.chart.ViewStrategy;
import com.timestored.sqldash.chart.ViewStrategyFactory;
import com.timestored.theme.Theme;
import java.awt.event.ActionEvent;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPanel;

public class ChartWidget
extends AbstractWidget {
    private final ChartViewConfiguration chartViewConfig;
    private ChartTheme chartTheme;
    private ViewStrategy viewStrategy;
    private JdbcChartPanel chartPanel = null;
    private ResultSet prevRS = null;
    private boolean renderLargeDataSets = false;
    private Queryable q = new Queryable();
    private final List<Queryable> queryable = new ArrayList<Queryable>(1);
    private ViewStrategy prevNonTabVS;
    private boolean ignoreConfigChanges = false;
    private Widget.Listener updateListener;
    private final Queryable.Listener queryableListener = new Queryable.Listener(){

        @Override
        public void configChanged(Queryable queryable) {
            ChartWidget.this.configChanged();
        }
    };

    public ChartWidget() {
        this.queryable.add(this.q);
        this.chartViewConfig = new ChartViewConfiguration();
        this.viewStrategy = ViewStrategyFactory.getStrategies().get(0);
        this.chartTheme = ViewStrategyFactory.getThemes().get(0);
        this.q.addListener(this.queryableListener);
    }

    public ChartWidget(ChartWidget app) {
        super(app);
        this.q = new Queryable(app.getQ());
        this.queryable.add(this.q);
        this.viewStrategy = app.viewStrategy;
        this.chartTheme = app.chartTheme;
        this.chartViewConfig = null;
        this.q.addListener(this.queryableListener);
    }

    public void setChartTheme(ChartTheme chartTheme) {
        this.chartTheme = chartTheme;
        this.configChanged();
    }

    public ChartTheme getChartTheme() {
        return this.chartTheme;
    }

    public void setViewStrategy(ViewStrategy viewStrategy) {
        if (!this.viewStrategy.equals(DataTableViewStrategy.getInstance())) {
            this.prevNonTabVS = this.viewStrategy;
        }
        this.viewStrategy = viewStrategy;
        this.configChanged();
    }

    public ViewStrategy getViewStrategy() {
        return this.viewStrategy;
    }

    public ChartViewConfiguration getChartViewConfig() {
        return this.chartViewConfig;
    }

    public void setRenderLargeDataSets(boolean renderLargeDataSets) {
        this.renderLargeDataSets = renderLargeDataSets;
        this.configChanged();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("viewStrategy", this.viewStrategy).add("chartTheme", this.chartTheme).add("chartViewConfig", this.chartViewConfig).add("queryable", this.q).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JdbcChartPanel generateChart() {
        ChartWidget chartWidget = this;
        synchronized (chartWidget) {
            this.chartPanel = ViewStrategyFactory.getJdbcChartpanel();
            this.chartPanel.setViewStrategy(this.getViewStrategy());
            this.chartPanel.setTheme(this.getChartTheme());
            this.updateListener = new Widget.Listener(){

                @Override
                public void configChanged(Widget app) {
                    ChartWidget.this.chartPanel.setRenderLargeDataSets(app.isRenderLargeDataSets());
                    ChartWidget.this.chartPanel.setViewStrategy(ChartWidget.this.viewStrategy);
                    ChartWidget.this.chartPanel.setTheme(ChartWidget.this.chartTheme);
                    if (!ChartWidget.this.ignoreConfigChanges) {
                        ChartWidget.this.chartPanel.update(ChartWidget.this.prevRS);
                    }
                }
            };
            this.addListener(this.updateListener);
        }
        return this.chartPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidatePanelCache() {
        if (this.chartPanel != null) {
            ChartWidget chartWidget = this;
            synchronized (chartWidget) {
                if (this.chartPanel != null) {
                    this.removeListener(this.updateListener);
                    this.chartPanel = null;
                    this.updateListener = null;
                }
            }
        }
    }

    @Override
    public void tabChanged(Queryable w, ResultSet rs2) {
        if (this.chartPanel != null && w == this.q && !this.ignoreConfigChanges) {
            this.prevRS = rs2;
            this.chartPanel.update(rs2);
        }
    }

    @Override
    public void queryError(Queryable w, Exception e) {
        if (this.chartPanel != null && w == this.q && !this.ignoreConfigChanges) {
            this.prevRS = null;
            this.chartPanel.update(e);
        }
    }

    public void setIgnoreConfigChanges(boolean ignoreConfigChanges) {
        this.ignoreConfigChanges = ignoreConfigChanges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JPanel getPanel() {
        if (this.chartPanel == null) {
            ChartWidget chartWidget = this;
            synchronized (chartWidget) {
                if (this.chartPanel == null) {
                    this.chartPanel = this.generateChart();
                }
            }
        }
        return this.chartPanel;
    }

    @Override
    public Collection<Queryable> getQueryables() {
        return this.queryable;
    }

    public Queryable getQ() {
        return this.q;
    }

    public void setQueryable(Queryable q) {
        this.q.removeListener(this.queryableListener);
        this.q = q;
        this.queryable.set(0, q);
        this.q.addListener(this.queryableListener);
        this.configChanged();
    }

    public com.timestored.theme.Icon getTSIcon() {
        if (this.viewStrategy != null && this.viewStrategy.getIcon() != null) {
            return this.viewStrategy.getIcon();
        }
        return Theme.CIcon.CHART_CURVE;
    }

    @Override
    public Icon getIcon() {
        return this.getTSIcon().get16();
    }

    @Override
    public Collection<Action> getActions() {
        AbstractAction toggleTabView = new AbstractAction("Toggle Table/Chart View", Theme.CIcon.TABLE_ELEMENT.get16()){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isTab = ChartWidget.this.viewStrategy.equals(DataTableViewStrategy.getInstance());
                if (isTab && ChartWidget.this.prevNonTabVS != null) {
                    ChartWidget.this.setViewStrategy(ChartWidget.this.prevNonTabVS);
                } else {
                    ChartWidget.this.setViewStrategy(DataTableViewStrategy.getInstance());
                }
            }
        };
        return Lists.newArrayList(toggleTabView);
    }

    @Override
    public boolean isRenderLargeDataSets() {
        return this.renderLargeDataSets;
    }
}

