/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.sqldash;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.timestored.TimeStored;
import com.timestored.misc.HtmlUtils;
import com.timestored.qstudio.UpdateHelper;
import com.timestored.sqldash.ChartWidget;
import com.timestored.sqldash.Widget;
import com.timestored.sqldash.chart.ChartTheme;
import com.timestored.sqldash.chart.ViewStrategy;
import com.timestored.sqldash.chart.ViewStrategyFactory;
import com.timestored.theme.Theme;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import org.jdesktop.swingx.combobox.MapComboBoxModel;

public class ChartControlPanel
extends JPanel
implements Widget.Listener {
    private static final long serialVersionUID = 1L;
    private static final TimeStored.Page helpPage = TimeStored.Page.SQLDASH_HELP_EG;
    private static final String DEFAULT_TOOLTIP = "<html><div width='350px'><b>Charts</b><br><a href='" + helpPage.url() + "'>" + helpPage.niceUrl() + "</a></div></html>";
    private final JComboBox chartComboBox;
    private final MapComboBoxModel<String, ViewStrategy> chartStratComboBoxModel;
    private final MapComboBoxModel<String, ChartTheme> chartThemeComboBoxModel;
    private final ChartWidget app;
    private JComboBox chartThemeComboBox;
    private JCheckBox veryLargeChartsCheckBox;

    public ChartControlPanel(ChartWidget app) {
        this.app = app;
        List<ViewStrategy> chartStrats = ViewStrategyFactory.getStrategies();
        LinkedHashMap<String, ViewStrategy> descToChartStrat = Maps.newLinkedHashMap();
        for (ViewStrategy cs2 : chartStrats) {
            descToChartStrat.put(cs2.getDescription(), cs2);
        }
        this.chartStratComboBoxModel = new MapComboBoxModel(descToChartStrat);
        List<ChartTheme> chartThemes = ViewStrategyFactory.getThemes();
        LinkedHashMap<String, ChartTheme> descToChartTheme = Maps.newLinkedHashMap();
        for (ChartTheme ct : chartThemes) {
            descToChartTheme.put(ct.getTitle(), ct);
        }
        this.chartThemeComboBoxModel = new MapComboBoxModel(descToChartTheme);
        this.setBorder(BorderFactory.createTitledBorder("Control Panel"));
        this.setLayout(new BoxLayout(this, 1));
        Theme.InputLabeller IL = Theme.getInputLabeller();
        this.chartComboBox = new JComboBox(this.chartStratComboBoxModel);
        this.chartComboBox.setRenderer(new IconListRenderer(this.chartStratComboBoxModel, hoveredIndex -> {
            ViewStrategy vs;
            if (hoveredIndex >= 0 && hoveredIndex < descToChartStrat.size() && (vs = this.chartStratComboBoxModel.getValue((int)hoveredIndex)) != null && !app.getViewStrategy().equals(vs)) {
                app.setViewStrategy(vs);
            }
        }));
        this.chartThemeComboBox = new JComboBox(this.chartThemeComboBoxModel);
        this.veryLargeChartsCheckBox = new JCheckBox("Render Very Large Charts");
        if (app != null) {
            this.chartComboBox.setSelectedItem(app.getViewStrategy().getDescription());
            this.chartComboBox.addActionListener(as -> {
                int i = this.chartComboBox.getSelectedIndex();
                ViewStrategy vs = this.chartStratComboBoxModel.getValue(i);
                if (vs != null) {
                    UpdateHelper.registerEvent("cha_select" + vs.getPulseName());
                }
                if (!app.getViewStrategy().equals(vs)) {
                    app.setViewStrategy(vs);
                }
            });
            this.chartThemeComboBox.addActionListener(ae -> {
                int i = this.chartThemeComboBox.getSelectedIndex();
                ChartTheme th = this.chartThemeComboBoxModel.getValue(i);
                if (!app.getChartTheme().equals(th)) {
                    app.setChartTheme(th);
                }
            });
            this.veryLargeChartsCheckBox.addActionListener(ae -> app.setRenderLargeDataSets(this.veryLargeChartsCheckBox.isSelected()));
        } else {
            this.chartComboBox.setEnabled(false);
            this.chartThemeComboBox.setEnabled(false);
            this.veryLargeChartsCheckBox.setEnabled(false);
        }
        JLabel largeLabel = new JLabel(Theme.CIcon.INFO.get());
        largeLabel.setToolTipText("<html>If the data has many rows or columns it won't automatically render to prevent slowness.<br />Check this box to try and render all data of any size.</html>");
        this.add(IL.get("Type:", (Component)this.chartComboBox, "chartComboBox", new CurrentViewInfoLinkLabel()));
        this.add(IL.get("Theme:", this.chartThemeComboBox, "chartThemeComboBox"));
        this.add(IL.get("", this.veryLargeChartsCheckBox, "veryLargeChartsCheckBox"));
        if (app != null) {
            app.addListener(this);
        }
        this.refreshGui();
    }

    private void refreshGui() {
        boolean enabled = this.app != null;
        this.chartComboBox.setEnabled(enabled);
        this.chartThemeComboBox.setEnabled(enabled);
        if (enabled) {
            if (!this.chartComboBox.isFocusOwner()) {
                ViewStrategy vs = this.app.getViewStrategy();
                this.chartComboBox.setSelectedItem(vs.getDescription());
            }
            if (!this.chartThemeComboBox.isFocusOwner()) {
                ChartTheme ct = this.app.getChartTheme();
                this.chartThemeComboBox.setSelectedItem(ct.getTitle());
            }
        }
    }

    @Override
    public void configChanged(Widget app) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ChartControlPanel.this.refreshGui();
            }
        });
    }

    class IconListRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;
        private final MapComboBoxModel<String, ViewStrategy> chartStratComboBoxModel;
        private final Consumer<Integer> callback;

        public IconListRenderer(MapComboBoxModel<String, ViewStrategy> chartStratComboBoxModel, Consumer<Integer> callback) {
            this.chartStratComboBoxModel = chartStratComboBoxModel;
            this.callback = Preconditions.checkNotNull(callback);
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ViewStrategy vs;
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof String && (vs = this.chartStratComboBoxModel.getValue(value)) != null && vs.getIcon() != null) {
                label.setIcon(vs.getIcon().get16());
            }
            if (isSelected) {
                this.callback.accept(index);
            }
            return label;
        }
    }

    public class CurrentViewInfoLinkLabel
    extends JLabel {
        private static final long serialVersionUID = 1L;

        public CurrentViewInfoLinkLabel() {
            super(Theme.CIcon.INFO.get());
            ToolTipManager.sharedInstance().registerComponent(this);
            if (HtmlUtils.isBrowseSupported()) {
                this.setCursor(Cursor.getPredefinedCursor(12));
                this.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        HtmlUtils.browse(helpPage.url());
                    }
                });
            }
        }

        @Override
        public String getToolTipText() {
            String tooltip = DEFAULT_TOOLTIP;
            if (ChartControlPanel.this.app != null) {
                ViewStrategy vs = ChartControlPanel.this.app.getViewStrategy();
                tooltip = "<html><div width='350px'><b>" + vs.getDescription() + "</b><br>" + vs.getFormatExplainationHtml() + "<br><a href='" + helpPage.url() + "'>" + helpPage.niceUrl() + "</a></div></html>";
            }
            return tooltip;
        }
    }
}

