/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.sqldash;

import com.timestored.sqldash.Queryable;
import com.timestored.sqldash.Widget;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import javax.swing.Action;

abstract class AbstractWidget
implements Widget {
    private static final Logger LOG = Logger.getLogger(AbstractWidget.class.getName());
    private static int count = 0;
    private final transient List<Widget.Listener> listeners = new CopyOnWriteArrayList<Widget.Listener>();
    protected String title = "untitled";
    private final int id;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractWidget(int id) {
        AbstractWidget abstractWidget = this;
        synchronized (abstractWidget) {
            this.id = id;
            count = id + 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractWidget(String title) {
        AbstractWidget abstractWidget = this;
        synchronized (abstractWidget) {
            this.id = count++;
        }
        this.title = title;
    }

    public AbstractWidget() {
        this("");
    }

    public AbstractWidget(AbstractWidget app) {
        this(app.getTitle());
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
        this.configChanged();
    }

    protected void configChanged() {
        LOG.info("Widget " + this.getId() + " configChanged");
        for (Widget.Listener l : this.listeners) {
            l.configChanged(this);
        }
    }

    @Override
    public void addListener(Widget.Listener widgetListener) {
        this.listeners.add(widgetListener);
    }

    @Override
    public boolean removeListener(Widget.Listener widgetListener) {
        return this.listeners.remove(widgetListener);
    }

    @Override
    public int getId() {
        return this.id;
    }

    public AbstractWidget setServerName(String serverName) {
        for (Queryable q : this.getQueryables()) {
            q.setServerName(serverName);
        }
        return this;
    }

    public String toString() {
        return "Widget [title=" + this.title + ", id=" + this.id + "]";
    }

    @Override
    public Collection<Action> getActions() {
        return Collections.emptyList();
    }
}

