/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qstudio.servertree;

import com.timestored.qstudio.model.AdminModel;
import com.timestored.qstudio.servertree.ServerListPanel;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

class ServerMovingTreeTransferHandler
extends TransferHandler {
    private static final Logger LOG = Logger.getLogger(ServerMovingTreeTransferHandler.class.getName());
    private static final long serialVersionUID = 1L;
    private DataFlavor[] flavors = new DataFlavor[1];
    private final AdminModel adminModel;

    public ServerMovingTreeTransferHandler(AdminModel adminModel) {
        this.adminModel = adminModel;
        try {
            String mimeType = "application/x-java-jvm-local-objectref;class=\"" + ServerListPanel.ServerObjectTreeNode.class.getName() + "\"";
            this.flavors[0] = new DataFlavor(mimeType);
        }
        catch (ClassNotFoundException e) {
            LOG.warning("ClassNotFound: " + e.getMessage());
        }
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        if (!support.isDrop() || !support.isDataFlavorSupported(this.flavors[0])) {
            return false;
        }
        support.setShowDropLocation(true);
        JTree.DropLocation dl = (JTree.DropLocation)support.getDropLocation();
        TreePath dest = dl.getPath();
        DefaultMutableTreeNode target = (DefaultMutableTreeNode)dest.getLastPathComponent();
        return target.getUserObject() instanceof ServerListPanel.FolderNode;
    }

    @Override
    protected Transferable createTransferable(JComponent c2) {
        DefaultMutableTreeNode node;
        Object o;
        TreePath[] paths = ((JTree)c2).getSelectionPaths();
        if (paths != null && (o = (node = (DefaultMutableTreeNode)paths[0].getLastPathComponent()).getUserObject()) instanceof ServerListPanel.ServerObjectTreeNode) {
            return new NodesTransferable((ServerListPanel.ServerObjectTreeNode)o);
        }
        return null;
    }

    @Override
    public int getSourceActions(JComponent c2) {
        return 2;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (!this.canImport(support)) {
            return false;
        }
        ServerListPanel.ServerObjectTreeNode serverNode = null;
        try {
            Transferable t = support.getTransferable();
            serverNode = (ServerListPanel.ServerObjectTreeNode)t.getTransferData(this.flavors[0]);
        }
        catch (UnsupportedFlavorException ufe) {
            LOG.warning("UnsupportedFlavor: " + ufe.getMessage());
        }
        catch (IOException ioe) {
            LOG.warning("I/O error: " + ioe.getMessage());
        }
        JTree.DropLocation dl = (JTree.DropLocation)support.getDropLocation();
        TreePath dest = dl.getPath();
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)dest.getLastPathComponent();
        Object o = parent.getUserObject();
        if (o instanceof ServerListPanel.FolderNode) {
            ServerListPanel.FolderNode f = (ServerListPanel.FolderNode)o;
            this.adminModel.moveServer(serverNode.getServerModel(), f.getFolder());
        }
        return true;
    }

    public String toString() {
        return this.getClass().getName();
    }

    private class NodesTransferable
    implements Transferable {
        private ServerListPanel.ServerObjectTreeNode nodes;

        private NodesTransferable(ServerListPanel.ServerObjectTreeNode node) {
            this.nodes = node;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.nodes;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return ServerMovingTreeTransferHandler.this.flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return ServerMovingTreeTransferHandler.this.flavors[0].equals(flavor);
        }
    }
}

