/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qstudio.servertree;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.timestored.connections.JdbcIcons;
import com.timestored.connections.JdbcTypes;
import com.timestored.connections.ServerConfig;
import com.timestored.kdb.KdbConnection;
import com.timestored.messages.Msg;
import com.timestored.qstudio.BackgroundExecutor;
import com.timestored.qstudio.CommonActions;
import com.timestored.qstudio.QStudioModel;
import com.timestored.qstudio.model.AdminModel;
import com.timestored.qstudio.model.QEntity;
import com.timestored.qstudio.model.ServerModel;
import com.timestored.qstudio.model.ServerObjectTree;
import com.timestored.qstudio.servertree.CustomNode;
import com.timestored.qstudio.servertree.SelectedServerObjectPanel;
import com.timestored.qstudio.servertree.ServerMovingTreeTransferHandler;
import com.timestored.swingxx.JTreeHelper;
import com.timestored.swingxx.SwingUtils;
import com.timestored.theme.Theme;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.DropMode;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class ServerListPanel
extends JPanel
implements AdminModel.Listener {
    private static final Logger LOG = Logger.getLogger(ServerListPanel.class.getName());
    private static final long serialVersionUID = 1L;
    private File savedDocFile;
    private final AdminModel adminModel;
    private JTree tree;
    private final Set<String> myFolders = Sets.newHashSet();
    private static final String ROOT_TITLE = Msg.get(Msg.Key.SERVERS);
    private final CommonActions commonActions;
    private final Map<String, DefaultMutableTreeNode> nameToNode = Maps.newHashMap();
    private final JFrame parentFrame;
    private static ReportGenerator reportGenerator = null;

    public ServerListPanel(AdminModel adminModel, CommonActions commonActions, JFrame parentFrame) {
        this.commonActions = commonActions;
        this.adminModel = adminModel;
        this.parentFrame = parentFrame;
        adminModel.addListener(this);
        this.setLayout(new BorderLayout(4, 4));
        for (String f : adminModel.getFolders()) {
            this.myFolders.add(f + "/");
        }
        this.setPreferredSize(new Dimension(400, 400));
    }

    private void refreshGui() {
        LOG.info("refreshGui");
        List<ServerModel> serverModels = this.adminModel.getServerModels();
        JComponent c2 = new JPanel();
        if (serverModels.size() > 0) {
            this.tree = this.generateTree();
            c2 = new JScrollPane(this.tree);
            this.highlightRow(this.adminModel.getServerModel());
            CustomNode.configure(this.tree);
        } else {
            c2 = this.generateAddButton();
        }
        this.removeAll();
        this.add((Component)c2, "Center");
        this.revalidate();
    }

    private JTree generateTree() {
        DefaultMutableTreeNode top = new DefaultMutableTreeNode(new RootFolderNode());
        Set<Object> curExpandedFolders = Collections.emptySet();
        if (this.tree != null) {
            curExpandedFolders = JTreeHelper.getExpandedFolders(this.tree);
        }
        for (String string : this.adminModel.getFolders()) {
            this.myFolders.add(string + "/");
        }
        this.nameToNode.clear();
        this.nameToNode.put("", top);
        TreeSet<String> allFolders = Sets.newTreeSet(this.myFolders);
        for (String fullPath : allFolders) {
            if (fullPath.equals("")) continue;
            String parentPath = "";
            String curPath = "";
            for (String fld : ServerConfig.extractParts(fullPath)) {
                curPath = curPath + fld + "/";
                DefaultMutableTreeNode pn = this.nameToNode.get(parentPath);
                if (!this.nameToNode.containsKey(curPath)) {
                    DefaultMutableTreeNode n = new DefaultMutableTreeNode(new SubFolderNode(fld, curPath));
                    pn.add(n);
                    this.nameToNode.put(curPath, n);
                }
                parentPath = curPath;
            }
        }
        for (ServerModel sm : this.adminModel.getServerModels()) {
            String f = sm.getServerConfig().getFolder();
            f = f.equals("") ? "" : f + "/";
            DefaultMutableTreeNode n = new DefaultMutableTreeNode(new ServerObjectTreeNode(sm));
            DefaultMutableTreeNode fNode = this.nameToNode.get(f);
            if (fNode != null) {
                fNode.add(n);
                continue;
            }
            LOG.warning("No node for " + f);
        }
        JTree jTree = new JTree(top);
        JTreeHelper.expandAll(jTree, true);
        if (!curExpandedFolders.isEmpty()) {
            JTreeHelper.setFolderExpansions(jTree, curExpandedFolders);
        }
        jTree.setDragEnabled(true);
        jTree.setDropMode(DropMode.ON_OR_INSERT);
        jTree.setTransferHandler(new ServerMovingTreeTransferHandler(this.adminModel));
        jTree.setBorder(Theme.CENTRE_BORDER);
        return jTree;
    }

    private JPanel generateAddButton() {
        JPanel panel = Theme.getVerticalBoxPanel();
        panel.add(Theme.getSubHeader(Msg.get(Msg.Key.ADD_SERVER)));
        JPanel p = new JPanel();
        JButton button = new JButton(this.commonActions.getAddServerAction());
        p.add(button);
        button.setBackground(Theme.HIGHLIGHT_BUTTON_COLOR);
        button.setForeground(Color.WHITE);
        button.setOpaque(true);
        panel.add(p);
        return panel;
    }

    @Override
    public void modelChanged() {
        this.refreshGui();
    }

    @Override
    public void modelChanged(ServerModel sm) {
        this.refreshGui();
    }

    @Override
    public void selectionChanged(ServerModel serverModel, AdminModel.Category category, String namespace, QEntity element) {
        this.highlightRow(serverModel);
    }

    private void highlightRow(ServerModel serverModel) {
        block5: {
            try {
                if (serverModel != null) {
                    String selName = serverModel.getName();
                    for (int row = this.tree.getRowCount(); row >= 0; --row) {
                        ServerObjectTreeNode sot = ServerListPanel.getServerObjectTN(this.tree.getPathForRow(row));
                        if (sot == null || !sot.getServerModel().getName().equals(selName)) continue;
                        this.tree.setSelectionInterval(row, row + 1);
                        break block5;
                    }
                    break block5;
                }
                if (!this.tree.isSelectionEmpty()) {
                    this.tree.clearSelection();
                }
            }
            catch (RuntimeException e) {
                LOG.warning("Error calling highlightRow for tree");
            }
        }
    }

    private static ServerObjectTreeNode getServerObjectTN(TreePath path) {
        ServerObjectTreeNode sot = null;
        if (path != null) {
            Object o;
            DefaultMutableTreeNode mtn = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object object = o = mtn != null ? mtn.getUserObject() : null;
            if (o != null && o instanceof ServerObjectTreeNode) {
                sot = (ServerObjectTreeNode)o;
            }
        }
        return sot;
    }

    private void removeMyFolders(String folderName) {
        Iterator<String> it = this.myFolders.iterator();
        while (it.hasNext()) {
            if (!it.next().startsWith(folderName)) continue;
            it.remove();
        }
    }

    private void renameMyFolder(String from, String to) {
        ArrayList<String> newF = new ArrayList<String>();
        Iterator<String> it = this.myFolders.iterator();
        while (it.hasNext()) {
            String f = it.next();
            if (!f.startsWith(from)) continue;
            newF.add(to + f.substring(from.length()));
            it.remove();
        }
        this.myFolders.addAll(newF);
    }

    public static void setReportGenerator(ReportGenerator reportGenerator) {
        ServerListPanel.reportGenerator = reportGenerator;
    }

    public static interface ReportGenerator {
        public void generate(KdbConnection var1, File var2) throws Exception;
    }

    class ServerObjectTreeNode
    extends CustomNode {
        private final ServerModel serverModel;

        private ServerObjectTreeNode(ServerModel serverModel) {
            super(serverModel.getServerConfig().getShortName());
            this.serverModel = serverModel;
        }

        @Override
        public String getTooltip() {
            String msg = "<html>" + this.serverModel.getName() + " " + (this.serverModel.isConnected() ? "Connected" : "Disconnected");
            ServerConfig sc = this.serverModel.getServerConfig();
            if (sc.getPort() != 0) {
                msg = msg + "<br />Host: <b>" + sc.getHost() + ":" + sc.getPort() + "</b>";
            }
            if (sc.getDatabase().length() > 0) {
                msg = msg + "<br />DB: <b>" + sc.getDatabase() + "</b>";
            }
            if (!sc.isKDB()) {
                msg = msg + "<br />Type: <b>" + (Object)((Object)sc.getJdbcType()) + "</b>";
            }
            if (this.isTreeProblem()) {
                ServerObjectTree soTree = this.serverModel.getServerObjectTree();
                String s = soTree == null ? "" : soTree.getErrMsg();
                msg = msg + "<br />Error retrieving tree: " + s;
            }
            return msg + "</html>";
        }

        private boolean isTreeProblem() {
            ServerObjectTree soTree = this.serverModel.getServerObjectTree();
            return soTree == null || soTree.isErrorRetrievingTree();
        }

        @Override
        public ImageIcon getIcon() {
            JdbcTypes jdbcType = this.serverModel.getServerConfig().getJdbcType();
            if (JdbcTypes.DUCKDB.equals((Object)jdbcType) || JdbcTypes.BABELDB.equals((Object)jdbcType)) {
                return this.serverModel.isConnected() ? Theme.CIcon.DUCK.get() : Theme.CIcon.DUCK_FADED.get();
            }
            if (this.serverModel.isConnected() && this.isTreeProblem()) {
                return Theme.CIcon.SERVER_LIGHTNING.get();
            }
            if (this.serverModel.getServerConfig().isKDB() && this.serverModel.isConnected()) {
                return Theme.CIcon.SERVER.get();
            }
            if (!this.serverModel.getServerConfig().isKDB() && this.serverModel.isConnected()) {
                JdbcIcons jicon = JdbcIcons.getIconFor(jdbcType);
                return jicon.get16();
            }
            return Theme.CIcon.SERVER_CONNECT.get();
        }

        @Override
        public void doSelectionAction() {
            if (ServerListPanel.this.adminModel.getServerModel() != this.serverModel) {
                if (!this.serverModel.isConnected()) {
                    ServerListPanel.this.adminModel.refresh(this.serverModel.getServerConfig());
                }
                ServerListPanel.this.adminModel.setSelectedServerName(this.serverModel.getName());
            }
        }

        @Override
        public void addMenuItems(JPopupMenu menu) {
            final ServerConfig sc = this.serverModel.getServerConfig();
            if (sc.getJdbcType().equals((Object)JdbcTypes.BABELDB)) {
                JMenuItem openFolderMI = new JMenuItem("Open Folder");
                openFolderMI.setIcon(Theme.CIcon.FOLDER.get());
                openFolderMI.setName("ssOpenFolder");
                openFolderMI.addActionListener(e -> {
                    try {
                        Desktop.getDesktop().open(QStudioModel.getLOCALDB_DIR());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                });
                menu.add(openFolderMI);
            }
            JMenuItem propertiesMI = new JMenuItem("Properties");
            propertiesMI.setEnabled(sc.isKDB());
            propertiesMI.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String title = sc.getName() + " Properties";
                    ServerListPanel.this.adminModel.refresh(sc);
                    ServerModel sm = ServerListPanel.this.adminModel.getServerModel(sc.getName());
                    JPanel contentPanel = SelectedServerObjectPanel.getServerDescriptionPanel(ServerListPanel.this.adminModel.getServerModel());
                    SwingUtils.showAppDialog(SwingUtilities.getWindowAncestor(ServerListPanel.this), title, contentPanel, Theme.CIcon.SERVER.get().getImage());
                }
            });
            JMenuItem refreshMenuItem = new JMenuItem("Refresh " + this.serverModel.getName());
            refreshMenuItem.setIcon(Theme.CIcon.ARROW_REFRESH.get());
            refreshMenuItem.setName("ssRefreshAll");
            refreshMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BackgroundExecutor.EXECUTOR.execute(new Runnable(){

                        @Override
                        public void run() {
                            ServerListPanel.this.adminModel.refresh(ServerObjectTreeNode.this.serverModel.getServerConfig());
                        }
                    });
                }
            });
            menu.add(refreshMenuItem);
            menu.add(ServerListPanel.this.commonActions.getCloseConnServerAction(sc));
            if (reportGenerator != null) {
                JMenuItem generateTableDocs = new JMenuItem("Generate Table Docs " + this.serverModel.getName());
                generateTableDocs.setEnabled(sc.isKDB());
                generateTableDocs.setName("ssgenerateTableDocs");
                generateTableDocs.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        File myDocs = new JFileChooser().getFileSystemView().getDefaultDirectory();
                        if (ServerListPanel.this.savedDocFile == null) {
                            ServerListPanel.this.savedDocFile = new File(myDocs, "table-docs.html");
                        }
                        ServerListPanel.this.savedDocFile = SwingUtils.askUserSaveLocation(ServerListPanel.this.savedDocFile, "html");
                        if (ServerListPanel.this.savedDocFile != null) {
                            try {
                                KdbConnection kdbConn = ServerObjectTreeNode.this.serverModel.getConnection();
                                if (kdbConn == null) {
                                    throw new IOException("Could not connect to server: " + ServerObjectTreeNode.this.serverModel.getName());
                                }
                                reportGenerator.generate(kdbConn, ServerListPanel.this.savedDocFile);
                                SwingUtils.offerToOpenFile(Msg.get(Msg.Key.DOCS_GENERATED), ServerListPanel.this.savedDocFile, Msg.get(Msg.Key.OPEN_DOCS_NOW), Msg.get(Msg.Key.CLOSE));
                            }
                            catch (Exception ioe) {
                                String msg = Msg.get(Msg.Key.ERROR_SAVING) + ": " + ServerListPanel.this.savedDocFile + "\r\n" + ioe.toString();
                                LOG.warning(msg);
                                JOptionPane.showMessageDialog(null, msg, Msg.get(Msg.Key.ERROR_SAVING), 0);
                            }
                        } else {
                            LOG.info(Msg.get(Msg.Key.SAVE_CANCELLED));
                        }
                    }
                });
                menu.add(generateTableDocs);
            }
            menu.add(ServerListPanel.this.commonActions.getEditServerAction(sc));
            menu.add(ServerListPanel.this.commonActions.getCloneServerAction(sc));
            menu.add(ServerListPanel.this.commonActions.getRemoveServerAction(sc));
            menu.addSeparator();
            menu.add(propertiesMI);
        }

        public ServerModel getServerModel() {
            return this.serverModel;
        }
    }

    public abstract class FolderNode
    extends CustomNode
    implements JTreeHelper.IdentifiableNode {
        private final String folder;

        private FolderNode(String title, String folder) {
            super(title, null, Theme.CIcon.FOLDER.get());
            this.folder = Preconditions.checkNotNull(folder);
        }

        @Override
        public abstract void addMenuItems(JPopupMenu var1);

        public String getFolder() {
            return this.folder;
        }

        @Override
        public String getId() {
            return this.folder;
        }
    }

    private class RootFolderNode
    extends FolderNode {
        public RootFolderNode() {
            super(ROOT_TITLE, "");
        }

        @Override
        public void addMenuItems(JPopupMenu menu) {
            menu.add(new AddFolderMenuItem(""));
            menu.addSeparator();
            for (Action a : ServerListPanel.this.commonActions.getServerActions()) {
                menu.add(new JMenuItem(a));
            }
        }

        @Override
        public String getId() {
            return ROOT_TITLE;
        }
    }

    private class AddFolderMenuItem
    extends JMenuItem {
        public AddFolderMenuItem(final String parentFolder) {
            super("New Folder...", Theme.CIcon.FOLDER_ADD.get());
            this.setName("miAddFolder");
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String f = JOptionPane.showInputDialog("Enter new folders name:");
                    if (f != null && f.length() > 0) {
                        ServerListPanel.this.myFolders.add(parentFolder + f + "/");
                        ServerListPanel.this.refreshGui();
                    }
                }
            });
        }
    }

    private class SubFolderNode
    extends FolderNode {
        private SubFolderNode(String title, String folder) {
            super(title, folder);
        }

        @Override
        public void addMenuItems(JPopupMenu menu) {
            JMenuItem deleteMI = new JMenuItem("Delete Folder", Theme.CIcon.FOLDER_DELETE.get());
            deleteMI.setName("miDeleteFolder");
            deleteMI.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String message = "Are you sure you want to delete this folder and all it's connections?";
                    int opt = JOptionPane.showConfirmDialog(ServerListPanel.this.parentFrame, message, "Confirm Delete", 2);
                    if (opt == 0) {
                        ServerListPanel.this.removeMyFolders(SubFolderNode.this.getFolder());
                        int removed = ServerListPanel.this.adminModel.removeFolder(SubFolderNode.this.getFolder());
                        if (removed == 0) {
                            ServerListPanel.this.refreshGui();
                        }
                    }
                }
            });
            JMenuItem renameFolderMI = new JMenuItem("Rename Folder");
            renameFolderMI.setName("renameFolderMI");
            renameFolderMI.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String newName = JOptionPane.showInputDialog(ServerListPanel.this.parentFrame, (Object)"Enter new Folder name:");
                    if (newName != null) {
                        if (!SubFolderNode.this.getFolder().equals("")) {
                            List<String> l = ServerConfig.extractParts(SubFolderNode.this.getFolder());
                            String pf = Joiner.on("/").join(l.subList(0, l.size() - 1));
                            newName = (pf.length() > 0 ? pf + "/" : "") + newName;
                        }
                        ServerListPanel.this.renameMyFolder(SubFolderNode.this.getFolder(), newName + "/");
                        int numRenamed = ServerListPanel.this.adminModel.renameFolder(SubFolderNode.this.getFolder(), newName);
                        if (numRenamed == 0) {
                            ServerListPanel.this.refreshGui();
                        }
                    }
                }
            });
            JMenuItem addServerMI = new JMenuItem(ServerListPanel.this.commonActions.getAddServerAction(this.getFolder()));
            addServerMI.setName("addServerMI");
            menu.add(addServerMI);
            menu.add(new AddFolderMenuItem(this.getFolder()));
            menu.add(renameFolderMI);
            menu.add(deleteMI);
        }
    }
}

