/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qstudio.servertree;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.timestored.connections.JdbcTypes;
import com.timestored.qstudio.model.AdminModel;
import com.timestored.qstudio.model.QEntity;
import com.timestored.qstudio.model.QueryManager;
import com.timestored.qstudio.model.ServerModel;
import com.timestored.qstudio.servertree.ElementDisplayFactory;
import com.timestored.sqldash.chart.ChartTheme;
import com.timestored.theme.Theme;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class SelectedServerObjectPanel
extends JPanel
implements AdminModel.Listener {
    private static final long serialVersionUID = 1L;
    private final AdminModel adminModel;
    private final QueryManager queryManager;
    private ChartTheme chartTheme;
    private static Map<JdbcTypes, Function<ServerModel, JPanel>> jdbcTypeToDescriptionPanel = new HashMap<JdbcTypes, Function<ServerModel, JPanel>>();

    public static void registerServerDescriptionPanelSupplier(JdbcTypes jdbcType, Function<ServerModel, JPanel> provider) {
        Preconditions.checkNotNull(jdbcType);
        jdbcTypeToDescriptionPanel.put(jdbcType, provider);
    }

    public static JPanel getServerDescriptionPanel(ServerModel serverModel) {
        Function<ServerModel, JPanel> panelSupplier;
        if (serverModel != null && (panelSupplier = jdbcTypeToDescriptionPanel.get((Object)serverModel.getServerConfig().getJdbcType())) != null) {
            return panelSupplier.apply(serverModel);
        }
        return new JPanel(new BorderLayout());
    }

    public SelectedServerObjectPanel(AdminModel adminModel, QueryManager queryManager) {
        this.adminModel = adminModel;
        this.queryManager = queryManager;
        this.setLayout(new BorderLayout());
        adminModel.addListener(this);
        this.refreshGUI(false);
    }

    private void refreshGUI(boolean forceModelUpdate) {
        Component p = new JLabel("nothing to see here");
        AdminModel.Category cat = this.adminModel.getSelectedCategory();
        String title = this.adminModel.getSelectedServerName();
        if (this.adminModel.getSelectedServerName() != null) {
            if (cat.equals((Object)AdminModel.Category.ELEMENT)) {
                p = ElementDisplayFactory.getPanel(this.adminModel, this.queryManager, this.chartTheme);
                title = this.adminModel.getSelectedElement().getName();
            } else if (cat.equals((Object)AdminModel.Category.NAMESPACE)) {
                p = SelectedServerObjectPanel.getNamespaceListing(this.adminModel);
                title = this.adminModel.getSelectedNamespace();
            } else {
                p = SelectedServerObjectPanel.getServerDescriptionPanel(this.adminModel.getServerModel());
            }
        }
        if (p == null) {
            JPanel panel = new JPanel();
            panel.add(new JLabel("Problem querying server. is it connected?"));
            p = panel;
        }
        final JPanel wrapPanel = new JPanel(new BorderLayout());
        wrapPanel.setBorder(Theme.CENTRE_BORDER);
        wrapPanel.add((Component)Theme.getHeader(title), "North");
        wrapPanel.add(p, "Center");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SelectedServerObjectPanel.this.removeAll();
                SelectedServerObjectPanel.this.add((Component)wrapPanel, "Center");
                SelectedServerObjectPanel.this.revalidate();
            }
        });
    }

    private static Component getNamespaceListing(AdminModel adminModel) {
        return new JLabel(adminModel.getSelectedNamespace());
    }

    @Override
    public void modelChanged() {
    }

    @Override
    public void selectionChanged(ServerModel serverModel, AdminModel.Category category, String namespace, QEntity element) {
        this.refreshGUI(true);
    }

    @Override
    public void modelChanged(ServerModel sm) {
        this.refreshGUI(false);
    }

    public void setChartTheme(ChartTheme chartTheme) {
        this.chartTheme = Preconditions.checkNotNull(chartTheme);
        this.refreshGUI(false);
    }
}

