/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qstudio.servertree;

import com.google.common.base.Preconditions;
import com.timestored.kdb.KdbConnection;
import com.timestored.qstudio.QStudioLauncher;
import com.timestored.qstudio.kdb.KdbHelper;
import com.timestored.qstudio.model.AdminModel;
import com.timestored.theme.Theme;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import kx.c;

public class PagingTablePanel
extends JPanel {
    private static final Logger LOG = Logger.getLogger(PagingTablePanel.class.getName());
    private static final long serialVersionUID = 1L;
    private static final String SUBBLIST_Q = "{$[.Q.qp[y]; $[count y; .Q.ind[y;`long$x[0] + til min (count y),x[1]]; select from y]; sublist[`int$x;y]]}";
    private static long ROWS_SHOWN = 10000L;
    private long offset = 0L;
    private long count;
    private final String queryName;
    private final JButton firstButton;
    private final JButton prevButton;
    private final JButton nextButton;
    private JButton lastButton;
    private Component scrollPane;
    private final JLabel positionLabel;
    private final AdminModel adminModel;

    PagingTablePanel(AdminModel adminModel, String queryName) throws IOException, c.KException {
        this.queryName = Preconditions.checkNotNull(queryName);
        this.adminModel = Preconditions.checkNotNull(adminModel);
        this.firstButton = new JButton("<<");
        this.firstButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PagingTablePanel.this.refreshToShow(0L);
            }
        });
        this.prevButton = new JButton("<");
        this.prevButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PagingTablePanel.this.refreshToShow(PagingTablePanel.this.offset - ROWS_SHOWN);
            }
        });
        this.nextButton = new JButton(">");
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PagingTablePanel.this.refreshToShow(PagingTablePanel.this.offset + ROWS_SHOWN);
            }
        });
        this.lastButton = new JButton(">>");
        this.lastButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PagingTablePanel.this.refreshToShow(PagingTablePanel.this.count - ROWS_SHOWN);
            }
        });
        this.positionLabel = new JLabel();
        new JLabel("Rows Shown");
        this.lastButton = new JButton(">>");
        this.lastButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PagingTablePanel.this.refreshToShow(PagingTablePanel.this.count - ROWS_SHOWN);
            }
        });
        JPanel toolbar = new JPanel();
        toolbar.add(this.firstButton);
        toolbar.add(this.prevButton);
        toolbar.add(this.nextButton);
        toolbar.add(this.lastButton);
        toolbar.add(this.positionLabel);
        this.scrollPane = new JScrollPane(20, 31);
        this.setLayout(new BorderLayout());
        this.add((Component)toolbar, "North");
        this.add(this.scrollPane, "Center");
        this.refreshToShow(this.offset);
    }

    public static void setMaximumRowsShown(long maxRows) {
        ROWS_SHOWN = maxRows;
    }

    public static String getTableQuery(String tableName, long offset, long rowsShown) {
        String query = "(count " + tableName + ";" + SUBBLIST_Q + "[" + offset + " " + rowsShown + "j;" + tableName + "])";
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshToShow(long offset) {
        KdbConnection kdbConnection = null;
        this.remove(this.scrollPane);
        Component sp = new JPanel();
        Exception e = null;
        this.offset = offset;
        String query = PagingTablePanel.getTableQuery(this.queryName, offset, ROWS_SHOWN);
        kdbConnection = this.adminModel.getKdbConnection();
        boolean prevPossible = false;
        boolean nextPossible = false;
        String posText = "";
        try {
            if (kdbConnection != null) {
                Object[] resArray = (Object[])kdbConnection.query(query);
                this.count = ((Number)resArray[0]).longValue();
                prevPossible = offset > 0L;
                nextPossible = offset + ROWS_SHOWN < this.count;
                long np = offset + ROWS_SHOWN;
                posText = offset + "-" + (np > this.count ? this.count : np) + " of " + this.count;
                sp = KdbHelper.getJXTable(resArray[1]);
            } else {
                String txt = "Could not establish a connection to server: " + this.adminModel.getSelectedServerName();
                sp = Theme.getErrorBox("No Connection", Theme.getTextArea("errTxt", txt));
            }
        }
        catch (c.KException ke) {
            e = ke;
        }
        catch (IOException ioe) {
            e = ioe;
        }
        catch (Exception ex) {
            e = ex;
        }
        finally {
            if (kdbConnection != null) {
                try {
                    kdbConnection.close();
                }
                catch (IOException ioe) {
                    LOG.log(Level.WARNING, "Problem closing KDB connection", e);
                }
            }
        }
        this.firstButton.setEnabled(prevPossible);
        this.prevButton.setEnabled(prevPossible);
        this.nextButton.setEnabled(nextPossible);
        this.lastButton.setEnabled(nextPossible);
        this.positionLabel.setText(posText);
        if (e != null) {
            String shortDesc = "Error showing selected item, try refreshing the servers object tree";
            LOG.log(Level.WARNING, shortDesc, e);
            sp = QStudioLauncher.ERR_REPORTER.getErrorReportLink(e, shortDesc);
        }
        this.add(sp, "Center");
        this.scrollPane = sp;
        this.revalidate();
    }
}

