/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qstudio.servertree;

import com.google.common.collect.ImmutableList;
import com.timestored.connections.ServerConfig;
import com.timestored.qstudio.QStudioModel;
import com.timestored.qstudio.model.AdminModel;
import com.timestored.qstudio.model.DatabaseDirector;
import com.timestored.qstudio.model.QEntity;
import com.timestored.qstudio.model.ServerModel;
import com.timestored.qstudio.model.ServerObjectTree;
import com.timestored.qstudio.model.ServerQEntity;
import com.timestored.qstudio.model.TableSQE;
import com.timestored.qstudio.servertree.ColNode;
import com.timestored.qstudio.servertree.CustomNode;
import com.timestored.theme.Icon;
import com.timestored.theme.Theme;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

class ObjectTreePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTree tree;
    private Set<String> hiddenNS;
    private final AdminModel adminModel;
    private final QStudioModel qStudioModel;
    private final List<DefaultMutableTreeNode> defaultNSnodes = new ArrayList<DefaultMutableTreeNode>();
    private ServerModel curServerModel;

    public ObjectTreePanel(QStudioModel qStudioModel) {
        this.qStudioModel = qStudioModel;
        this.adminModel = qStudioModel.getAdminModel();
        this.setLayout(new BorderLayout(4, 4));
        JPanel p = new JPanel();
        p.setPreferredSize(new Dimension(400, 400));
        this.add((Component)new JScrollPane(p), "Center");
        this.adminModel.addListener(new AdminModel.Listener(){

            @Override
            public void selectionChanged(ServerModel serverModel, AdminModel.Category category, String namespace, QEntity element) {
                if (serverModel != ObjectTreePanel.this.curServerModel) {
                    ObjectTreePanel.this.refreshGui();
                }
            }

            @Override
            public void modelChanged() {
                ObjectTreePanel.this.refreshGui();
            }

            @Override
            public void modelChanged(ServerModel sm) {
                ObjectTreePanel.this.refreshGui();
            }
        });
        this.refreshGui();
    }

    private void refreshGui() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ServerObjectTree soTree;
                DefaultMutableTreeNode top = new DefaultMutableTreeNode();
                ObjectTreePanel.this.defaultNSnodes.clear();
                ObjectTreePanel.this.curServerModel = ObjectTreePanel.this.adminModel.getServerModel();
                if (ObjectTreePanel.this.curServerModel != null && (soTree = ObjectTreePanel.this.curServerModel.getServerObjectTree()) != null) {
                    ObjectTreePanel.this.addNodes(top, ObjectTreePanel.this.curServerModel, soTree, ObjectTreePanel.this.hiddenNS);
                }
                ObjectTreePanel.this.tree = new JTree(top);
                JScrollPane treeView = new JScrollPane(ObjectTreePanel.this.tree);
                ObjectTreePanel.this.tree.setBorder(Theme.CENTRE_BORDER);
                CustomNode.configure(ObjectTreePanel.this.tree);
                for (DefaultMutableTreeNode dmtNode : ObjectTreePanel.this.defaultNSnodes) {
                    ObjectTreePanel.this.tree.expandPath(new TreePath(dmtNode.getPath()));
                }
                ObjectTreePanel.this.removeAll();
                ObjectTreePanel.this.add((Component)treeView, "Center");
                ObjectTreePanel.this.revalidate();
            }
        });
    }

    public void setHiddenNamespaces(Set<String> hiddenNS) {
        this.hiddenNS = hiddenNS;
        this.refreshGui();
    }

    private void addNodes(DefaultMutableTreeNode top, ServerModel sm, ServerObjectTree kdbServerObjects, Set<String> hiddenNS) {
        String serverName = sm.getName();
        Object[] namespaces = kdbServerObjects.getNamespaces().toArray(new String[0]);
        Arrays.sort(namespaces);
        DatabaseDirector.ActionsGenerator actionsGenerator = DatabaseDirector.getActionsGenerator(this.qStudioModel.getQueryManager(), this.adminModel, sm);
        for (Object ns : namespaces) {
            List<ServerQEntity> list;
            if (hiddenNS.contains(ns)) continue;
            NamespaceNode nsNode = new NamespaceNode((String)ns, sm.getServerConfig());
            DefaultMutableTreeNode nsTree = new DefaultMutableTreeNode(nsNode, true);
            if (((String)ns).equals(".")) {
                this.defaultNSnodes.add(nsTree);
            }
            for (TableSQE tableSQE : ObjectTreePanel.sorted(kdbServerObjects.getTables((String)ns))) {
                DefaultMutableTreeNode branch = new DefaultMutableTreeNode(new ServerQEntityNode(serverName, tableSQE));
                int i = tableSQE.isPartitioned() ? 0 : 1;
                for (String cn : tableSQE.getColNames()) {
                    ColNode colNode = new ColNode(actionsGenerator, tableSQE, cn, i++ == 0);
                    branch.add(new DefaultMutableTreeNode(colNode));
                }
                nsTree.add(branch);
            }
            for (ServerQEntity serverQEntity : kdbServerObjects.getViews((String)ns)) {
                nsTree.add(new DefaultMutableTreeNode(new ServerQEntityNode(serverName, serverQEntity)));
            }
            List<ServerQEntity> funcs = ObjectTreePanel.sorted(kdbServerObjects.getFunctions(new String[]{ns}));
            if (funcs.size() > 0) {
                nsTree.add(this.getBranch(serverName, "Functions", funcs));
            }
            if ((list = ObjectTreePanel.sorted(kdbServerObjects.getVariables((String)ns))).size() > 0) {
                nsTree.add(this.getBranch(serverName, "Variables", list));
            }
            top.add(nsTree);
        }
    }

    private static <T extends ServerQEntity> List<T> sorted(List<T> sqe) {
        ArrayList<T> tables = new ArrayList<T>(sqe);
        Collections.sort(tables, (a, b) -> a.getName().compareTo(b.getName()));
        return tables;
    }

    private void addScriptMenu(JPopupMenu menu, List<ServerQEntity.QQuery> qQueries) {
        if (qQueries.size() > 0) {
            JMenu scriptToWindowMenu = new JMenu("Script to Editor");
            scriptToWindowMenu.setIcon(Theme.CIcon.PAGE_CODE.get16());
            for (ServerQEntity.QQuery qquery : qQueries) {
                menu.add(new JMenuItem(new ElementAction(qquery, false)));
                scriptToWindowMenu.add(new JMenuItem(new ElementAction(qquery, true)));
            }
            menu.add(scriptToWindowMenu);
        }
    }

    private DefaultMutableTreeNode getBranch(String serverName, String branchTitle, List<ServerQEntity> elements) {
        DefaultMutableTreeNode branch = new DefaultMutableTreeNode(branchTitle);
        for (ServerQEntity ed : elements) {
            branch.add(new DefaultMutableTreeNode(new ServerQEntityNode(serverName, ed)));
        }
        return branch;
    }

    private class ElementAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private final String query;
        private final boolean insertText;

        public ElementAction(ServerQEntity.QQuery qquery, boolean insertText) {
            super(qquery.getTitle());
            Icon ic = qquery.getIcon();
            if (ic != null) {
                this.putValue("SmallIcon", ic.get16());
            }
            this.query = qquery.getQuery();
            this.insertText = insertText;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (this.insertText) {
                ObjectTreePanel.this.qStudioModel.getOpenDocumentsModel().insertSelectedText(this.query);
            } else {
                ObjectTreePanel.this.qStudioModel.getQueryManager().sendQuery(this.query);
            }
        }
    }

    private class ServerQEntityNode
    extends CustomNode {
        private final ServerQEntity sqe;
        private final String serverName;

        public ServerQEntityNode(String serverName, ServerQEntity sqe) {
            super(sqe.getName(), sqe.getHtmlDoc(true), sqe.getIcon());
            this.sqe = sqe;
            this.serverName = serverName;
            if (sqe.getType().isList()) {
                this.setText("<html><b>" + sqe.getName() + "</b></html>");
            }
        }

        @Override
        public void doSelectionAction() {
            ObjectTreePanel.this.adminModel.setSelectedElement(this.serverName, this.sqe.getNamespace(), this.sqe);
        }

        @Override
        public void addMenuItems(JPopupMenu menu) {
            ObjectTreePanel.this.addScriptMenu(menu, this.sqe.getQQueries());
        }
    }

    private class NamespaceNode
    extends CustomNode {
        private final String ns;
        private final ServerConfig serverConfig;

        public NamespaceNode(String ns, ServerConfig serverConfig) {
            super(ns);
            this.ns = ns;
            this.serverConfig = serverConfig;
        }

        @Override
        public void doSelectionAction() {
            ObjectTreePanel.this.adminModel.setSelectedNamespace(this.serverConfig.getName(), this.ns);
        }

        @Override
        public void addMenuItems(JPopupMenu menu) {
            ServerQEntity.QQuery qq = new ServerQEntity.QQuery("Delete all variables from Namespace", Theme.CIcon.DELETE, "delete from `" + this.ns);
            ObjectTreePanel.this.addScriptMenu(menu, ImmutableList.of(qq));
        }
    }
}

