/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qstudio.servertree;

import com.timestored.kdb.KdbConnection;
import com.timestored.qstudio.QStudioLauncher;
import com.timestored.qstudio.kdb.KdbHelper;
import com.timestored.qstudio.model.AdminModel;
import com.timestored.theme.Theme;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import jsyntaxpane.DefaultSyntaxKit;
import kx.c;

class FunctionEditingPanel
extends JPanel {
    private static final Logger LOG = Logger.getLogger(FunctionEditingPanel.class.getName());
    private static final long serialVersionUID = 1L;
    private final String queryName;
    private final JEditorPane codeEditor;
    private final JPanel descContainerPanel;
    private String lastSeenText = "";
    private FunctionValue funcVal;
    private final AdminModel adminModel;

    public FunctionEditingPanel(AdminModel adminModel, String queryName) throws IOException, c.KException {
        this.queryName = queryName;
        this.adminModel = adminModel;
        this.setLayout(new BorderLayout(4, 4));
        JToolBar toolbar = new JToolBar();
        final JButton saveButton = new JButton("Save", Theme.CIcon.SAVE.get());
        saveButton.setEnabled(false);
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FunctionEditingPanel.this.save();
            }
        });
        JButton deleteButton = new JButton("Delete", Theme.CIcon.DELETE.get());
        toolbar.add(saveButton);
        toolbar.add(deleteButton);
        DefaultSyntaxKit.initKit();
        this.codeEditor = new JEditorPane();
        JScrollPane scrPane = new JScrollPane(this.codeEditor);
        scrPane.setHorizontalScrollBarPolicy(31);
        this.codeEditor.setContentType("text/qsql");
        this.codeEditor.setText("");
        this.codeEditor.setFont(UIManager.getFont("defaultFont"));
        this.codeEditor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                saveButton.setEnabled(!FunctionEditingPanel.this.codeEditor.getText().equals(FunctionEditingPanel.this.lastSeenText));
            }
        });
        this.descContainerPanel = new JPanel(new FlowLayout(0));
        this.add((Component)this.descContainerPanel, "North");
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)scrPane, "Center");
        p.add((Component)toolbar, "South");
        this.add((Component)p, "Center");
        this.refresh();
    }

    private void save() {
        try {
            String saveQuery = "{system \"d ." + this.funcVal.namespace + "\";set[`" + this.adminModel.getSelectedElement().getName() + "; value\"" + KdbHelper.escape(this.codeEditor.getText()) + "\"];system \"d .\"}[]";
            LOG.info("saveQuery = " + saveQuery);
            this.adminModel.getKdbConnection().query(saveQuery);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Error saving function");
        }
        catch (c.KException e) {
            JOptionPane.showMessageDialog(null, e.toString());
        }
        this.refresh();
    }

    private void refresh() {
        Exception e = null;
        try {
            KdbConnection conn = this.adminModel.getKdbConnection();
            this.descContainerPanel.removeAll();
            if (conn != null) {
                Object res = conn.query("1_value " + this.queryName);
                this.funcVal = new FunctionValue(res);
                JPanel descriptionPanel = new JPanel(new GridLayout(4, 2, 4, 4));
                this.addToGrid(descriptionPanel, "Parameters:", this.csvSeparate(this.funcVal.params));
                this.addToGrid(descriptionPanel, "Locals:", this.csvSeparate(this.funcVal.locals));
                this.addToGrid(descriptionPanel, "Globals:", this.csvSeparate(this.funcVal.globals));
                this.addToGrid(descriptionPanel, "Namespace:", this.funcVal.namespace);
                this.descContainerPanel.add(descriptionPanel);
                this.lastSeenText = this.funcVal.definition;
                this.codeEditor.setText(this.funcVal.definition);
            } else {
                this.codeEditor.setText("Could not get connection");
            }
        }
        catch (Exception ex) {
            e = ex;
        }
        if (e != null) {
            String shortDesc = "Error showing selected item, try refreshing the servers object tree.";
            this.codeEditor.setText(shortDesc);
            LOG.log(Level.WARNING, shortDesc, e);
            this.add(QStudioLauncher.ERR_REPORTER.getErrorReportLink(e, shortDesc));
        }
        this.revalidate();
    }

    private void addToGrid(JPanel gridPanel, String title, String value) {
        JLabel titleLabel = new JLabel(title);
        Font f = titleLabel.getFont();
        f = new Font(f.getName(), 1, f.getSize());
        titleLabel.setFont(f);
        gridPanel.add(new JLabel(title));
        gridPanel.add(new JLabel(value));
    }

    private String csvSeparate(String[] stringA) {
        String wholeString = "";
        if (stringA != null && stringA.length > 0) {
            for (int i = 0; i < stringA.length - 1; ++i) {
                wholeString = wholeString + stringA[i] + ", ";
            }
            wholeString = wholeString + stringA[stringA.length - 1];
        }
        return wholeString;
    }

    private class FunctionValue {
        public static final String GET_DEF_Q = "1_value ";
        public final String[] params;
        public final String[] locals;
        public final String[] globals;
        public final Object[] definedValues;
        public final String definition;
        public final String namespace;

        public FunctionValue(Object kObject) {
            int i;
            Object[] data = (Object[])kObject;
            this.params = (String[])data[0];
            this.locals = (String[])data[1];
            String[] temp = (String[])data[2];
            this.globals = new String[temp.length - 1];
            for (i = 1; i < temp.length; ++i) {
                this.globals[i - 1] = temp[i];
            }
            this.namespace = temp[0];
            this.definedValues = new Object[data.length - 4];
            for (i = 0; i < this.definedValues.length; ++i) {
                this.definedValues[i] = data[2 + i];
            }
            this.definition = new String((char[])data[data.length - 1]);
        }
    }
}

