/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qstudio.servertree;

import com.timestored.connections.JdbcTypes;
import com.timestored.connections.ServerConfig;
import com.timestored.qstudio.kdb.CAtomTypes;
import com.timestored.qstudio.model.AdminModel;
import com.timestored.qstudio.model.QueryManager;
import com.timestored.qstudio.model.ServerQEntity;
import com.timestored.qstudio.servertree.DefaultElementDisplayStrategy;
import com.timestored.qstudio.servertree.FunctionEditingPanel;
import com.timestored.qstudio.servertree.PagingTablePanel;
import com.timestored.sqldash.chart.ChartTheme;
import com.timestored.sqldash.chart.TableFactory;
import com.timestored.theme.Theme;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.rowset.CachedRowSet;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kx.c;

class ElementDisplayFactory {
    private static final Logger LOG = Logger.getLogger(ElementDisplayFactory.class.getName());

    ElementDisplayFactory() {
    }

    private static Box getActionButtons(QueryManager queryManager, List<ServerQEntity.QQuery> qQueryies) {
        Box b = Box.createHorizontalBox();
        for (ServerQEntity.QQuery qQuery : qQueryies) {
            if (qQuery.getTitle().toLowerCase().contains("delete")) continue;
            JButton but = new JButton(qQuery.getTitle(), qQuery.getIcon().get16());
            but.setToolTipText("Run query:\r\n" + qQuery.getQuery());
            JButton copyBut = new JButton("", Theme.CIcon.EDIT_COPY.get16());
            copyBut.setToolTipText("Copy query to Clipboard:\r\n" + qQuery.getQuery());
            but.addActionListener(e -> queryManager.sendQuery(qQuery.getQuery()));
            copyBut.addActionListener(e -> {
                Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
                clpbrd.setContents(new StringSelection(qQuery.getQuery()), null);
            });
            b.add(copyBut);
            b.add(but);
        }
        return b;
    }

    public static Component getPanel(AdminModel adminModel, QueryManager queryManager, ChartTheme chartTheme) {
        Component retComponent = null;
        try {
            retComponent = ElementDisplayFactory.getCustomizedEditor(adminModel, queryManager, chartTheme);
        }
        catch (c.KException e) {
            retComponent = ElementDisplayFactory.handleException(adminModel, queryManager, chartTheme);
        }
        catch (IOException e) {
            retComponent = ElementDisplayFactory.handleException(adminModel, queryManager, chartTheme);
        }
        if (retComponent == null) {
            retComponent = DefaultElementDisplayStrategy.INSTANCE.getPanel(adminModel);
        }
        return retComponent;
    }

    private static Component handleException(AdminModel adminModel, QueryManager queryManager, ChartTheme chartTheme) {
        Component retComponent = null;
        adminModel.refresh();
        try {
            retComponent = ElementDisplayFactory.getCustomizedEditor(adminModel, queryManager, chartTheme);
        }
        catch (c.KException e) {
            LOG.log(Level.WARNING, "error using proposed Element Display Strategy", e);
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "error using proposed Element Display Strategy", e);
        }
        if (retComponent == null) {
            JPanel panel = new JPanel();
            JLabel label = new JLabel("Problem viewing this element, likely that thewrong type was assumed. Try refreshing the tree and then selecting thiselement again.");
            panel.add(label);
            retComponent = panel;
        }
        return retComponent;
    }

    private static Component getCustomizedEditor(AdminModel adminModel, QueryManager queryManager, ChartTheme chartTheme) throws IOException, c.KException {
        ServerQEntity elementDetails = adminModel.getSelectedElement();
        String queryName = elementDetails.getFullName();
        if (adminModel.getServerModel().getServerConfig().isKDB()) {
            if (elementDetails.isTable()) {
                JPanel p = new JPanel(new BorderLayout());
                p.add((Component)ElementDisplayFactory.getActionButtons(queryManager, elementDetails.getQQueries()), "North");
                p.add((Component)new PagingTablePanel(adminModel, queryName), "Center");
                return p;
            }
            if (elementDetails.getType().equals((Object)CAtomTypes.LAMBDA)) {
                return new FunctionEditingPanel(adminModel, queryName);
            }
        } else if (elementDetails.isTable() || adminModel.getServerModel().getServerConfig().getJdbcType().equals((Object)JdbcTypes.DOLPHINDB)) {
            return new NonkdbTablePanel(adminModel, queryManager, elementDetails, chartTheme);
        }
        return null;
    }

    private static class NonkdbTablePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public NonkdbTablePanel(AdminModel adminModel, QueryManager queryManager, ServerQEntity serverEntity, ChartTheme chartTheme) {
            this.setLayout(new BorderLayout());
            try {
                if (serverEntity.getQQueries().size() > 0) {
                    ServerConfig sc = adminModel.getServerModel().getServerConfig();
                    List<ServerQEntity.QQuery> qQueryies = serverEntity.getQQueries();
                    if (qQueryies.size() > 0) {
                        this.add((Component)ElementDisplayFactory.getActionButtons(queryManager, qQueryies), "North");
                        ServerQEntity.QQuery qQuery = serverEntity.getQQueries().get(0);
                        String sqlQuery = qQuery.getQuery();
                        CachedRowSet r = adminModel.getConnectionManager().executeQuery(sc, sqlQuery);
                        this.add(TableFactory.getTable(r, 10000), "Center");
                        this.revalidate();
                    }
                }
            }
            catch (IOException | SQLException exception) {
                // empty catch block
            }
        }
    }
}

