/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qstudio.servertree;

import com.timestored.kdb.KdbConnection;
import com.timestored.qstudio.QStudioLauncher;
import com.timestored.qstudio.model.AdminModel;
import com.timestored.qstudio.servertree.ElementDisplayStrategy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import javax.activation.UnsupportedDataTypeException;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import jsyntaxpane.DefaultSyntaxKit;
import kx.c;

enum DefaultElementDisplayStrategy implements ElementDisplayStrategy
{
    INSTANCE;

    private static final String REFRESH_SERVER = "Unable to display object, <br />try refreshing the server tree and viewing it again.";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JPanel getPanel(AdminModel adminModel) {
        JPanel panel = new JPanel(new BorderLayout(4, 4));
        Exception e = null;
        String errMsg = REFRESH_SERVER;
        if (adminModel.getSelectedElement() != null) {
            KdbConnection conn = null;
            try {
                String q = "-2_.Q.s " + adminModel.getSelectedElement().getFullName();
                conn = adminModel.getKdbConnection();
                if (conn == null) {
                    panel.add(new JLabel("Could not get connection to server."));
                } else {
                    Object o = conn.query(q);
                    if (!(o instanceof char[])) {
                        String msg = "DefaultElementDisplayStrategy expected char[] got: " + (o == null ? "null" : o.toString());
                        throw new UnsupportedDataTypeException(msg);
                    }
                    String text = new String((char[])o);
                    DefaultSyntaxKit.initKit();
                    JEditorPane codeEditor = new JEditorPane();
                    JScrollPane scrPane = new JScrollPane(codeEditor);
                    scrPane.setHorizontalScrollBarPolicy(31);
                    panel.add((Component)scrPane, "Center");
                    codeEditor.setContentType("text/qsql");
                    codeEditor.setText(text);
                    codeEditor.setFont(UIManager.getFont("defaultFont"));
                    codeEditor.setEditable(false);
                }
            }
            catch (c.KException ke) {
                e = ke;
                errMsg = "kdb exception:" + ke.getMessage() + " Check server settings and refresh.";
            }
            catch (Exception ee) {
                e = ee;
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (IOException ke) {}
                }
            }
            if (e != null) {
                panel.add(QStudioLauncher.ERR_REPORTER.getErrorReportLink(e, errMsg));
            }
        }
        return panel;
    }
}

