/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qstudio.servertree;

import com.google.common.base.Preconditions;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;

class CustomNode {
    private String title;
    private String tooltip;
    private ImageIcon icon;
    private static final DefaultTreeCellRenderer RENDERER = new CustomNodeRenderer();

    public CustomNode(String title) {
        this(title, null, null);
    }

    public CustomNode(String title, String tooltip, ImageIcon icon) {
        this.title = Preconditions.checkNotNull(title);
        this.tooltip = tooltip;
        this.icon = icon;
    }

    protected void setText(String title) {
        this.title = title;
    }

    public String getText() {
        return this.title;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public void doSelectionAction() {
    }

    public void addMenuItems(JPopupMenu menu) {
    }

    public static void configure(JTree tree) {
        ToolTipManager.sharedInstance().registerComponent(tree);
        tree.setCellRenderer(RENDERER);
        tree.getSelectionModel().setSelectionMode(1);
        tree.addTreeSelectionListener(new CustomNodeTreeSelectionListener(tree));
        tree.addMouseListener(new CustomNodePopupMenuListener(tree));
    }

    private static class CustomNodePopupMenuListener
    extends MouseAdapter {
        private final JTree tree;

        public CustomNodePopupMenuListener(JTree tree) {
            this.tree = tree;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.handle(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.handle(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.handle(e);
        }

        private void handle(MouseEvent e) {
            CustomNode cNode = this.getCustomNodeClickedOn(e);
            if (cNode != null && e.isPopupTrigger()) {
                this.showPopupMenu(cNode, e);
            }
        }

        private CustomNode getCustomNodeClickedOn(MouseEvent e) {
            TreePath selPath;
            DefaultMutableTreeNode curNode;
            Object obj;
            int y;
            int x = e.getX();
            int selRow = this.tree.getRowForLocation(x, y = e.getY());
            if (selRow != -1 && (obj = (curNode = (DefaultMutableTreeNode)(selPath = this.tree.getPathForLocation(x, y)).getLastPathComponent()).getUserObject()) instanceof CustomNode) {
                return (CustomNode)obj;
            }
            return null;
        }

        private void showPopupMenu(CustomNode cNode, MouseEvent e) {
            JPopupMenu menu = new JPopupMenu("Popup");
            cNode.addMenuItems(menu);
            if (menu.getComponentCount() > 0) {
                menu.show(e.getComponent(), e.getX(), e.getY());
                menu.setVisible(true);
            }
        }
    }

    private static class CustomNodeTreeSelectionListener
    implements TreeSelectionListener {
        private final JTree tree;

        public CustomNodeTreeSelectionListener(JTree tree) {
            this.tree = tree;
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
            if (node != null && node.getUserObject() instanceof CustomNode) {
                ((CustomNode)node.getUserObject()).doSelectionAction();
            }
        }
    }

    private static class CustomNodeRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node;
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            this.setToolTipText(null);
            if (value instanceof DefaultMutableTreeNode && (node = (DefaultMutableTreeNode)value).getUserObject() instanceof CustomNode) {
                CustomNode cn = (CustomNode)node.getUserObject();
                this.setText(cn.getText());
                this.setToolTipText(cn.getTooltip());
                if (cn.getIcon() != null) {
                    this.setIcon(cn.getIcon());
                }
            }
            return this;
        }
    }
}

