/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qstudio.qdoc;

import com.timestored.connections.JdbcIcons;
import com.timestored.connections.ServerConfig;
import com.timestored.qdoc.DocCompleter;
import com.timestored.qdoc.DocumentedEntity;
import com.timestored.qstudio.Language;
import com.timestored.qstudio.QStudioModel;
import com.timestored.qstudio.model.ServerQEntity;
import com.timestored.sqldash.theme.DBIcons;
import com.timestored.theme.Icon;
import com.timestored.theme.Theme;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import lombok.NonNull;

public class ContextualDocCompleter
implements DocCompleter {
    @NonNull
    private final QStudioModel qStudioModel;
    private static final String[] pulseChartTypes = new String[]{"grid", "timeseries", "area", "line", "bar", "stack", "bar_horizontal", "stack_horizontal", "pie", "scatter", "bubble", "candle", "depthmap", "radar", "treemap", "heatmap", "calendar", "boxplot", "3dsurface", "3dbar", "sunburst", "tree", "metrics", "sankey"};
    private static final Icon[] pulseChartIcons = new Icon[]{Theme.CIcon.TABLE_ELEMENT, Theme.CIcon.CHART_CURVE, DBIcons.CHART_AREA, DBIcons.CHART_LINE, DBIcons.CHART_BAR, DBIcons.CHART_BAR, DBIcons.CHART_BAR, DBIcons.CHART_BAR, DBIcons.CHART_PIE, DBIcons.CHART_SCATTER_PLOT, DBIcons.CHART_BUBBLE, DBIcons.CHART_CANDLESTICK, null, null, null, DBIcons.CHART_HEATMAP, null, null, null, null, null, null, null, null};

    @Override
    public List<DocumentedEntity> findByPrefix(String txt, int caratPos) {
        ArrayList<DocumentedEntity> l = new ArrayList<DocumentedEntity>();
        if (caratPos <= txt.length()) {
            String fileEnding = this.qStudioModel.getOpenDocumentsModel().getSelectedDocument().getFileEnding();
            Language language = Language.getLanguage(fileEnding);
            String pre = txt.substring(0, caratPos);
            if (language.equals((Object)Language.MARKDOWN)) {
                int p = pre.lastIndexOf(10);
                String afterNL = (p >= 0 ? pre.substring(p) : pre).trim();
                int q = pre.lastIndexOf(32);
                String afterSpace = (q >= 0 ? pre.substring(q) : pre).trim();
                if (afterNL.equals("`") || afterNL.equals("``") || afterNL.equals("```")) {
                    for (ServerQEntity sqe : this.qStudioModel.getAdminModel().getAllVariables()) {
                        if (!sqe.isTable() || sqe.getQQueries().size() <= 0) continue;
                        String srvr = this.qStudioModel.getQueryManager().getSelectedServerName();
                        ServerQEntity.QQuery qqry = sqe.getQQueries().get(0);
                        String code = "```sql type='grid' server='" + srvr + "' \n" + qqry.getQuery() + "\n```\n";
                        l.add(new FakeDocumentedEntity(code.substring(afterNL.length()), Theme.CIcon.MARKDOWN_GREY));
                    }
                } else if (afterSpace.equals("type='") || afterSpace.equals("type=\"")) {
                    for (int i = 0; i < pulseChartTypes.length; ++i) {
                        String code = afterSpace + pulseChartTypes[i];
                        l.add(new FakeDocumentedEntity(code.substring(afterSpace.length()), pulseChartIcons[i]));
                    }
                } else if (afterSpace.equals("server='") || afterSpace.equals("server=\"")) {
                    for (ServerConfig sc : this.qStudioModel.getConnectionManager().getServerConnections()) {
                        String code = afterSpace + sc.getName();
                        JdbcIcons icon = JdbcIcons.getIconFor(sc.getJdbcType());
                        l.add(new FakeDocumentedEntity(code.substring(afterSpace.length()), icon));
                    }
                }
            }
            if (pre.toUpperCase().endsWith(" FROM ")) {
                for (ServerQEntity sqe : this.qStudioModel.getAdminModel().getAllVariables()) {
                    if (!sqe.isTable()) continue;
                    String code = sqe.getFullName();
                    l.add(new FakeDocumentedEntity(code, Theme.CIcon.TABLE_ELEMENT));
                }
            }
        }
        return l;
    }

    public ContextualDocCompleter(@NonNull QStudioModel qStudioModel) {
        if (qStudioModel == null) {
            throw new NullPointerException("qStudioModel is marked non-null but is null");
        }
        this.qStudioModel = qStudioModel;
    }

    private static class FakeDocumentedEntity
    implements DocumentedEntity {
        private final String fullName;
        private final Icon icon;
        private String source = "Server";
        private DocumentedEntity.SourceType sourceType = DocumentedEntity.SourceType.SERVER;

        @Override
        public String getDocName() {
            return this.fullName;
        }

        @Override
        public String getHtmlDoc(boolean shortFormat) {
            return this.fullName;
        }

        @Override
        public ImageIcon getIcon() {
            return this.icon == null ? Theme.CIcon.MARKDOWN_GREY.get16() : this.icon.get16();
        }

        public FakeDocumentedEntity(String fullName, Icon icon) {
            this.fullName = fullName;
            this.icon = icon;
        }

        @Override
        public String getFullName() {
            return this.fullName;
        }

        @Override
        public String getSource() {
            return this.source;
        }

        @Override
        public DocumentedEntity.SourceType getSourceType() {
            return this.sourceType;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public void setSourceType(DocumentedEntity.SourceType sourceType) {
            this.sourceType = sourceType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FakeDocumentedEntity)) {
                return false;
            }
            FakeDocumentedEntity other = (FakeDocumentedEntity)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$fullName = this.getFullName();
            String other$fullName = other.getFullName();
            if (this$fullName == null ? other$fullName != null : !this$fullName.equals(other$fullName)) {
                return false;
            }
            ImageIcon this$icon = this.getIcon();
            ImageIcon other$icon = other.getIcon();
            if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
                return false;
            }
            String this$source = this.getSource();
            String other$source = other.getSource();
            if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
                return false;
            }
            DocumentedEntity.SourceType this$sourceType = this.getSourceType();
            DocumentedEntity.SourceType other$sourceType = other.getSourceType();
            return !(this$sourceType == null ? other$sourceType != null : !((Object)((Object)this$sourceType)).equals((Object)other$sourceType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FakeDocumentedEntity;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $fullName = this.getFullName();
            result = result * 59 + ($fullName == null ? 43 : $fullName.hashCode());
            ImageIcon $icon = this.getIcon();
            result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
            String $source = this.getSource();
            result = result * 59 + ($source == null ? 43 : $source.hashCode());
            DocumentedEntity.SourceType $sourceType = this.getSourceType();
            result = result * 59 + ($sourceType == null ? 43 : ((Object)((Object)$sourceType)).hashCode());
            return result;
        }

        public String toString() {
            return "ContextualDocCompleter.FakeDocumentedEntity(fullName=" + this.getFullName() + ", icon=" + this.getIcon() + ", source=" + this.getSource() + ", sourceType=" + (Object)((Object)this.getSourceType()) + ")";
        }
    }
}

