/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qstudio.model;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.timestored.connections.JdbcTypes;
import com.timestored.connections.MetaInfo;
import com.timestored.misc.HtmlUtils;
import com.timestored.qstudio.kdb.CAtomTypes;
import com.timestored.qstudio.model.BaseSQE;
import com.timestored.qstudio.model.ServerQEntity;
import com.timestored.theme.Theme;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.ImageIcon;
import lombok.NonNull;

public class TableSQE
extends BaseSQE {
    private final long count;
    private final boolean isPartitioned;
    private final List<String> colNames;
    @NonNull
    private final JdbcTypes jdbcTypes;

    TableSQE(String serverName, String namespace, String name, CAtomTypes type, long count, boolean isPartitioned, String[] colNames, JdbcTypes jdbcTypes) {
        super(serverName, namespace, name, type, jdbcTypes);
        Preconditions.checkArgument(count >= -2L);
        Preconditions.checkNotNull(colNames);
        Preconditions.checkArgument(colNames.length > 0);
        CAtomTypes t = this.getType();
        Preconditions.checkArgument(t.equals((Object)CAtomTypes.TABLE) || t.equals((Object)CAtomTypes.DICTIONARY));
        this.count = count;
        this.isPartitioned = isPartitioned;
        this.colNames = Arrays.asList(colNames);
        this.jdbcTypes = jdbcTypes == null ? JdbcTypes.KDB : jdbcTypes;
    }

    @Override
    public boolean isTable() {
        return true;
    }

    @Override
    public ImageIcon getIcon() {
        return this.count == -2L ? Theme.CIcon.TABLE_DELETE.get16() : Theme.CIcon.TABLE_ELEMENT.get16();
    }

    @Override
    public String toString() {
        return "TableSQE[" + this.getName() + " count=" + this.count + " cols=" + Joiner.on(",").join(this.colNames) + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof TableSQE) {
            TableSQE that = (TableSQE)o;
            return super.equals(o) && Objects.equal(this.colNames, that.colNames) && Objects.equal(this.isPartitioned, that.isPartitioned) && Objects.equal(this.count, that.count);
        }
        return false;
    }

    @Override
    public String getHtmlDoc(boolean shortFormat) {
        String t = (this.getType().equals((Object)CAtomTypes.DICTIONARY) ? "Keyed " : "") + "Table";
        String colHtml = TableSQE.getColumnHtml(this.colNames, shortFormat || this.colNames.size() > 9);
        String s = "";
        if (!shortFormat) {
            ImmutableMap<String, String> namesToDescs = ImmutableMap.of("Name: ", this.getDocName(), "Type: ", t, "Count: ", this.count == -1L ? "unknown" : "" + this.count, "Partitioned: ", this.isPartitioned ? "Yes" : "No", "Columns: ", colHtml);
            s = TableSQE.toHtml(namesToDescs);
        } else {
            s = "<html><body> " + t + " ";
            if (this.count != -1L) {
                s = s + this.count + " rows ";
            }
            s = s + (this.isPartitioned ? "Partitioned" : "") + "<br />Columns: " + colHtml + "</body></html>";
        }
        return s;
    }

    private static String getColumnHtml(List<String> colNames, boolean shortFormat) {
        String colHtml;
        if (shortFormat) {
            StringBuilder sb = new StringBuilder(colNames.size() * 8);
            for (int i = 0; i < colNames.size() - 1; ++i) {
                sb.append(colNames.get(i)).append(", ");
                if (5 == i % 6) {
                    sb.append("<br />");
                }
                if (i <= 23) continue;
                sb.append(".... ");
                break;
            }
            sb.append(colNames.get(colNames.size() - 1));
            colHtml = sb.toString();
        } else {
            colHtml = HtmlUtils.toList(colNames);
        }
        return colHtml;
    }

    @Override
    public List<ServerQEntity.QQuery> getQQueries() {
        ArrayList<ServerQEntity.QQuery> r = new ArrayList<ServerQEntity.QQuery>();
        String fn = this.getFullName();
        r.add(new ServerQEntity.QQuery("Select Top 1000", Theme.CIcon.TABLE_ELEMENT, MetaInfo.getTop100Query(this.jdbcTypes, this.colNames, fn, this.isPartitioned, false)));
        r.add(new ServerQEntity.QQuery("Select Col1,Col2... from Top 1000", Theme.CIcon.TABLE_ELEMENT, MetaInfo.getTop100Query(this.jdbcTypes, this.colNames, fn, this.isPartitioned, true)));
        r.add(new ServerQEntity.QQuery("Count", Theme.CIcon.TABLE_ELEMENT, MetaInfo.getCountQuery(this.jdbcTypes, fn)));
        if (this.jdbcTypes.isKDB()) {
            r.add(new ServerQEntity.QQuery("Select Bottom 1000", Theme.CIcon.TABLE_ELEMENT, MetaInfo.getBottom100query(this.jdbcTypes, this.colNames, fn, this.isPartitioned, false)));
            r.addAll(super.getQQueries());
        }
        return r;
    }

    @Override
    public long getCount() {
        return this.count;
    }

    public boolean isPartitioned() {
        return this.isPartitioned;
    }

    public List<String> getColNames() {
        return this.colNames;
    }
}

