/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qstudio.model;

import com.google.common.base.Joiner;
import com.timestored.misc.HtmlUtils;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class TableModelHtmlConverter {
    private IndentingAppender sb = new IndentingAppender();

    private TableModelHtmlConverter() {
    }

    private IndentingAppender wrap(String tag, String inner) {
        return this.sb.b("<" + tag + ">").b(HtmlUtils.escapeHTML(inner)).b("</" + tag + ">");
    }

    private String convertTable(ResultSet rs2) throws SQLException {
        int c2;
        this.sb.start("<table>");
        this.sb.a("<tr>");
        ResultSetMetaData tm = rs2.getMetaData();
        for (c2 = 1; c2 <= tm.getColumnCount(); ++c2) {
            this.wrap("th", tm.getColumnName(c2));
        }
        this.sb.b("</tr>");
        while (rs2.next()) {
            this.sb.start("<tr>");
            for (c2 = 1; c2 <= tm.getColumnCount(); ++c2) {
                String s;
                this.sb.a();
                Object o = rs2.getObject(c2);
                String string = s = o == null ? rs2.getString(c2) : "" + o.toString();
                if (o == null) {
                    s = "";
                } else if (o instanceof String) {
                    s = (String)o;
                } else if (o instanceof char[]) {
                    s = new String((char[])o);
                } else if (o instanceof String[]) {
                    Object[] v = (String[])o;
                    s = "`" + Joiner.on('`').join(v);
                }
                this.wrap("td", s);
            }
            this.sb.end("</tr>");
        }
        this.sb.end("</table>");
        return this.sb.toString();
    }

    public static String convert(ResultSet rs2) throws SQLException {
        return new TableModelHtmlConverter().convertTable(rs2);
    }

    private static class IndentingAppender {
        private String indent = "";
        private StringBuilder sb = new StringBuilder();

        private IndentingAppender() {
        }

        IndentingAppender a() {
            return this.a("");
        }

        IndentingAppender a(String s) {
            return this.b("\r\n").b(this.indent).b(s);
        }

        IndentingAppender b(String s) {
            this.sb.append(s);
            return this;
        }

        IndentingAppender start(String s) {
            return this.a(s).increaseIndent();
        }

        IndentingAppender end(String s) {
            return this.decreaseIndent().a(s);
        }

        private IndentingAppender increaseIndent() {
            this.indent = this.indent + "\t";
            return this;
        }

        private IndentingAppender decreaseIndent() {
            this.indent = this.indent.substring(1);
            return this;
        }

        public String toString() {
            return this.sb.toString();
        }
    }
}

